/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.mp.PacketScreenAction;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.covers.RedstoneCover;
import sunsetsatellite.signalindustries.covers.SwitchCover;
import sunsetsatellite.signalindustries.tiles.base.TileEntityCoverable;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ScreenSwitchCoverConfig
extends Screen {
    public int xSize = 176;
    public int ySize = 90;
    public SwitchCover cover;
    public Player player;
    public TileEntityTieredMachineBase tile;

    public ScreenSwitchCoverConfig(ContainerInventory playerInv, TileEntity tile, CompoundTag data) {
        this.player = playerInv.player;
        this.tile = (TileEntityTieredMachineBase)tile;
        this.cover = (SwitchCover)((TileEntityCoverable)tile).getCovers().get(Direction.values()[data.getInteger("side")]);
    }

    public void render(int mouseX, int mouseY, float renderPartialTicks) {
        this.renderBackground();
        int centerX = (this.width - this.xSize) / 2;
        int centerY = (this.height - this.ySize) / 2;
        this.drawGuiContainerBackgroundLayer(renderPartialTicks);
        GL11.glPushMatrix();
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Lighting.enableInventoryLight();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)centerX, (float)centerY, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        GL11.glDisable((int)32826);
        Lighting.disable();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.drawGuiContainerForegroundLayer();
        GL11.glPopMatrix();
        super.render(mouseX, mouseY, renderPartialTicks);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        @NotNull Texture i = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/config.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(i);
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
    }

    protected void drawGuiContainerForegroundLayer() {
        this.font.drawString("Configure: Switch", 45, 6, -12566464);
        if (this.tile.hasCoverAnywhere(RedstoneCover.class)) {
            this.font.drawString("Control by Redstone Cover?", 20, 50, -12566464);
        }
    }

    public void init() {
        if (this.tile.hasCoverAnywhere(RedstoneCover.class)) {
            this.buttons.add(new ButtonElement(0, this.width / 2 - 15, this.height / 2 - 25, 30, 20, this.tile.disabled ? "OFF" : "ON"));
            this.buttons.add(new ButtonElement(1, this.width / 2 - 15, this.height / 2 + 20, 30, 20, this.cover.controlledByRedstone ? "Yes" : "No"));
        } else {
            this.buttons.add(new ButtonElement(0, this.width / 2 - 15, this.height / 2 - 10, 30, 20, this.tile.disabled ? "OFF" : "ON"));
        }
        if (this.cover.controlledByRedstone) {
            ((ButtonElement)this.buttons.get((int)0)).enabled = false;
        }
        super.init();
    }

    protected void buttonClicked(ButtonElement button) {
        switch (button.id) {
            case 0: {
                this.tile.disabled = !this.tile.disabled;
                button.displayString = this.tile.disabled ? "OFF" : "ON";
                break;
            }
            case 1: {
                this.cover.controlledByRedstone = !this.cover.controlledByRedstone;
                button.displayString = this.cover.controlledByRedstone ? "Yes" : "No";
                boolean bl = ((ButtonElement)this.buttons.get((int)0)).enabled = !this.cover.controlledByRedstone;
            }
        }
        if (EnvironmentHelper.isClientWorld()) {
            NetworkHandler.sendToServer((NetworkMessage)new PacketScreenAction(button.id, 0, 100 + this.cover.getDir().getSideNumber(), new Vec3i(this.tile.x, this.tile.y, this.tile.z), this.tile.getClass()));
        }
    }
}

