/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.sound.SoundCategory;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.mp.PacketScreenAction;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.covers.VoidCover;
import sunsetsatellite.signalindustries.tiles.base.TileEntityCoverable;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ScreenVoidCoverConfig
extends Screen {
    public int xSize = 176;
    public int ySize = 90;
    public VoidCover cover;
    public Player player;
    public TileEntityCoverable tile;

    public ScreenVoidCoverConfig(ContainerInventory playerInv, TileEntity tile, CompoundTag data) {
        this.player = playerInv.player;
        this.tile = (TileEntityCoverable)tile;
        this.cover = (VoidCover)((TileEntityCoverable)tile).getCovers().get(Direction.values()[data.getInteger("side")]);
    }

    public void render(int mouseX, int mouseY, float renderPartialTicks) {
        this.renderBackground();
        int centerX = (this.width - this.xSize) / 2;
        int centerY = (this.height - this.ySize) / 2;
        this.drawGuiContainerBackgroundLayer(renderPartialTicks);
        GL11.glPushMatrix();
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Lighting.enableInventoryLight();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)centerX, (float)centerY, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        GL11.glDisable((int)32826);
        Lighting.disable();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.drawGuiContainerForegroundLayer();
        GL11.glPopMatrix();
        super.render(mouseX, mouseY, renderPartialTicks);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        @NotNull Texture i = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/config.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(i);
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
    }

    protected void drawGuiContainerForegroundLayer() {
        this.font.drawString("Configure: Voiding", 45, 6, -12566464);
        this.font.drawString("Item Slot", this.xSize / 2 - 50, 23, -12566464);
        this.font.drawString("Fluid Slot", this.xSize / 2 + 10, 23, -12566464);
        this.font.drawString("Activate", this.xSize / 2 - 20, 60, -12566464);
    }

    public void init() {
        String voidSlotItemStr = this.cover.voidingItemSlot == -2 ? "*" : (this.cover.voidingItemSlot == -1 ? "X" : String.valueOf(this.cover.voidingItemSlot));
        String voidSlotFluidStr = this.cover.voidingFluidSlot == -2 ? "*" : (this.cover.voidingFluidSlot == -1 ? "X" : String.valueOf(this.cover.voidingFluidSlot));
        this.buttons.add(new ButtonElement(1, Math.round((float)this.width / 2.0f) - 40, this.height / 2 - 10, 20, 20, voidSlotItemStr));
        this.buttons.add(new ButtonElement(2, Math.round((float)this.width / 2.0f) + 20, this.height / 2 - 10, 20, 20, voidSlotFluidStr));
        this.buttons.add(new ButtonElement(0, this.width / 2 - 15, this.height / 2 - 10, 30, 20, this.cover.active ? "ON" : "OFF"));
        super.init();
    }

    protected void buttonClicked(ButtonElement button) {
        if (this.tile != null) {
            switch (button.id) {
                case 0: {
                    this.cover.active = !this.cover.active;
                    button.displayString = this.cover.active ? "ON" : "OFF";
                    break;
                }
                case 1: {
                    int max = this.tile.getContainerSize() - 1;
                    if (this.cover.voidingItemSlot < max) {
                        ++this.cover.voidingItemSlot;
                    }
                    String voidSlotItemStr = this.cover.voidingItemSlot == -2 ? "*" : (this.cover.voidingItemSlot == -1 ? "X" : String.valueOf(this.cover.voidingItemSlot));
                    button.displayString = voidSlotItemStr;
                    break;
                }
                case 2: {
                    int max = this.tile.getFluidInventorySize() - 1;
                    if (this.cover.voidingFluidSlot < max) {
                        ++this.cover.voidingFluidSlot;
                    }
                    String voidSlotFluidStr = this.cover.voidingFluidSlot == -2 ? "*" : (this.cover.voidingFluidSlot == -1 ? "X" : String.valueOf(this.cover.voidingFluidSlot));
                    button.displayString = voidSlotFluidStr;
                    break;
                }
            }
        }
        super.buttonClicked(button);
        if (EnvironmentHelper.isClientWorld()) {
            NetworkHandler.sendToServer((NetworkMessage)new PacketScreenAction(button.id, 0, 100 + this.cover.getDir().getSideNumber(), new Vec3i(this.tile.x, this.tile.y, this.tile.z), this.tile.getClass()));
        }
    }

    public void mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        if (button == 1) {
            for (ButtonElement guibutton : this.buttons) {
                if (!guibutton.mouseClicked(this.mc, x, y)) continue;
                this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                this.action2Performed(guibutton);
            }
        }
    }

    private void action2Performed(ButtonElement guibutton) {
        if (this.tile != null) {
            switch (guibutton.id) {
                case 1: {
                    if (this.cover.voidingItemSlot > -2) {
                        --this.cover.voidingItemSlot;
                        if (this.cover.voidingItemSlot == -2) {
                            PopupScreen popup = new PopupBuilder((Screen)this, 246).withLabel("signalindustries.warning").withMessageBox("warning", 128, "Setting a voiding slot to \"*\" will\n" + TextFormatting.RED + ">> REMOVE EVERY ITEM <<\n" + TextFormatting.WHITE + "in the inventory of the machine this cover\nis attached to.\n\nClick outside this popup to continue.", 44).closeOnClickOut(0).closeOnEnter(0).closeOnEsc(0).build();
                            Minecraft.getMinecraft().displayScreen((Screen)popup);
                            this.cover.active = false;
                        }
                    }
                    String voidSlotItemStr = this.cover.voidingItemSlot == -2 ? "*" : (this.cover.voidingItemSlot == -1 ? "X" : String.valueOf(this.cover.voidingItemSlot));
                    guibutton.displayString = voidSlotItemStr;
                    break;
                }
                case 2: {
                    if (this.cover.voidingFluidSlot > -2) {
                        --this.cover.voidingFluidSlot;
                        if (this.cover.voidingFluidSlot == -2) {
                            PopupScreen popup = new PopupBuilder((Screen)this, 246).withLabel("signalindustries.warning").withMessageBox("warning", 128, "Setting a voiding slot to \"*\" will\n" + TextFormatting.RED + ">> REMOVE EVERY FLUID <<\n" + TextFormatting.WHITE + "in the inventory of the machine this cover\nis attached to.\n\nClick outside this popup to continue.", 44).closeOnClickOut(0).closeOnEnter(0).closeOnEsc(0).build();
                            Minecraft.getMinecraft().displayScreen((Screen)popup);
                            this.cover.active = false;
                        }
                    }
                    String voidSlotFluidStr = this.cover.voidingFluidSlot == -2 ? "*" : (this.cover.voidingFluidSlot == -1 ? "X" : String.valueOf(this.cover.voidingFluidSlot));
                    guibutton.displayString = voidSlotFluidStr;
                    break;
                }
            }
            if (EnvironmentHelper.isClientWorld()) {
                NetworkHandler.sendToServer((NetworkMessage)new PacketScreenAction(guibutton.id, 1, 100 + this.cover.getDir().getSideNumber(), new Vec3i(this.tile.x, this.tile.y, this.tile.z), this.tile.getClass()));
            }
        }
    }
}

