/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.items.ItemWarpOrb;
import sunsetsatellite.signalindustries.menus.MenuWarpGate;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.TileEntityWarpGate;

public class ScreenWarpGate
extends ScreenFluid {
    public Player player;
    public TileEntityWarpGate tile;

    public ScreenWarpGate(ContainerInventory inv, TileEntity tile) {
        super((MenuFluid)new MenuWarpGate(inv, (TileEntityFluidItemContainer)tile));
        this.tile = (TileEntityWarpGate)tile;
        this.player = inv.player;
        this.ySize = 192;
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        super.drawGuiContainerBackgroundLayer(f);
        Texture bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/warp_gate.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(bg);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        int color = -1;
        switch (this.tile.tier) {
            case PROTOTYPE: {
                break;
            }
            case BASIC: {
                color = -32640;
                break;
            }
            case REINFORCED: {
                color = -65536;
                break;
            }
            case AWAKENED: {
                color = -23296;
            }
        }
        this.font.drawCenteredString(I18n.getInstance().translateNameKey(this.tile.getNameTranslationKey()), 90, 6, color);
        if (this.tile.itemContents[0] != null && this.tile.itemContents[0].getItem() instanceof ItemWarpOrb) {
            this.font.drawCenteredString(((ItemWarpOrb)this.tile.itemContents[0].getItem()).getLocationString(this.tile.itemContents[0]), 90, 20, -1118482);
        } else {
            this.font.drawCenteredString("No location", 90, 20, -8355712);
        }
        switch (this.tile.state) {
            case IDLE: {
                this.font.drawCenteredString("Idle", 89, 70, -1118482);
                break;
            }
            case CHARGING: {
                this.font.drawCenteredString("Charging...", 89, 70, Short.MIN_VALUE);
                break;
            }
            case CONNECTED_ONE_WAY: {
                this.font.drawCenteredString("Active! (One-way)", 89, 70, -16711936);
                break;
            }
            case CONNECTED_TWO_WAY: {
                this.font.drawCenteredString("Active! (Two-way)", 89, 70, -16711936);
                break;
            }
            case STABILIZATION_FAILURE: {
                this.font.drawCenteredString("/!\\ STABILIZATION FAILURE /!\\", 89, 70, -65536);
                break;
            }
            case POWER_FAILURE: {
                this.font.drawCenteredString("/!\\ POWER FAILURE /!\\", 89, 70, -65536);
            }
        }
    }
}

