/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens.guidebook.pages.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.guidebook.GuidebookPageManager;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.GuidebookSections;
import net.minecraft.client.gui.guidebook.RecipePage;
import net.minecraft.client.gui.guidebook.ScreenGuidebook;
import net.minecraft.client.gui.guidebook.SlotGuidebook;
import net.minecraft.client.gui.guidebook.search.GuidebookPageSearch;
import net.minecraft.client.option.enums.DescriptionPromptEnum;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.TextureManager;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryTrommel;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.slot.Slot;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.fluids.util.RecipeExtendedSymbol;
import sunsetsatellite.catalyst.fluids.util.RecipeOutputStack;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachineMultiOutput;

@Environment(value=EnvType.CLIENT)
public class GreenhousePage
extends RecipePage<RecipeEntryMachineMultiOutput> {
    public static final int RECIPES_PER_PAGE = 3;
    public List<SlotGuidebook> slots;
    public Map<RecipeEntryMachineMultiOutput, List<SlotGuidebook>> map;
    private final TooltipElement tooltipElement;
    private final ItemElement itemElement;
    private static final Minecraft mc = Minecraft.getMinecraft();
    private static long ticks = 0L;
    private static long ticks2 = 0L;

    public GreenhousePage(GuidebookSection section, ArrayList<RecipeEntryMachineMultiOutput> recipes) {
        super(section);
        this.recipes = recipes;
        this.slots = new ArrayList<SlotGuidebook>();
        this.map = new HashMap<RecipeEntryMachineMultiOutput, List<SlotGuidebook>>();
        this.tooltipElement = new TooltipElement(mc);
        this.itemElement = new ItemElement(mc);
        int recipeAmount = 0;
        int yOffset = 20;
        for (RecipeEntryMachineMultiOutput recipe : recipes) {
            ArrayList<SlotGuidebook> recipeSlots = new ArrayList<SlotGuidebook>();
            int slotsAmount = Math.min(4, ((RecipeOutputStack[])recipe.getOutput()).length);
            for (int i = 0; i < slotsAmount; ++i) {
                recipeSlots.add(new SlotGuidebook(i, 81 + 20 * (i % 2), 1 + 20 * (i / 2 + recipeAmount * 2) + yOffset, ((RecipeOutputStack[])recipe.getOutput())[i].asSymbol(), false, (RecipeEntryBase)recipe).setAsOutput());
            }
            int centerY = (((SlotGuidebook)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((SlotGuidebook)recipeSlots.get((int)(recipeSlots.size() - 2))).y) / 2;
            recipeSlots.add(new SlotGuidebook(slotsAmount, 19, centerY, ((RecipeExtendedSymbol[])recipe.getInput())[0].asNormalSymbol(), false, (RecipeEntryBase)recipe));
            if (((RecipeExtendedSymbol[])recipe.getInput()).length > 1) {
                recipeSlots.add(new SlotGuidebook(slotsAmount + 1, 19, centerY + 20, ((RecipeExtendedSymbol[])recipe.getInput())[1].asNormalSymbol(), false, (RecipeEntryBase)recipe));
            }
            this.map.put(recipe, recipeSlots);
            this.slots.addAll(recipeSlots);
            yOffset += 4;
            ++recipeAmount;
        }
    }

    public void onTick() {
        ++ticks;
        for (SlotGuidebook slot : this.slots) {
            if (ticks <= 20L) continue;
            slot.showRandomItem();
            if (this.slots.get(this.slots.size() - 1) != slot) continue;
            ticks = 0L;
        }
        if (++ticks2 > 25L) {
            ticks2 = 0L;
            for (SlotGuidebook slot : this.slots) {
                RecipeSymbol input;
                if (!(slot.recipe instanceof RecipeEntryTrommel) || (input = (RecipeSymbol)slot.recipe.getInput()).matches(slot.getItemStack()) || slot.recipeAmount <= 8) continue;
                int recipeIndexMax = Math.round((float)slot.recipeAmount / 9.0f);
                slot.recipeIndex = slot.recipeIndex >= recipeIndexMax ? 0 : ++slot.recipeIndex;
                WeightedRandomBag loot = (WeightedRandomBag)slot.recipe.getOutput();
                int index = slot.index + 9 * slot.recipeIndex;
                if (index > slot.recipeAmount) {
                    slot.item = null;
                    continue;
                }
                slot.item = ((WeightedRandomLootObject)loot.getEntries().get(index)).getItemStack();
            }
        }
    }

    protected void renderForeground(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawStringCenteredNoShadow(fr, "Greenhouse", x + 158 - 79, y + 5, -8355712);
        if (this.recipes.isEmpty()) {
            this.drawStringCenteredNoShadow(fr, I18n.getInstance().translateKey("guidebook.section.search.error.no_recipes"), x + 79, y + 110, -8355712);
        }
        SlotGuidebook mouseOverSlot = null;
        for (SlotGuidebook slot : this.slots) {
            this.drawSlot(x + slot.x - 1, y + slot.y - 1, -1);
            if (this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            this.itemElement.render(slot.getItemStack(), x + slot.x, y + slot.y, mouseOverSlot == slot, (Slot)slot);
        }
    }

    public boolean getIsMouseOverSlot(Slot slot, int x, int y, int mouseX, int mouseY) {
        return mouseX >= x + slot.x - 1 && mouseX < x + slot.x + 16 + 1 && mouseY >= y + slot.y - 1 && mouseY < y + slot.y + 16 + 1;
    }

    public boolean keyTyped(char c, int key, int x, int y, int mouseX, int mouseY) {
        super.keyTyped(c, key, x, y, mouseX, mouseY);
        if (GreenhousePage.mc.gameSettings.keyShowRecipe.isKeyboardKey(key)) {
            SlotGuidebook hoveringSlot = null;
            for (SlotGuidebook slot : this.slots) {
                if (!this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "r:" + hoveringSlot.getItemStack().getDisplayName() + "!";
                GuidebookPageManager.searchQuery = SearchQuery.resolve((String)query);
                GuidebookPageSearch.searchField.setText(query);
                ScreenGuidebook.getPageManager().updatePages();
                ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
                return true;
            }
        } else if (GreenhousePage.mc.gameSettings.keyShowUsage.isKeyboardKey(key)) {
            SlotGuidebook hoveringSlot = null;
            for (SlotGuidebook slot : this.slots) {
                if (!this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "u:" + hoveringSlot.getItemStack().getDisplayName() + "!";
                GuidebookPageManager.searchQuery = SearchQuery.resolve((String)query);
                GuidebookPageSearch.searchField.setText(query);
                ScreenGuidebook.getPageManager().updatePages();
                ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
                return true;
            }
        }
        return false;
    }

    public void render(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.render(re, fr, x, y, mouseX, mouseY, partialTicks);
    }

    protected void renderBackground(TextureManager re, int x, int y) {
        super.renderBackground(re, x, y);
        re.bindTexture(re.loadTexture("/assets/minecraft/textures/gui/container/guidebook/guidebook.png"));
        for (int i = 1; i <= this.recipes.size(); ++i) {
            RecipeEntryMachineMultiOutput recipe = (RecipeEntryMachineMultiOutput)((Object)this.recipes.get(i - 1));
            List<SlotGuidebook> list = this.map.get((Object)recipe);
            this.drawTexturedModalRect(x + list.get((int)(list.size() - 1)).x + 25, y + list.get((int)(list.size() - 1)).y, 234, 0, 22, 15);
        }
    }

    protected void renderOverlay(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.renderOverlay(re, fr, x, y, mouseX, mouseY, partialTicks);
        SlotGuidebook mouseOverSlot = null;
        for (SlotGuidebook slot : this.slots) {
            if (this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (mouseOverSlot == null || !mouseOverSlot.hasItem()) continue;
            boolean showDescription = DescriptionPromptEnum.showDescription((Minecraft)mc);
            String str = this.tooltipElement.getTooltipText(mouseOverSlot.getItemStack(), showDescription, (Slot)mouseOverSlot);
            if (str.isEmpty()) continue;
            this.tooltipElement.render(str, mouseX, mouseY, 8, -8);
        }
    }
}

