/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles;

import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.fluids.util.Fluid;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.interfaces.IMultiblockPart;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredContainer;
import sunsetsatellite.signalindustries.util.Tier;

public class TileEntityFluidHatch
extends TileEntityTieredContainer
implements IMultiblockPart {
    public TileEntity connectedTo;

    public TileEntityFluidHatch() {
        this.itemContents = new ItemStack[0];
        this.fluidContents = new FluidStack[1];
        this.fluidCapacity = new int[1];
        this.fluidCapacity[0] = 8000;
        ((ArrayList)this.acceptedFluids.get(0)).addAll(Fluid.fluidMap.values());
    }

    @Override
    public void init(Block<?> block) {
        super.init(block);
        this.fluidCapacity[0] = this.tier == Tier.PROTOTYPE ? 8000 : (int)Math.pow(2.0, this.tier.ordinal()) * 16000;
    }

    @Override
    public void tick() {
        super.tick();
        this.extractFluids();
    }

    @Override
    public boolean isConnected() {
        return this.connectedTo != null;
    }

    @Override
    public TileEntity getConnectedTileEntity() {
        return this.connectedTo;
    }

    @Override
    public boolean connect(TileEntity tileEntity) {
        this.connectedTo = tileEntity;
        return true;
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.fluidHatch";
    }
}

