/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.core.util.Connection;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.TickTimer;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.interfaces.IMultiblockPart;

public class TileEntityIgnitor
extends TileEntityFluidItemContainer
implements IMultiblockPart {
    public boolean isActivated = false;
    private final TickTimer timer = new TickTimer((Object)this, this::work, 20, true);
    public TileEntity connectedTo;

    public TileEntityIgnitor() {
        this.itemContents = new ItemStack[0];
        this.fluidContents = new FluidStack[1];
        this.fluidCapacity = new int[1];
        Arrays.fill(this.fluidCapacity, 1000);
        for (FluidStack fluidStack : this.fluidContents) {
            this.acceptedFluids.add(new ArrayList());
        }
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
        for (FluidStack fluidStack : Direction.values()) {
            this.fluidConnections.put(fluidStack, Connection.INPUT);
            this.activeFluidSlots.put(fluidStack, 0);
        }
        this.transferSpeed = 10;
    }

    public void tick() {
        super.tick();
        this.timer.tick();
        Random random = new Random();
        this.spreadFluids(Direction.Y_POS);
        this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
        this.extractFluids();
        if (this.getFluidInSlot(0) != null && this.getFluidInSlot((int)0).amount <= 0) {
            this.fluidContents[0] = null;
        }
        if (this.isActivated && this.getFluidInSlot(0) != null && this.getFluidInSlot((int)0).amount >= 5 && (double)random.nextFloat() < 0.25) {
            float xd = random.nextFloat() / 10.0f - 0.05f;
            float yd = random.nextFloat() / 10.0f - 0.05f;
            float f = random.nextFloat() / 10.0f - 0.05f;
        }
    }

    public void work() {
        if (this.isActivated && this.getFluidInSlot(0) != null && this.getFluidInSlot((int)0).amount >= 5) {
            this.getFluidInSlot((int)0).amount -= 5;
        }
    }

    public void spreadFluids(Direction dir) {
        for (Direction direction : Direction.values()) {
            this.fluidConnections.put(dir, Connection.BOTH);
        }
        if (this.getFluidInSlot(0) != null) {
            this.give(dir);
        }
        for (Direction direction : Direction.values()) {
            this.fluidConnections.put(dir, Connection.INPUT);
        }
    }

    public boolean isBurning() {
        return this.fluidContents[0] != null && this.fluidContents[0].fluid == SIFluids.ENERGY && this.fluidContents[0].amount > 0 && this.isActivated;
    }

    public boolean isEmpty() {
        return this.fluidContents[0] == null || this.fluidContents[0].fluid == SIFluids.ENERGY && this.fluidContents[0].amount == 0;
    }

    public boolean isReady() {
        return this.fluidContents[0] != null && this.fluidContents[0].fluid == SIFluids.ENERGY && this.fluidContents[0].amount >= this.fluidCapacity[0];
    }

    @Override
    public boolean isConnected() {
        return this.connectedTo != null;
    }

    @Override
    public TileEntity getConnectedTileEntity() {
        return this.connectedTo;
    }

    @Override
    public boolean connect(TileEntity tileEntity) {
        this.connectedTo = tileEntity;
        return true;
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.ignitor";
    }
}

