/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles;

import java.util.ArrayList;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredEnergyGenerator;

public class TileEntitySignalumDynamo
extends TileEntityTieredEnergyGenerator {
    public int cost = 5;

    public TileEntitySignalumDynamo() {
        this.itemContents = new ItemStack[2];
        this.fluidContents = new FluidStack[1];
        this.fluidCapacity[0] = 4000;
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
        this.capacity = 10000L;
        this.maxReceive = 250L;
        this.maxProvide = 250L;
    }

    @Override
    public void tick() {
        super.tick();
        this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
        this.extractFluids();
        if (this.fuelBurnTicks > 0) {
            --this.fuelBurnTicks;
        }
        if (!this.worldObj.isClientSide) {
            if (this.isBurning() && this.canProcess()) {
                this.generateEnergy(25L);
            } else if (this.canProcess()) {
                this.fuel();
                if (this.fuelBurnTicks > 0) {
                    ++this.fuelBurnTicks;
                }
            }
        }
    }

    public boolean fuel() {
        int burn = SignalIndustries.getEnergyBurnTime(this.fluidContents[0]);
        if (burn > 0 && this.canProcess() && this.fluidContents[0].amount >= this.cost) {
            this.fuelMaxBurnTicks = this.fuelBurnTicks = burn;
            this.fluidContents[0].amount -= this.cost;
            if (this.fluidContents[0].amount == 0) {
                this.fluidContents[0] = null;
            }
            return true;
        }
        return false;
    }

    private boolean canProcess() {
        if (this.fluidContents[0] == null) {
            return false;
        }
        return this.fluidContents[0].fluid == SIFluids.ENERGY && this.fluidContents[0].amount >= this.cost && this.getEnergy() < this.getCapacity();
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.dynamo";
    }
}

