/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles;

import com.mojang.nbt.tags.ByteTag;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.Map;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.world.World;
import sunsetsatellite.catalyst.core.util.mixin.interfaces.UnlimitedItemStack;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTiered;
import sunsetsatellite.signalindustries.util.Tier;

public class TileEntityStorageContainer
extends TileEntityTiered
implements Container {
    public ItemStack contents = null;
    public int capacity = 4096;
    public boolean infinite = false;
    public boolean unlimited = false;
    public boolean locked = false;

    public void writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putBoolean("Infinite", this.infinite);
        nbttagcompound.putBoolean("Unlimited", this.unlimited);
        nbttagcompound.putBoolean("Locked", this.locked);
        if (this.contents != null) {
            CompoundTag contentsTag = new CompoundTag();
            contentsTag.putShort("id", (short)this.contents.itemID);
            contentsTag.putInt("Count", this.contents.stackSize);
            contentsTag.putShort("Damage", (short)this.contents.getMetadata());
            contentsTag.putByte("Expanded", (byte)1);
            contentsTag.putInt("Version", 19134);
            if (!((Map)this.contents.getData().getValue()).isEmpty()) {
                contentsTag.putCompound("Data", this.contents.getData());
            }
            nbttagcompound.put("Contents", (Tag)contentsTag);
        } else {
            nbttagcompound.put("Empty", (Tag)new ByteTag());
        }
    }

    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.infinite = nbttagcompound.getBoolean("Infinite");
        this.unlimited = nbttagcompound.getBoolean("Unlimited");
        this.locked = nbttagcompound.getBoolean("Locked");
        if (nbttagcompound.containsKey("Contents")) {
            this.contents = new ItemStack(1, 1, 0);
            ((UnlimitedItemStack)this.contents).enableCustomMaxSize(this.getTieredCapacity());
            this.contents.readFromNBT(nbttagcompound.getCompound("Contents"));
            this.contents.stackSize = nbttagcompound.getCompound("Contents").getInteger("Count");
        } else if (nbttagcompound.containsKey("Empty")) {
            this.contents = null;
        }
    }

    public boolean insertStack(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.infinite) {
            this.contents = stack.copy();
            if (this.contents.isItemEqual(stack)) {
                stack.stackSize = 0;
            }
            return true;
        }
        if (this.contents == null) {
            if (this.capacity >= stack.stackSize) {
                this.contents = stack.copy();
                stack.stackSize = 0;
                return true;
            }
            this.contents = stack.copy();
            this.contents.stackSize = this.capacity;
            stack.stackSize -= this.capacity;
            return true;
        }
        if (!this.contents.isItemEqual(stack)) {
            return false;
        }
        if (!this.contents.getData().equals((Object)stack.getData())) {
            return false;
        }
        if (this.contents.stackSize >= this.capacity) {
            return false;
        }
        if (this.contents.stackSize + stack.stackSize > this.capacity) {
            int remainder = this.contents.stackSize + stack.stackSize - this.capacity;
            this.contents.stackSize = this.capacity;
            stack.stackSize -= remainder;
        } else {
            this.contents.stackSize += stack.stackSize;
            stack.stackSize = 0;
        }
        return true;
    }

    public ItemStack extractStack() {
        if (this.contents == null) {
            return null;
        }
        if (this.contents.stackSize <= 0) {
            return null;
        }
        if (this.contents.stackSize <= this.contents.getMaxStackSize()) {
            ItemStack stack = this.contents.copy();
            if (!this.locked) {
                this.contents = null;
            } else {
                this.contents.stackSize = 0;
            }
            return stack;
        }
        ItemStack stack = this.contents.copy();
        stack.stackSize = this.contents.getMaxStackSize();
        this.contents.stackSize -= this.contents.getMaxStackSize();
        if (this.contents.stackSize <= 0 && !this.locked) {
            this.contents = null;
        }
        return stack;
    }

    public ItemStack extractStack(int amount) {
        if (this.contents == null) {
            return null;
        }
        if (this.contents.stackSize <= 0) {
            return null;
        }
        amount = Math.min(this.contents.getMaxStackSize(), amount);
        if (this.contents.stackSize <= this.contents.getMaxStackSize() && this.contents.stackSize <= amount) {
            ItemStack stack = this.contents.copy();
            if (!this.locked) {
                this.contents = null;
            } else {
                this.contents.stackSize = 0;
            }
            return stack;
        }
        ItemStack stack = this.contents.copy();
        stack.stackSize = amount;
        this.contents.stackSize -= amount;
        return stack;
    }

    @Override
    public void tick() {
        super.tick();
        this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
        if (this.tier == Tier.INFINITE) {
            this.infinite = true;
            this.unlimited = true;
        }
        int n = this.capacity = this.unlimited ? Integer.MAX_VALUE : this.getTieredCapacity();
        if (this.contents != null) {
            if (this.infinite) {
                this.contents.stackSize = Integer.MAX_VALUE;
            }
            if (!this.locked && this.contents.stackSize <= 0) {
                this.contents = null;
            }
        }
    }

    public int getContainerSize() {
        return 1;
    }

    public ItemStack getItem(int slot) {
        if (slot == 0) {
            if (this.contents == null) {
                return null;
            }
            ((UnlimitedItemStack)this.contents).enableCustomMaxSize(this.getTieredCapacity());
            return this.contents;
        }
        return null;
    }

    public ItemStack removeItem(int slot, int amount) {
        if (this.unlimited) {
            return this.contents.copy();
        }
        if (slot != 0 || this.contents == null) {
            return null;
        }
        if (this.contents.stackSize <= amount) {
            ItemStack ret = this.contents.copy();
            this.contents.stackSize = 0;
            return ret;
        }
        ItemStack ret = this.contents.splitStack(amount);
        return ret;
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot != 0) {
            return;
        }
        if (this.locked && stack == null && this.contents != null) {
            this.contents.stackSize = 0;
        } else {
            this.contents = stack;
        }
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.storageContainer";
    }

    public int getMaxStackSize() {
        return this.unlimited ? Integer.MAX_VALUE : this.getTieredCapacity();
    }

    public boolean stillValid(Player player) {
        if (this.worldObj == null || this.worldObj.getTileEntity(this.x, this.y, this.z) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) <= 64.0;
    }

    public void sortContainer() {
    }

    public void dropContents(World world, int x, int y, int z) {
        super.dropContents(world, x, y, z);
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemStack = this.getItem(i);
            if (itemStack == null) continue;
            itemStack = itemStack.copy();
            ((UnlimitedItemStack)itemStack).disableCustomMaxSize();
            ((UnlimitedItemStack)itemStack).setUnlimited(false);
            EntityItem item = world.dropItem(x, y, z, itemStack);
            item.xd *= 0.5;
            item.yd *= 0.5;
            item.zd *= 0.5;
            item.pickupDelay = 0;
        }
    }

    public int getTieredCapacity() {
        switch (this.tier) {
            case PROTOTYPE: {
                return 4096;
            }
            case BASIC: {
                return 16384;
            }
            case REINFORCED: {
                return 65535;
            }
            case AWAKENED: {
                return 262140;
            }
            case INFINITE: {
                return Integer.MAX_VALUE;
            }
        }
        return 4096;
    }

    public boolean canBeCarried(World world, Entity potentialHolder) {
        return true;
    }
}

