/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.base;

import com.mojang.nbt.tags.CompoundTag;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.IScreenActionListener;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.covers.CoverBase;
import sunsetsatellite.signalindustries.interfaces.IAcceptsCovers;

public abstract class TileEntityCoverable
extends TileEntityFluidItemContainer
implements IAcceptsCovers,
IScreenActionListener {
    protected final HashMap<Direction, CoverBase> covers = (HashMap)Catalyst.mapOf((Object[])Direction.values(), (Object[])new CoverBase[Direction.values().length]);
    public static final int CHANNEL_COVERS_START = 100;
    public static final int CHANNEL_COVER_BOTTOM = 100;
    public static final int CHANNEL_COVER_TOP = 101;
    public static final int CHANNEL_COVERS_NORTH = 102;
    public static final int CHANNEL_COVERS_SOUTH = 103;
    public static final int CHANNEL_COVERS_WEST = 104;
    public static final int CHANNEL_COVERS_EAST = 105;
    public static final int CHANNEL_COVERS_END = 105;

    public void tick() {
        this.worldObj.markBlockDirty(this.x, this.y, this.z);
        this.covers.values().stream().filter(Objects::nonNull).forEach(CoverBase::tick);
        super.tick();
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        CompoundTag coversNbt = new CompoundTag();
        for (Map.Entry<Direction, CoverBase> entry : this.covers.entrySet()) {
            if (entry.getValue() == null) continue;
            CompoundTag coverNbt = new CompoundTag();
            entry.getValue().writeToNbt(coverNbt);
            coversNbt.putCompound(String.valueOf(entry.getKey().ordinal()), coverNbt);
        }
        tag.putCompound("Covers", coversNbt);
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.covers.clear();
        CompoundTag coversNbt = tag.getCompound("Covers");
        for (Map.Entry entry : ((Map)coversNbt.getValue()).entrySet()) {
            Direction dir = Direction.values()[Integer.parseInt((String)entry.getKey())];
            CompoundTag coverTag = (CompoundTag)entry.getValue();
            String type = coverTag.getString("Type");
            try {
                CoverBase cover = (CoverBase)Class.forName(type).getConstructor(new Class[0]).newInstance(new Object[0]);
                cover.setup(dir, this);
                cover.readFromNbt(coverTag);
                this.covers.put(dir, cover);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean installCover(Direction dir, CoverBase cover, Player player) {
        if (this.covers.get(dir) == null) {
            this.covers.put(dir, cover);
            cover.onInstalled(dir, this, player);
            return true;
        }
        return false;
    }

    @Override
    public boolean installCover(Direction dir, CoverBase cover) {
        if (this.covers.get(dir) == null) {
            this.covers.put(dir, cover);
            cover.onInstalled(dir, this);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCover(Direction dir, CoverBase cover, Player player) {
        CoverBase installedCover = this.covers.get(dir);
        if (installedCover != null && installedCover == cover) {
            EntityItem entityItem = new EntityItem(this.worldObj, (double)this.x, (double)this.y, (double)this.z, new ItemStack((Item)installedCover.getItem()));
            player.world.entityJoinedWorld((Entity)entityItem);
            installedCover.onRemoved(player);
            this.covers.remove(dir);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCover(Direction dir, CoverBase cover) {
        CoverBase installedCover = this.covers.get(dir);
        if (installedCover != null && installedCover == cover) {
            EntityItem entityItem = new EntityItem(this.worldObj, (double)this.x, (double)this.y, (double)this.z, new ItemStack((Item)installedCover.getItem()));
            this.worldObj.entityJoinedWorld((Entity)entityItem);
            installedCover.onRemoved();
            this.covers.remove(dir);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCover(Direction dir, Player player) {
        CoverBase installedCover = this.covers.get(dir);
        if (installedCover != null) {
            EntityItem entityItem = new EntityItem(this.worldObj, (double)this.x, (double)this.y, (double)this.z, new ItemStack((Item)installedCover.getItem()));
            this.worldObj.entityJoinedWorld((Entity)entityItem);
            installedCover.onRemoved(player);
            this.covers.remove(dir);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCover(Direction dir) {
        CoverBase installedCover = this.covers.get(dir);
        if (installedCover != null) {
            EntityItem entityItem = new EntityItem(this.worldObj, (double)this.x, (double)this.y, (double)this.z, new ItemStack((Item)installedCover.getItem()));
            this.worldObj.entityJoinedWorld((Entity)entityItem);
            installedCover.onRemoved();
            this.covers.remove(dir);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCover(Direction dir, Class<? extends CoverBase> cover) {
        return this.covers.get(dir) != null && this.covers.get(dir).getClass().isAssignableFrom(cover);
    }

    @Override
    public boolean hasCoverAnywhere(Class<? extends CoverBase> cover) {
        return this.covers.values().stream().anyMatch(C -> C != null && cover.isAssignableFrom(C.getClass()));
    }

    @Override
    public <T extends CoverBase> T getCover(Class<T> cover) {
        for (Direction dir : Direction.values()) {
            CoverBase c = this.covers.get(dir);
            if (c == null || !cover.isAssignableFrom(c.getClass())) continue;
            return (T)c;
        }
        return null;
    }

    @Override
    public Map<Direction, CoverBase> getCovers() {
        return Collections.unmodifiableMap(this.covers);
    }

    public void buttonClicked(int id, int button, int channel) {
        Direction dir;
        CoverBase cover;
        if (channel >= 100 && channel <= 105 && (cover = this.covers.get(dir = Direction.getDirectionFromSide((int)(channel - 100)))) != null) {
            cover.buttonClicked(id, button, channel);
        }
    }
}

