/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.base;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.network.Network;
import sunsetsatellite.catalyst.core.util.network.NetworkComponentTile;
import sunsetsatellite.catalyst.core.util.network.NetworkType;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.energy.simple.api.IEnergyContainer;
import sunsetsatellite.catalyst.energy.simple.impl.TileEntityEnergyConductor;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;

public abstract class TileEntityTieredEnergyMachine
extends TileEntityTieredMachineBase
implements IEnergyContainer,
NetworkComponentTile {
    protected long energy = 0L;
    protected long capacity = 0L;
    protected long maxReceive = 0L;
    protected long maxProvide = 0L;
    public Network energyNet;

    @Override
    public void writeToNBT(CompoundTag tag) {
        tag.putLong("energy", this.energy);
        tag.putLong("capacity", this.capacity);
        tag.putLong("maxReceive", this.maxReceive);
        tag.putLong("maxProvide", this.maxProvide);
        super.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        this.energy = tag.getLong("energy");
        this.capacity = tag.getLong("capacity");
        this.maxReceive = tag.getLong("maxReceive");
        this.maxProvide = tag.getLong("maxProvide");
        super.readFromNBT(tag);
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getMaxReceive() {
        return this.maxReceive;
    }

    public long getMaxProvide() {
        return this.maxProvide;
    }

    public long internalChangeEnergy(long difference) {
        this.energy += difference;
        return difference;
    }

    public NetworkType getType() {
        return NetworkType.CATALYST_ENERGY;
    }

    public Vec3i getPosition() {
        return new Vec3i(this.x, this.y, this.z);
    }

    public boolean isConnected(Direction direction) {
        return direction.getTileEntity((WorldSource)this.worldObj, (TileEntity)this) instanceof TileEntityEnergyConductor;
    }

    public void networkChanged(Network network) {
        this.energyNet = network;
    }

    public void removedFromNetwork(Network network) {
        this.energyNet = null;
    }
}

