/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.base;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.core.util.io.IFluidIO;
import sunsetsatellite.catalyst.core.util.io.IItemIO;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.fluids.util.RecipeExtendedSymbol;
import sunsetsatellite.catalyst.fluids.util.RecipeOutputStack;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.recipes.RecipeGroupSI;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachine;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachineFluid;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachineMultiOutput;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntrySI;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;
import sunsetsatellite.signalindustries.util.RecipeProperties;
import turniplabs.halplibe.helper.EnvironmentHelper;

public abstract class TileEntityTieredMachineSimple
extends TileEntityTieredMachineBase
implements IFluidIO,
IItemIO {
    public RecipeGroupSI<?> recipeGroup;
    public RecipeEntrySI<?, ?, RecipeProperties> currentRecipe;
    public int recipeId = 0;
    public int[] itemInputs = new int[0];
    public int[] itemOutputs = new int[0];
    public int[] fluidInputs = new int[0];
    public int[] fluidOutputs = new int[0];
    public int energySlot;
    public Random random = new Random();

    @Override
    public void tick() {
        super.tick();
        this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
        this.extractFluids();
        Block block = this.getBlock();
        if (block != null) {
            this.setCurrentRecipe();
            if (!this.disabled) {
                this.work();
            }
        }
    }

    public void work() {
        if (EnvironmentHelper.isClientWorld()) {
            return;
        }
        boolean update = false;
        if (this.fuelBurnTicks > 0) {
            --this.fuelBurnTicks;
        }
        if (this.areAllInputsNull()) {
            this.progressTicks = 0;
        } else if (this.canProcess()) {
            this.progressMaxTicks = this.getTieredProgressDuration(((RecipeProperties)this.currentRecipe.getData()).ticks);
        }
        if (!this.worldObj.isClientSide) {
            if (this.progressTicks == 0 && this.canProcess()) {
                update = this.fuel();
            }
            if (this.isBurning() && this.canProcess()) {
                ++this.progressTicks;
                if (this.progressTicks >= this.progressMaxTicks) {
                    this.progressTicks = 0;
                    this.processItem();
                    update = true;
                }
            } else if (this.canProcess()) {
                this.fuel();
                if (this.fuelBurnTicks > 0) {
                    ++this.fuelBurnTicks;
                }
            }
        }
        if (update) {
            this.setChanged();
        }
    }

    public boolean areAllInputsNull() {
        boolean itemsNull = Arrays.stream(this.itemInputs).allMatch(slot -> this.itemContents[slot] == null);
        boolean fluidsNull = Arrays.stream(this.fluidInputs).allMatch(slot -> this.fluidContents[slot] == null);
        return itemsNull && fluidsNull;
    }

    public boolean fuel() {
        int burn = SignalIndustries.getEnergyBurnTime(this.fluidContents[this.energySlot]);
        if (burn > 0 && this.canProcess() && this.currentRecipe != null && this.fuelBurnTicks <= 0 && this.fluidContents[this.energySlot].amount >= ((RecipeProperties)this.currentRecipe.getData()).cost) {
            this.progressMaxTicks = this.getTieredProgressDuration(((RecipeProperties)this.currentRecipe.getData()).ticks);
            this.fuelMaxBurnTicks = this.fuelBurnTicks = burn;
            this.fluidContents[this.energySlot].amount -= ((RecipeProperties)this.currentRecipe.getData()).cost;
            if (this.fluidContents[this.energySlot].amount == 0) {
                this.fluidContents[this.energySlot] = null;
            }
            return true;
        }
        return false;
    }

    public void processItem() {
        if (this.canProcess()) {
            if (this.currentRecipe instanceof RecipeEntryMachine) {
                ItemStack stack;
                RecipeEntryMachine recipe = (RecipeEntryMachine)this.currentRecipe;
                ItemStack itemStack = stack = recipe.getOutput() == null ? null : ((ItemStack)recipe.getOutput()).copy();
                if (stack != null) {
                    this.consumeInputs();
                    if (this.random.nextFloat() <= ((RecipeProperties)recipe.getData()).chance) {
                        int multiplier = 1;
                        float fraction = Float.parseFloat("0." + String.valueOf(this.yield).split("\\.")[1]);
                        if (fraction <= 0.0f) {
                            fraction = 1.0f;
                        }
                        if (this.yield > 1.0f && this.random.nextFloat() <= fraction) {
                            multiplier = (int)Math.ceil(this.yield);
                        }
                        if (this.itemContents[this.itemOutputs[0]] == null) {
                            stack.stackSize *= multiplier;
                            this.setItem(this.itemOutputs[0], stack);
                        } else if (this.itemContents[this.itemOutputs[0]].isItemEqual(stack)) {
                            this.itemContents[this.itemOutputs[0]].stackSize += stack.stackSize * multiplier;
                        }
                    }
                }
            } else if (this.currentRecipe instanceof RecipeEntryMachineFluid) {
                FluidStack fluidStack;
                RecipeEntryMachineFluid recipe = (RecipeEntryMachineFluid)this.currentRecipe;
                FluidStack fluidStack2 = fluidStack = recipe.getOutput() == null ? null : ((FluidStack)recipe.getOutput()).copy();
                if (fluidStack != null) {
                    this.consumeInputs();
                    if (this.random.nextFloat() <= ((RecipeProperties)recipe.getData()).chance) {
                        int multiplier = 1;
                        float fraction = Float.parseFloat("0." + String.valueOf(this.yield).split("\\.")[1]);
                        if (fraction <= 0.0f) {
                            fraction = 1.0f;
                        }
                        if (this.yield > 1.0f && this.random.nextFloat() <= fraction) {
                            multiplier = (int)Math.ceil(this.yield);
                        }
                        if (this.fluidContents[this.fluidOutputs[0]] == null) {
                            fluidStack.amount *= multiplier;
                            this.setFluidInSlot(this.fluidOutputs[0], fluidStack);
                        } else if (this.fluidContents[this.fluidOutputs[0]].isFluidEqual(fluidStack)) {
                            this.fluidContents[this.fluidOutputs[0]].amount += fluidStack.amount * multiplier;
                        }
                    }
                }
            } else if (this.currentRecipe instanceof RecipeEntryMachineMultiOutput) {
                this.currentRecipe.processMachineRecipe(this);
            }
        }
    }

    public void consumeInputs() {
        if (this.currentRecipe instanceof RecipeEntryMachine) {
            Optional<ItemStack> recipeStack;
            ItemStack inputStack;
            RecipeEntryMachine recipe = (RecipeEntryMachine)this.currentRecipe;
            for (int itemInput : this.itemInputs) {
                inputStack = this.getItem(itemInput);
                if (inputStack != null && inputStack.getItem().hasContainerItem() && !((RecipeProperties)recipe.getData()).consumeContainers) {
                    this.setItem(itemInput, new ItemStack(inputStack.getItem().getContainerItem()));
                    continue;
                }
                if (inputStack == null) continue;
                recipeStack = Arrays.stream((RecipeExtendedSymbol[])recipe.getInput()).flatMap(symbol -> symbol.resolve().stream()).filter(Objects::nonNull).filter(stack -> stack.isItemEqual(inputStack)).findFirst();
                if (inputStack.getItem().hasContainerItem() && !((RecipeProperties)recipe.getData()).consumeContainers) {
                    this.setItem(itemInput, inputStack.getItem().getContainerItem().getDefaultStack());
                    continue;
                }
                recipeStack.ifPresent(stack -> inputStack.stackSize -= stack.stackSize);
                if (inputStack.stackSize > 0) continue;
                this.setItem(itemInput, null);
            }
            for (int fluidInput : this.fluidInputs) {
                inputStack = this.getFluidInSlot(fluidInput);
                if (inputStack == null) continue;
                recipeStack = Arrays.stream((RecipeExtendedSymbol[])recipe.getInput()).flatMap(symbol -> symbol.resolveFluids().stream()).filter(Objects::nonNull).filter(arg_0 -> TileEntityTieredMachineSimple.lambda$consumeInputs$6((FluidStack)inputStack, arg_0)).findFirst();
                recipeStack.ifPresent(arg_0 -> TileEntityTieredMachineSimple.lambda$consumeInputs$7((FluidStack)inputStack, arg_0));
                if (inputStack.amount > 0) continue;
                this.setFluidInSlot(fluidInput, null);
            }
        } else if (this.currentRecipe instanceof RecipeEntryMachineFluid) {
            Optional<ItemStack> recipeStack;
            ItemStack inputStack;
            RecipeEntryMachineFluid recipe = (RecipeEntryMachineFluid)this.currentRecipe;
            for (int itemInput : this.itemInputs) {
                inputStack = this.getItem(itemInput);
                if (inputStack != null && inputStack.getItem().hasContainerItem() && !((RecipeProperties)recipe.getData()).consumeContainers) {
                    this.setItem(itemInput, new ItemStack(inputStack.getItem().getContainerItem()));
                    continue;
                }
                if (inputStack == null) continue;
                recipeStack = Arrays.stream((RecipeExtendedSymbol[])recipe.getInput()).flatMap(symbol -> symbol.resolve().stream()).filter(Objects::nonNull).filter(stack -> stack.isItemEqual(inputStack)).findFirst();
                if (inputStack.getItem().hasContainerItem() && !((RecipeProperties)recipe.getData()).consumeContainers) {
                    this.setItem(itemInput, inputStack.getItem().getContainerItem().getDefaultStack());
                    continue;
                }
                recipeStack.ifPresent(stack -> inputStack.stackSize -= stack.stackSize);
                if (inputStack.stackSize > 0) continue;
                this.setItem(itemInput, null);
            }
            for (int fluidInput : this.fluidInputs) {
                inputStack = this.getFluidInSlot(fluidInput);
                if (inputStack == null) continue;
                recipeStack = Arrays.stream((RecipeExtendedSymbol[])recipe.getInput()).flatMap(symbol -> symbol.resolveFluids().stream()).filter(Objects::nonNull).filter(arg_0 -> TileEntityTieredMachineSimple.lambda$consumeInputs$12((FluidStack)inputStack, arg_0)).findFirst();
                recipeStack.ifPresent(arg_0 -> TileEntityTieredMachineSimple.lambda$consumeInputs$13((FluidStack)inputStack, arg_0));
                if (inputStack.amount > 0) continue;
                this.setFluidInSlot(fluidInput, null);
            }
        } else if (this.currentRecipe instanceof RecipeEntryMachineMultiOutput) {
            this.currentRecipe.consumeMachineInputs(this);
        }
    }

    public boolean canProcess() {
        if (this.currentRecipe instanceof RecipeEntryMachine) {
            RecipeEntryMachine recipe = (RecipeEntryMachine)this.currentRecipe;
            ItemStack stack = (ItemStack)recipe.getOutput();
            if (stack == null) {
                return false;
            }
            return this.areItemOutputsValid(stack);
        }
        if (this.currentRecipe instanceof RecipeEntryMachineFluid) {
            RecipeEntryMachineFluid recipe = (RecipeEntryMachineFluid)this.currentRecipe;
            FluidStack fluidStack = (FluidStack)recipe.getOutput();
            if (fluidStack == null) {
                return false;
            }
            return this.areFluidOutputsValid(fluidStack);
        }
        if (this.currentRecipe instanceof RecipeEntryMachineMultiOutput) {
            return this.currentRecipe.canMachineProcess(this);
        }
        return false;
    }

    public boolean areRecipeOutputsValid(RecipeOutputStack[] stacks) {
        HashSet<Integer> occupiedItemSlots = new HashSet<Integer>();
        HashSet<Integer> occupiedFluidSlots = new HashSet<Integer>();
        for (RecipeOutputStack output : stacks) {
            ItemStack outputStack;
            boolean valid;
            ItemStack stack;
            if (output.isItem()) {
                stack = output.stack.copy();
                stack.stackSize = output.randomAmount ? output.amountMax : stack.stackSize;
                valid = false;
                for (int itemOutput : this.itemOutputs) {
                    if (occupiedItemSlots.contains(itemOutput)) continue;
                    outputStack = this.getItem(itemOutput);
                    if (outputStack != null && outputStack.isItemEqual(stack)) {
                        int n;
                        if (this.yield > 1.0f) {
                            n = outputStack.stackSize + stack.stackSize * (int)Math.ceil(this.yield);
                            if ((n > this.getMaxStackSize() || n > outputStack.getMaxStackSize()) && n > stack.getMaxStackSize()) continue;
                            occupiedItemSlots.add(itemOutput);
                            valid = true;
                            break;
                        }
                        n = outputStack.stackSize + stack.stackSize;
                        if ((n > this.getMaxStackSize() || n > outputStack.getMaxStackSize()) && n > stack.getMaxStackSize()) continue;
                        occupiedItemSlots.add(itemOutput);
                        valid = true;
                        break;
                    }
                    if (outputStack != null) continue;
                    occupiedItemSlots.add(itemOutput);
                    valid = true;
                    break;
                }
                if (valid) continue;
                return false;
            }
            if (!output.isFluid()) continue;
            stack = output.fluid.copy();
            stack.amount = output.randomAmount ? output.amountMax : stack.amount;
            valid = false;
            for (int fluidOutput : this.fluidOutputs) {
                if (occupiedFluidSlots.contains(fluidOutput)) continue;
                outputStack = this.getFluidInSlot(fluidOutput);
                if (outputStack != null) {
                    if (!outputStack.isFluidEqual((FluidStack)stack)) continue;
                    if (this.yield > 1.0f) {
                        if ((double)stack.amount * Math.ceil(this.yield) > (double)this.getRemainingCapacity(fluidOutput)) continue;
                        occupiedFluidSlots.add(fluidOutput);
                        valid = true;
                        break;
                    }
                    if (stack.amount > this.getRemainingCapacity(fluidOutput)) continue;
                    occupiedFluidSlots.add(fluidOutput);
                    valid = true;
                    break;
                }
                occupiedFluidSlots.add(fluidOutput);
                valid = true;
                break;
            }
            if (valid) continue;
            return false;
        }
        return true;
    }

    public boolean areItemOutputsValid(ItemStack stack) {
        for (int itemOutput : this.itemOutputs) {
            ItemStack outputStack = this.getItem(itemOutput);
            if (outputStack == null) continue;
            if (outputStack.isItemEqual(stack)) {
                int n;
                if (!(this.yield > 1.0f ? ((n = outputStack.stackSize + stack.stackSize * (int)Math.ceil(this.yield)) > this.getMaxStackSize() || n > outputStack.getMaxStackSize()) && n > stack.getMaxStackSize() : ((n = outputStack.stackSize + stack.stackSize) > this.getMaxStackSize() || n > outputStack.getMaxStackSize()) && n > stack.getMaxStackSize())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean areFluidOutputsValid(FluidStack stack) {
        for (int fluidOutput : this.fluidOutputs) {
            FluidStack outputStack = this.getFluidInSlot(fluidOutput);
            if (outputStack == null) continue;
            if (outputStack.isFluidEqual(stack)) {
                if (this.yield > 1.0f ? (double)stack.amount * Math.ceil(this.yield) > (double)this.getRemainingCapacity(fluidOutput) : stack.amount > this.getRemainingCapacity(fluidOutput)) {
                    return false;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public void setCurrentRecipe() {
        ArrayList symbols = new ArrayList();
        Arrays.stream(this.itemInputs).forEach(id -> {
            if (this.getItem(id) != null) {
                symbols.add(new RecipeExtendedSymbol(this.getItem(id)));
            }
        });
        Arrays.stream(this.fluidInputs).forEach(id -> {
            if (this.getFluidInSlot(id) != null) {
                symbols.add(new RecipeExtendedSymbol(this.getFluidInSlot(id)));
            }
        });
        this.currentRecipe = this.recipeGroup.findRecipe(symbols.toArray(new RecipeExtendedSymbol[0]), this.tier, this.recipeId);
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putInt("RecipeId", this.recipeId);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.recipeId = tag.getInteger("RecipeId");
    }

    private static /* synthetic */ void lambda$consumeInputs$13(FluidStack inputStack, FluidStack stack) {
        inputStack.amount -= stack.amount;
    }

    private static /* synthetic */ boolean lambda$consumeInputs$12(FluidStack inputStack, FluidStack stack) {
        return stack.isFluidEqual(inputStack);
    }

    private static /* synthetic */ void lambda$consumeInputs$7(FluidStack inputStack, FluidStack stack) {
        inputStack.amount -= stack.amount;
    }

    private static /* synthetic */ boolean lambda$consumeInputs$6(FluidStack inputStack, FluidStack stack) {
        return stack.isFluidEqual(inputStack);
    }
}

