/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.CatalystFluids;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.Connection;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.mixin.interfaces.ITileEntityInit;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.fluids.util.RecipeExtendedSymbol;
import sunsetsatellite.catalyst.multiblocks.IMultiblock;
import sunsetsatellite.catalyst.multiblocks.MultiblockInstance;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.blocks.logic.BlockLogicParallelProcessor;
import sunsetsatellite.signalindustries.interfaces.IMultiblockPart;
import sunsetsatellite.signalindustries.interfaces.IMultiblockPartBlock;
import sunsetsatellite.signalindustries.interfaces.ITiered;
import sunsetsatellite.signalindustries.recipes.RecipeGroupSI;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntrySI;
import sunsetsatellite.signalindustries.tiles.TileEntityEnergyConnector;
import sunsetsatellite.signalindustries.tiles.TileEntityFluidHatch;
import sunsetsatellite.signalindustries.tiles.TileEntityItemBus;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;
import sunsetsatellite.signalindustries.util.MultiblockPart;
import sunsetsatellite.signalindustries.util.RecipeProperties;
import sunsetsatellite.signalindustries.util.Tier;

public abstract class TileEntityTieredMultiblock
extends TileEntityTieredMachineBase
implements IMultiblock,
ITileEntityInit {
    public MultiblockInstance multiblock;
    public TileEntityItemBus itemInput;
    public TileEntityItemBus itemOutput;
    public TileEntityFluidHatch fluidInput;
    public TileEntityFluidHatch fluidOutput;
    public TileEntityEnergyConnector energy;
    public boolean usesItemInput = false;
    public boolean usesItemOutput = false;
    public boolean usesFluidInput = false;
    public boolean usesFluidOutput = false;
    public boolean usesEnergy = false;
    public Tier minimumItemInputTier = Tier.BASIC;
    public Tier minimumItemOutputTier = Tier.BASIC;
    public Tier minimumFluidInputTier = Tier.BASIC;
    public Tier minimumFluidOutputTier = Tier.BASIC;
    public Tier minimumEnergyTier = Tier.BASIC;
    public RecipeGroupSI<?> recipeGroup;
    public RecipeEntrySI<?, ?, RecipeProperties> currentRecipe;
    public Random random = new Random();
    public int parallel = 1;
    public int baseParallel = 1;

    public TileEntityTieredMultiblock() {
        this.itemContents = new ItemStack[0];
        this.fluidContents = new FluidStack[0];
        this.fluidCapacity = new int[0];
    }

    @Override
    public void tick() {
        block26: {
            if (this.multiblock == null) {
                return;
            }
            super.tick();
            if (this.worldObj != null) {
                this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
            }
            Block block = this.getBlock();
            this.itemInput = null;
            this.itemOutput = null;
            this.fluidInput = null;
            this.fluidOutput = null;
            this.energy = null;
            if (!this.multiblock.isValid()) break block26;
            Direction dir = Direction.getDirectionFromSide((int)this.getBlockMeta());
            ArrayList tileEntities = this.multiblock.data.getTileEntities(this.worldObj, new Vec3i(this.x, this.y, this.z), dir);
            for (Object tileEntity : tileEntities) {
                IMultiblockPartBlock multiblockPart = (IMultiblockPartBlock)Catalyst.blockLogic((Block)((BlockInstance)tileEntity).block, IMultiblockPartBlock.class);
                if (!(((BlockInstance)tileEntity).tile instanceof IMultiblockPart) || !(multiblockPart instanceof ITiered)) continue;
                if (multiblockPart.getType() == MultiblockPart.Type.ITEM && multiblockPart.getIO() == MultiblockPart.IO.INPUT) {
                    if (((ITiered)((Object)multiblockPart)).getTier().ordinal() >= this.minimumItemInputTier.ordinal()) {
                        this.itemInput = (TileEntityItemBus)((BlockInstance)tileEntity).tile;
                    }
                } else if (multiblockPart.getType() == MultiblockPart.Type.ITEM && multiblockPart.getIO() == MultiblockPart.IO.OUTPUT) {
                    if (((ITiered)((Object)multiblockPart)).getTier().ordinal() >= this.minimumItemOutputTier.ordinal()) {
                        this.itemOutput = (TileEntityItemBus)((BlockInstance)tileEntity).tile;
                    }
                } else if (((BlockInstance)tileEntity).tile instanceof TileEntityEnergyConnector) {
                    if (((ITiered)((Object)multiblockPart)).getTier().ordinal() >= this.minimumEnergyTier.ordinal()) {
                        this.energy = (TileEntityEnergyConnector)((BlockInstance)tileEntity).tile;
                    }
                } else if (multiblockPart.getType() == MultiblockPart.Type.FLUID && multiblockPart.getIO() == MultiblockPart.IO.INPUT) {
                    if (((ITiered)((Object)multiblockPart)).getTier().ordinal() >= this.minimumFluidInputTier.ordinal()) {
                        this.fluidInput = (TileEntityFluidHatch)((BlockInstance)tileEntity).tile;
                    }
                } else if (multiblockPart.getType() == MultiblockPart.Type.FLUID && multiblockPart.getIO() == MultiblockPart.IO.INPUT && ((ITiered)((Object)multiblockPart)).getTier().ordinal() >= this.minimumFluidOutputTier.ordinal()) {
                    this.fluidOutput = (TileEntityFluidHatch)((BlockInstance)tileEntity).tile;
                }
                ((IMultiblockPart)((BlockInstance)tileEntity).tile).connect((TileEntity)this);
            }
            this.parallel = this.baseParallel;
            ArrayList extraBlocks = this.multiblock.data.getSubstitutions(new Vec3i(this.x, this.y, this.z), dir);
            for (BlockInstance extraBlock : extraBlocks) {
                BlockLogicParallelProcessor multiblockPart;
                if (this.worldObj == null || !extraBlock.exists(this.worldObj) || (multiblockPart = (BlockLogicParallelProcessor)Catalyst.blockLogic((Block)extraBlock.block, BlockLogicParallelProcessor.class)) == null || multiblockPart.getType() != MultiblockPart.Type.PARALLEL) continue;
                this.parallel = this.baseParallel * multiblockPart.maxParallel;
            }
            if (block != null && this.allPartsPresent()) {
                int oldParallel = this.parallel;
                this.parallel = 1;
                this.setCurrentRecipe();
                this.parallel = oldParallel;
                if (this.currentRecipe != null) {
                    int effectiveParallel;
                    int recipeInputSum = Arrays.stream((RecipeExtendedSymbol[])this.currentRecipe.getInput()).map(RecipeExtendedSymbol::asNormalSymbol).map(RecipeSymbol::resolve).map(L -> (ItemStack)L.get(0)).mapToInt(S -> S.stackSize).sum();
                    int inputSum = 0;
                    if (this.itemInput != null) {
                        inputSum += Catalyst.condenseItemList(Arrays.asList(this.itemInput.itemContents)).stream().mapToInt(S -> S.stackSize).sum();
                    }
                    if (this.fluidInput != null) {
                        inputSum += CatalystFluids.condenseFluidList(Arrays.asList(this.fluidInput.fluidContents)).stream().mapToInt(S -> S.amount).sum();
                    }
                    if (this.parallel > (effectiveParallel = inputSum / recipeInputSum) && effectiveParallel > 0) {
                        this.parallel = effectiveParallel;
                    }
                }
                this.setCurrentRecipe();
                this.work();
            }
            if (this.isBurning()) {
                ArrayList blocks = this.multiblock.data.getBlocks(new Vec3i(this.x, this.y, this.z), dir);
                for (BlockInstance structBlock : blocks) {
                    if (structBlock.block != SIBlocks.reinforcedCasing2 && structBlock.block != SIBlocks.awakenedSocketCasing && structBlock.block != SIBlocks.awakenedCasing2 || this.worldObj == null || structBlock.pos.getBlockMetadata((WorldSource)this.worldObj) == 1) continue;
                    this.worldObj.setBlockMetadata(structBlock.pos.x, structBlock.pos.y, structBlock.pos.z, 1);
                }
            } else {
                ArrayList blocks = this.multiblock.data.getBlocks(new Vec3i(this.x, this.y, this.z), dir);
                for (BlockInstance structBlock : blocks) {
                    if (structBlock.block != SIBlocks.reinforcedCasing2 && structBlock.block != SIBlocks.awakenedSocketCasing && structBlock.block != SIBlocks.awakenedCasing2 || this.worldObj == null || structBlock.pos.getBlockMetadata((WorldSource)this.worldObj) != 1) continue;
                    this.worldObj.setBlockMetadata(structBlock.pos.x, structBlock.pos.y, structBlock.pos.z, 0);
                }
            }
        }
    }

    public boolean allPartsPresent() {
        return !(this.itemInput == null && this.usesItemInput || this.itemOutput == null && this.usesItemOutput || this.fluidInput == null && this.usesFluidInput || this.fluidOutput == null && this.usesFluidOutput || this.energy == null && this.usesEnergy);
    }

    public void work() {
        if (this.multiblock.isValid() && this.allPartsPresent()) {
            boolean update = false;
            if (this.fuelBurnTicks > 0) {
                --this.fuelBurnTicks;
            }
            ArrayList<ItemStack> inputContents = this.getItemInputContents();
            ArrayList<FluidStack> fluidInputContents = this.getFluidInputContents();
            if (inputContents.isEmpty() && fluidInputContents.isEmpty()) {
                this.progressTicks = 0;
            } else if (this.canProcess()) {
                this.progressMaxTicks = (int)((float)((RecipeProperties)this.currentRecipe.getData()).ticks / this.speedMultiplier);
            }
            if (this.worldObj != null && !this.worldObj.isClientSide) {
                if (this.progressTicks == 0 && this.canProcess() && this.fuelBurnTicks < 2) {
                    update = this.fuel();
                }
                if (this.isBurning() && this.canProcess()) {
                    ++this.progressTicks;
                    if (this.progressTicks >= this.progressMaxTicks) {
                        this.progressTicks = 0;
                        this.processItem();
                        update = true;
                    }
                } else if (this.canProcess()) {
                    this.fuel();
                    if (this.fuelBurnTicks > 0) {
                        ++this.fuelBurnTicks;
                    }
                }
            }
            if (update) {
                this.setChanged();
            }
        }
    }

    @Override
    public boolean isBurning() {
        if (this.multiblock == null) {
            return false;
        }
        return super.isBurning() && this.multiblock.isValid();
    }

    @NotNull
    private ArrayList<ItemStack> getItemInputContents() {
        if (!this.allPartsPresent() || !this.usesItemInput) {
            return new ArrayList<ItemStack>();
        }
        return Catalyst.condenseItemList(Arrays.asList(this.itemInput.itemContents));
    }

    @NotNull
    private ArrayList<ItemStack> getItemOutputContents() {
        if (!this.allPartsPresent() || !this.usesItemOutput) {
            return new ArrayList<ItemStack>();
        }
        return Catalyst.condenseItemList(Arrays.asList(this.itemOutput.itemContents));
    }

    @NotNull
    private ArrayList<FluidStack> getFluidInputContents() {
        if (!this.allPartsPresent() || !this.usesFluidInput) {
            return new ArrayList<FluidStack>();
        }
        return CatalystFluids.condenseFluidList(Arrays.asList(this.fluidInput.fluidContents));
    }

    @NotNull
    private ArrayList<FluidStack> getFluidOutputContents() {
        if (!this.allPartsPresent() || !this.usesFluidOutput) {
            return new ArrayList<FluidStack>();
        }
        return CatalystFluids.condenseFluidList(Arrays.asList(this.fluidOutput.fluidContents));
    }

    public MultiblockInstance getMultiblock() {
        return this.multiblock;
    }

    public boolean fuel() {
        int burn;
        if (this.allPartsPresent() && this.energy.getFluidInSlot(0) != null && (burn = SignalIndustries.getEnergyBurnTime(this.energy.getFluidInSlot(0))) > 0 && this.canProcess() && this.currentRecipe != null && this.energy.getFluidInSlot((int)0).amount >= ((RecipeProperties)this.currentRecipe.getData()).cost) {
            this.progressMaxTicks = (int)((float)((RecipeProperties)this.currentRecipe.getData()).ticks / this.speedMultiplier);
            this.fuelMaxBurnTicks = this.fuelBurnTicks = burn;
            this.energy.getFluidInSlot((int)0).amount -= ((RecipeProperties)this.currentRecipe.getData()).cost;
            if (this.energy.getFluidInSlot((int)0).amount <= 0) {
                this.energy.setFluidInSlot(0, null);
            }
            return true;
        }
        return false;
    }

    public void setCurrentRecipe() {
        if (this.allPartsPresent()) {
            List<Object> objs = new ArrayList();
            if (this.usesItemInput) {
                List<ItemStack> items = this.getItemInputContents().stream().map(ItemStack::copy).collect(Collectors.toList());
                items.forEach(stack -> stack.stackSize /= this.parallel);
                objs.addAll(items);
            }
            if (this.usesFluidInput) {
                List<FluidStack> fluids = this.getFluidInputContents().stream().map(FluidStack::copy).collect(Collectors.toList());
                fluids.forEach(stack -> stack.amount /= this.parallel);
                objs.addAll(fluids);
            }
            objs = objs.stream().map(o -> {
                if (o instanceof ItemStack) {
                    if (((ItemStack)o).stackSize <= 0) {
                        return null;
                    }
                } else if (o instanceof FluidStack) {
                    if (((FluidStack)o).amount <= 0) {
                        return null;
                    }
                } else {
                    return null;
                }
                return o;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            RecipeExtendedSymbol[] symbols = RecipeExtendedSymbol.arrayOf(objs);
            this.currentRecipe = this.recipeGroup.findRecipe(symbols, this.tier);
        }
    }

    public boolean canProcess() {
        if (this.allPartsPresent() && this.currentRecipe != null) {
            return this.currentRecipe.canMultiblockProcess(this);
        }
        return false;
    }

    public boolean areItemOutputsValid(ItemStack stack) {
        if (!this.usesItemOutput) {
            return true;
        }
        int outputAmountRemaining = stack.stackSize;
        stack = stack.copy();
        stack.stackSize *= this.parallel;
        if ((outputAmountRemaining *= this.parallel) <= 0) {
            return true;
        }
        for (ItemStack outputStack : this.itemOutput.itemContents) {
            int willTake;
            int maxFreeAmountInSlot;
            if (outputStack != null) {
                if (outputStack.isItemEqual(stack)) {
                    maxFreeAmountInSlot = Math.min(outputStack.getMaxStackSize(), this.itemOutput.getMaxStackSize()) - outputStack.stackSize;
                    willTake = Math.min(outputAmountRemaining, maxFreeAmountInSlot);
                    outputAmountRemaining -= willTake;
                }
            } else {
                maxFreeAmountInSlot = Math.min(this.itemOutput.getMaxStackSize(), stack.getMaxStackSize());
                willTake = Math.min(outputAmountRemaining, maxFreeAmountInSlot);
                outputAmountRemaining -= willTake;
            }
            if (outputAmountRemaining <= 0) break;
        }
        return outputAmountRemaining <= 0;
    }

    public boolean areFluidOutputsValid(FluidStack stack) {
        if (!this.usesFluidOutput) {
            return true;
        }
        int outputAmountRemaining = stack.amount;
        if ((outputAmountRemaining *= this.parallel) <= 0) {
            return true;
        }
        FluidStack[] contents = this.fluidOutput.fluidContents;
        for (int i = 0; i < contents.length; ++i) {
            int willTake;
            int maxFreeAmountInSlot;
            FluidStack outputStack = contents[i];
            if (outputStack != null) {
                if (outputStack.isFluidEqual(stack)) {
                    maxFreeAmountInSlot = this.fluidOutput.getFluidCapacityForSlot(i) - outputStack.amount;
                    willTake = Math.min(outputAmountRemaining, maxFreeAmountInSlot);
                    outputAmountRemaining -= willTake;
                }
            } else {
                maxFreeAmountInSlot = this.fluidOutput.getFluidCapacityForSlot(i);
                willTake = Math.min(outputAmountRemaining, maxFreeAmountInSlot);
                outputAmountRemaining -= willTake;
            }
            if (outputAmountRemaining <= 0) break;
        }
        return outputAmountRemaining <= 0;
    }

    public void processItem() {
        if (this.canProcess()) {
            this.currentRecipe.processMultiblockRecipe(this);
        }
    }

    public void consumeInputs() {
        if (this.currentRecipe != null) {
            this.currentRecipe.consumeMultiblockInputs(this);
        }
    }

    public void setActiveFluidSlotForSide(Direction dir, int slot) {
        this.activeFluidSlots.replace(dir, slot);
    }

    public void setActiveItemSlotForSide(Direction dir, int slot) {
        this.activeItemSlots.replace(dir, slot);
    }

    public void cycleItemIOForSide(Direction dir) {
        switch ((Connection)this.itemConnections.get(dir)) {
            case NONE: {
                this.itemConnections.replace(dir, Connection.INPUT);
                break;
            }
            case INPUT: {
                this.itemConnections.replace(dir, Connection.OUTPUT);
                break;
            }
            case OUTPUT: {
                this.itemConnections.replace(dir, Connection.BOTH);
                break;
            }
            case BOTH: {
                this.itemConnections.replace(dir, Connection.NONE);
            }
        }
    }

    public void cycleActiveItemSlotForSide(Direction dir, boolean backwards) {
        int i = (Integer)this.activeItemSlots.get(dir);
        if (!backwards) {
            if (i < this.getContainerSize() - 1) {
                this.activeItemSlots.replace(dir, i + 1);
            } else {
                this.activeItemSlots.replace(dir, 0);
            }
        } else if (i > -1) {
            this.activeItemSlots.replace(dir, i - 1);
        } else {
            this.activeItemSlots.replace(dir, this.getContainerSize() - 1);
        }
    }

    public void cycleFluidIOForSide(Direction dir) {
        switch ((Connection)this.fluidConnections.get(dir)) {
            case NONE: {
                this.fluidConnections.replace(dir, Connection.INPUT);
                break;
            }
            case INPUT: {
                this.fluidConnections.replace(dir, Connection.OUTPUT);
                break;
            }
            case OUTPUT: {
                this.fluidConnections.replace(dir, Connection.BOTH);
                break;
            }
            case BOTH: {
                this.fluidConnections.replace(dir, Connection.NONE);
            }
        }
    }

    public void cycleActiveFluidSlotForSide(Direction dir, boolean backwards) {
        int i = (Integer)this.activeFluidSlots.get(dir);
        if (!backwards) {
            if (i < this.getContainerSize() - 1) {
                this.activeFluidSlots.replace(dir, i + 1);
            } else {
                this.activeFluidSlots.replace(dir, 0);
            }
        } else if (i > -1) {
            this.activeFluidSlots.replace(dir, i - 1);
        } else {
            this.activeFluidSlots.replace(dir, this.getContainerSize() - 1);
        }
    }
}

