/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.TickTimer;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.multiblocks.Multiblock;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.interfaces.IBoostable;
import sunsetsatellite.signalindustries.items.ItemBlueprint;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;
import sunsetsatellite.signalindustries.util.SIMultiblock;

public class TileEntityBuilder
extends TileEntityTieredMachineBase
implements IBoostable {
    public int cost = 10;
    public TickTimer workTimer = new TickTimer((Object)this, this::work, 5, true);
    public Vec3i offset = new Vec3i();
    public Direction rotation = Direction.Z_NEG;
    public SIMultiblock buildingMultiblock;
    public ArrayList<BlockInstance> buildingBlocks = new ArrayList();
    public Vec3i currentlyBuilding = new Vec3i();
    public int buildingBlockIndex = 0;
    public int builtBlocks = 0;

    public TileEntityBuilder() {
        this.itemContents = new ItemStack[28];
        this.fluidContents = new FluidStack[1];
        this.fluidCapacity = new int[1];
        this.fluidCapacity[0] = 2000;
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
        this.workTimer.pause();
    }

    public void work() {
        SIMultiblock multiblock = this.getMultiblock();
        if (multiblock != null) {
            this.setStructureToBuild();
            if (this.buildingBlocks.isEmpty()) {
                this.workTimer.pause();
                return;
            }
            BlockInstance blockInstance = this.buildingBlocks.get(this.buildingBlockIndex);
            if (Arrays.stream(this.itemContents).anyMatch(S -> S != null && S.stackSize > 0 && S.itemID == blockInstance.block.id())) {
                if (this.fluidContents[0] != null && this.fluidContents[0].amount >= this.cost && blockInstance.place(this.worldObj)) {
                    this.fluidContents[0].amount -= this.cost;
                    List stackList = Arrays.stream(this.itemContents).filter(S -> S != null && S.stackSize > 0 && S.itemID == blockInstance.block.id()).collect(Collectors.toList());
                    --((ItemStack)stackList.get((int)0)).stackSize;
                    this.buildingBlocks.remove(blockInstance);
                    ++this.builtBlocks;
                }
            } else if (Arrays.stream(this.itemContents).anyMatch(S -> S != null && S.stackSize > 0 && S.getItem().equals(SIItems.unlimitedChip)) && blockInstance.place(this.worldObj)) {
                this.buildingBlocks.remove(blockInstance);
                ++this.builtBlocks;
            }
            ++this.buildingBlockIndex;
            if (this.buildingBlockIndex >= this.buildingBlocks.size()) {
                this.buildingBlockIndex = 0;
            }
            if (!this.buildingBlocks.isEmpty()) {
                this.currentlyBuilding = this.buildingBlocks.get((int)this.buildingBlockIndex).pos;
            }
        }
    }

    @Override
    public void tick() {
        int i;
        super.tick();
        if (this.worldObj != null && this.worldObj.isClientSide) {
            return;
        }
        this.extractFluids();
        this.workTimer.max = (int)(10.0f / this.speedMultiplier);
        this.workTimer.tick();
        if (this.fluidContents[0] == null || this.itemContents[0] == null || !(this.itemContents[0].getItem() instanceof ItemBlueprint)) {
            this.reset();
        }
        this.fuelMaxBurnTicks = this.workTimer.max;
        this.progressMaxTicks = this.workTimer.max;
        this.fuelBurnTicks = this.workTimer.max - this.workTimer.value;
        this.progressTicks = this.workTimer.value;
        for (i = 0; i < this.itemContents.length; ++i) {
            if (this.itemContents[i] == null || this.itemContents[i].stackSize > 0) continue;
            this.itemContents[i] = null;
        }
        for (i = 0; i < this.fluidContents.length; ++i) {
            if (this.fluidContents[i] == null || this.fluidContents[i].amount > 0) continue;
            this.fluidContents[i] = null;
        }
    }

    public void reset() {
        this.workTimer.pause();
        this.buildingBlockIndex = 0;
        this.builtBlocks = 0;
        this.currentlyBuilding = new Vec3i();
        this.buildingMultiblock = null;
        this.buildingBlocks.clear();
    }

    public void setStructureToBuild() {
        SIMultiblock multiblock = this.getMultiblock();
        if (multiblock != null) {
            if (this.buildingMultiblock == null && this.buildingBlocks.isEmpty()) {
                this.buildingMultiblock = multiblock;
                ArrayList blocks = multiblock.getBlocks(new Vec3i(this.x, this.y, this.z).add(this.offset), this.rotation);
                blocks.add(multiblock.getOrigin(new Vec3i(this.x, this.y, this.z).add(this.offset), this.rotation));
                this.buildingBlocks = blocks;
            } else if (this.buildingMultiblock != multiblock) {
                this.buildingBlockIndex = 0;
                this.builtBlocks = 0;
                this.currentlyBuilding = new Vec3i();
                this.buildingMultiblock = multiblock;
                ArrayList blocks = multiblock.getBlocks(new Vec3i(this.x, this.y, this.z).add(this.offset), this.rotation);
                blocks.add(multiblock.getOrigin(new Vec3i(this.x, this.y, this.z).add(this.offset), this.rotation));
                this.buildingBlocks = blocks;
            }
        }
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        CompoundTag offsetTag = new CompoundTag();
        this.offset.writeToNBT(offsetTag);
        tag.put("Offset", (Tag)offsetTag);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.offset = new Vec3i(tag.getCompound("Offset"));
    }

    @Override
    public boolean isBurning() {
        return this.fluidContents[0] != null && !this.workTimer.isPaused();
    }

    public SIMultiblock getMultiblock() {
        if (this.itemContents[0] != null && this.itemContents[0].getItem() instanceof ItemBlueprint) {
            String key = this.itemContents[0].getData().getStringOrDefault("multiblock", "");
            if (Objects.equals(key, "")) {
                return null;
            }
            SIMultiblock multiblock = (SIMultiblock)((Object)Multiblock.multiblocks.get(key.replace("multiblock.signalindustries.", "")));
            if (multiblock == null) {
                return null;
            }
            return multiblock;
        }
        return null;
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.builder";
    }
}

