/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines;

import java.util.ArrayList;
import net.minecraft.core.crafting.LookupFuelFurnace;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.SIRecipes;
import sunsetsatellite.signalindustries.interfaces.IBoostable;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;

public class TileEntityExtractor
extends TileEntityTieredMachineBase
implements IBoostable {
    public TileEntityExtractor() {
        this.itemContents = new ItemStack[2];
        this.fluidCapacity[0] = 2000;
        ((ArrayList)this.acceptedFluids.get(0)).add(SIFluids.ENERGY);
    }

    @Override
    public void tick() {
        super.tick();
        this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
        this.extractFluids();
        for (int i = 0; i < this.itemContents.length; ++i) {
            if (this.itemContents[i] == null || this.itemContents[i].stackSize > 0) continue;
            this.itemContents[i] = null;
        }
        boolean update = false;
        if (this.fuelBurnTicks > 0) {
            --this.fuelBurnTicks;
        }
        if (this.itemContents[0] == null) {
            this.progressTicks = 0;
        } else if (this.canProcess()) {
            this.progressMaxTicks = (int)(200.0f / this.speedMultiplier);
        }
        if (!this.worldObj.isClientSide) {
            if (this.progressTicks == 0 && this.canProcess() && this.fuelBurnTicks < 2) {
                update = this.fuel();
            }
            if (this.isBurning() && this.canProcess()) {
                ++this.progressTicks;
                if (this.progressTicks >= this.progressMaxTicks) {
                    this.progressTicks = 0;
                    this.processItem();
                    update = true;
                }
            } else if (this.canProcess() && this.fuelBurnTicks < 2) {
                this.fuel();
            }
        }
        if (update) {
            this.setChanged();
        }
    }

    public boolean fuel() {
        int burn = this.getItemBurnTime(this.itemContents[1]);
        if (burn > 0 && this.canProcess()) {
            this.progressMaxTicks = (int)(200.0f / this.speedMultiplier);
            this.fuelMaxBurnTicks = this.fuelBurnTicks = burn;
            if (this.itemContents[1].getItem().hasContainerItem()) {
                this.itemContents[1] = new ItemStack(this.itemContents[1].getItem().getContainerItem());
            } else {
                --this.itemContents[1].stackSize;
                if (this.itemContents[1].stackSize == 0) {
                    this.itemContents[1] = null;
                }
            }
            return true;
        }
        return false;
    }

    public void processItem() {
        if (this.canProcess()) {
            FluidStack stack = SIRecipes.EXTRACTOR.findFluidOutput(this.itemContents[0], this.tier);
            if (stack == null) {
                return;
            }
            if (this.fluidContents[0] == null || this.getFluidInSlot((int)0).fluid == null) {
                this.setFluidInSlot(0, stack);
            } else if (this.getFluidInSlot((int)0).fluid == stack.fluid) {
                this.fluidContents[0].amount += stack.amount;
            }
            if (this.itemContents[0].getItem().hasContainerItem()) {
                this.itemContents[0] = new ItemStack(this.itemContents[0].getItem().getContainerItem());
            } else {
                --this.itemContents[0].stackSize;
            }
            if (this.itemContents[0].stackSize <= 0) {
                this.itemContents[0] = null;
            }
        }
    }

    private boolean canProcess() {
        if (this.itemContents[0] == null) {
            return false;
        }
        FluidStack stack = SIRecipes.EXTRACTOR.findFluidOutput(this.itemContents[0], this.tier);
        return stack != null && (this.fluidContents[0] == null || this.fluidContents[0].isFluidEqual(stack) && this.fluidContents[0].amount + stack.amount <= this.fluidCapacity[0]);
    }

    private int getItemBurnTime(ItemStack stack) {
        return stack == null ? 0 : LookupFuelFurnace.instance.getFuelYield(stack.getItem().id);
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.extractor";
    }
}

