/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import sunsetsatellite.catalyst.core.util.Connection;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.TickTimer;
import sunsetsatellite.catalyst.fluids.util.Fluid;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.interfaces.IHasIOPreview;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredContainer;
import sunsetsatellite.signalindustries.util.IOPreview;
import sunsetsatellite.signalindustries.util.Tier;

public class TileEntitySIFluidTank
extends TileEntityTieredContainer
implements IHasIOPreview {
    public boolean isInfiniteSource = true;
    public IOPreview preview = IOPreview.NONE;
    public TickTimer IOPreviewTimer = new TickTimer((Object)this, this::disableIOPreview, 20, false);

    @Override
    public void disableIOPreview() {
        this.preview = IOPreview.NONE;
    }

    @Override
    public void setTemporaryIOPreview(IOPreview preview, int ticks) {
        this.IOPreviewTimer.value = ticks;
        this.IOPreviewTimer.max = ticks;
        this.IOPreviewTimer.unpause();
        this.preview = preview;
    }

    public TileEntitySIFluidTank() {
        this.fluidContents = new FluidStack[1];
        this.fluidCapacity = new int[1];
        this.itemContents = new ItemStack[0];
        this.fluidCapacity[0] = 16000;
        this.transferSpeed = 50;
        this.fluidConnections.replace(Direction.Y_POS, Connection.INPUT);
        this.fluidConnections.replace(Direction.Y_NEG, Connection.OUTPUT);
        Fluid.fluidMap.forEach((K, V) -> {
            if (V != SIFluids.ENERGY) {
                ((ArrayList)this.acceptedFluids.get(0)).add(V);
            }
        });
    }

    @Override
    public void tick() {
        this.IOPreviewTimer.tick();
        if (this.tier == Tier.INFINITE) {
            for (Map.Entry entry : this.fluidConnections.entrySet()) {
                if (this.isInfiniteSource) {
                    if (entry.getValue() != Connection.INPUT && entry.getValue() != Connection.BOTH) continue;
                    entry.setValue(Connection.OUTPUT);
                    continue;
                }
                if (entry.getValue() != Connection.OUTPUT && entry.getValue() != Connection.BOTH) continue;
                entry.setValue(Connection.INPUT);
            }
            if (this.isInfiniteSource) {
                this.fluidCapacity[0] = Integer.MAX_VALUE;
                this.transferSpeed = Integer.MAX_VALUE;
                if (this.fluidContents[0] != null) {
                    this.fluidContents[0].amount = Integer.MAX_VALUE;
                }
            } else {
                this.fluidCapacity[0] = Integer.MAX_VALUE;
                this.transferSpeed = Integer.MAX_VALUE;
                if (this.fluidContents[0] != null) {
                    this.fluidContents[0] = null;
                }
            }
        } else {
            this.fluidCapacity[0] = (int)Math.pow(2.0, this.tier.ordinal()) * 16000;
            this.transferSpeed = 50 * (this.tier.ordinal() + 1);
        }
        this.extractFluids();
        super.tick();
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
    }

    @Override
    public IOPreview getPreview() {
        return this.preview;
    }

    @Override
    public void setPreview(IOPreview preview) {
        this.preview = preview;
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.fluidTank";
    }

    public boolean canBeCarried(World world, Entity potentialHolder) {
        return true;
    }
}

