/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines.multiblocks;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.crafting.LookupFuelFurnace;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.mixin.interfaces.ITileEntityInit;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.fluids.util.RecipeExtendedSymbol;
import sunsetsatellite.catalyst.multiblocks.IMultiblock;
import sunsetsatellite.catalyst.multiblocks.Multiblock;
import sunsetsatellite.catalyst.multiblocks.MultiblockInstance;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SIRecipes;
import sunsetsatellite.signalindustries.interfaces.IMultiblockPart;
import sunsetsatellite.signalindustries.recipes.RecipeGroupSI;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachineFluid;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntrySI;
import sunsetsatellite.signalindustries.tiles.TileEntityFluidHatch;
import sunsetsatellite.signalindustries.tiles.TileEntityItemBus;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;
import sunsetsatellite.signalindustries.util.RecipeProperties;

public class TileEntityReinforcedExtractor
extends TileEntityTieredMachineBase
implements IMultiblock,
ITileEntityInit {
    public MultiblockInstance multiblock;
    public TileEntityItemBus input;
    public TileEntityFluidHatch output;
    public RecipeGroupSI<?> recipeGroup;
    public RecipeEntrySI<?, ?, RecipeProperties> currentRecipe;

    public TileEntityReinforcedExtractor() {
        this.itemContents = new ItemStack[1];
        this.fluidContents = new FluidStack[0];
        this.fluidCapacity = new int[0];
        this.recipeGroup = SIRecipes.EXTRACTOR;
        this.multiblock = new MultiblockInstance((TileEntity)this, (Multiblock)Multiblock.multiblocks.get("extractionManifold"));
    }

    @Override
    public void init(Block<?> block) {
        super.init(block);
        this.multiblock = new MultiblockInstance((TileEntity)this, (Multiblock)Multiblock.multiblocks.get("extractionManifold"));
    }

    public MultiblockInstance getMultiblock() {
        return this.multiblock;
    }

    @Override
    public void tick() {
        block10: {
            ArrayList blocks;
            if (this.multiblock == null) {
                return;
            }
            super.tick();
            this.worldObj.markBlocksDirty(this.x, this.y, this.z, this.x, this.y, this.z);
            this.input = null;
            this.output = null;
            if (!this.multiblock.isValid()) break block10;
            Direction dir = Direction.getDirectionFromSide((int)this.getBlockMeta());
            ArrayList tileEntities = this.multiblock.data.getTileEntities(this.worldObj, new Vec3i(this.x, this.y, this.z), dir);
            for (BlockInstance tileEntity : tileEntities) {
                if (!(tileEntity.tile instanceof IMultiblockPart)) continue;
                if (tileEntity.tile instanceof TileEntityItemBus && tileEntity.block == SIBlocks.reinforcedItemInputBus) {
                    this.input = (TileEntityItemBus)tileEntity.tile;
                } else if (tileEntity.tile instanceof TileEntityFluidHatch && tileEntity.block == SIBlocks.reinforcedFluidOutputHatch) {
                    this.output = (TileEntityFluidHatch)tileEntity.tile;
                }
                ((IMultiblockPart)tileEntity.tile).connect((TileEntity)this);
            }
            if (this.input != null && this.output != null) {
                this.setCurrentRecipe();
                this.work();
            }
            if (this.isBurning()) {
                blocks = this.multiblock.data.getBlocks(new Vec3i(this.x, this.y, this.z), dir);
                for (BlockInstance structBlock : blocks) {
                    if (structBlock.block != SIBlocks.reinforcedCasing2 && structBlock.block != SIBlocks.awakenedSocketCasing && structBlock.block != SIBlocks.awakenedCasing2 || structBlock.pos.getBlockMetadata((WorldSource)this.worldObj) == 1) continue;
                    this.worldObj.setBlockMetadata(structBlock.pos.x, structBlock.pos.y, structBlock.pos.z, 1);
                }
            } else {
                blocks = this.multiblock.data.getBlocks(new Vec3i(this.x, this.y, this.z), dir);
                for (BlockInstance structBlock : blocks) {
                    if (structBlock.block != SIBlocks.reinforcedCasing2 && structBlock.block != SIBlocks.awakenedSocketCasing && structBlock.block != SIBlocks.awakenedCasing2 || structBlock.pos.getBlockMetadata((WorldSource)this.worldObj) != 1) continue;
                    this.worldObj.setBlockMetadata(structBlock.pos.x, structBlock.pos.y, structBlock.pos.z, 0);
                }
            }
        }
    }

    public void work() {
        if (this.input != null && this.output != null && this.multiblock.isValid()) {
            ArrayList<ItemStack> inputContents;
            boolean update = false;
            if (this.fuelBurnTicks > 0) {
                --this.fuelBurnTicks;
            }
            if ((inputContents = this.getInputContents()).isEmpty()) {
                this.progressTicks = 0;
            } else if (this.canProcess()) {
                this.progressMaxTicks = (int)((float)((RecipeProperties)this.currentRecipe.getData()).ticks / this.speedMultiplier);
            }
            if (!this.worldObj.isClientSide) {
                if (this.progressTicks == 0 && this.canProcess() && this.fuelBurnTicks < 2) {
                    update = this.fuel();
                }
                if (this.isBurning() && this.canProcess()) {
                    ++this.progressTicks;
                    if (this.progressTicks >= this.progressMaxTicks) {
                        this.progressTicks = 0;
                        this.processItem();
                        update = true;
                    }
                } else if (this.canProcess()) {
                    this.fuel();
                    if (this.fuelBurnTicks > 0) {
                        ++this.fuelBurnTicks;
                    }
                }
            }
            if (update) {
                this.setChanged();
            }
        }
    }

    @Override
    public boolean isBurning() {
        return super.isBurning() && this.multiblock.isValid();
    }

    @NotNull
    private ArrayList<ItemStack> getInputContents() {
        return Catalyst.condenseItemList(Arrays.asList(this.input.itemContents));
    }

    private void processItem() {
        if (this.currentRecipe instanceof RecipeEntryMachineFluid && this.multiblock.isValid()) {
            RecipeEntryMachineFluid recipe = (RecipeEntryMachineFluid)this.currentRecipe;
            FluidStack fluidStack = recipe.getOutput() == null ? null : ((FluidStack)recipe.getOutput()).copy();
            int k = 0;
            if (fluidStack != null) {
                ItemStack inputStack = (ItemStack)((RecipeExtendedSymbol[])recipe.getInput())[0].resolve().get(0);
                block0: for (int i = 0; i < inputStack.stackSize; ++i) {
                    ItemStack[] contents = this.input.itemContents;
                    for (int j = 0; j < contents.length; ++j) {
                        ItemStack itemContent = contents[j];
                        if (itemContent == null || !itemContent.isItemEqual(inputStack)) continue;
                        --itemContent.stackSize;
                        ++k;
                        if (itemContent.stackSize > 0) continue block0;
                        contents[j] = null;
                        continue block0;
                    }
                }
                if (k == inputStack.stackSize) {
                    this.output.insertFluid(0, fluidStack);
                }
            }
        }
    }

    public boolean fuel() {
        int burn = this.getItemBurnTime(this.itemContents[0]);
        if (burn > 0 && this.canProcess()) {
            this.fuelMaxBurnTicks = this.fuelBurnTicks = burn;
            if (this.itemContents[0].getItem().hasContainerItem()) {
                this.itemContents[0] = new ItemStack(this.itemContents[0].getItem().getContainerItem());
            } else {
                --this.itemContents[0].stackSize;
                if (this.itemContents[0].stackSize == 0) {
                    this.itemContents[0] = null;
                }
            }
            return true;
        }
        return false;
    }

    private int getItemBurnTime(ItemStack stack) {
        return stack == null ? 0 : LookupFuelFurnace.instance.getFuelYield(stack.getItem().id);
    }

    private boolean canProcess() {
        if (this.input != null && this.output != null && this.multiblock.isValid()) {
            ArrayList<ItemStack> inputContents = this.getInputContents();
            if (inputContents.isEmpty()) {
                return false;
            }
            FluidStack output = this.recipeGroup.findFluidOutput(RecipeExtendedSymbol.arrayOf((Object[])new Object[]{inputContents}), this.tier);
            return output != null && (this.output.fluidContents[0] == null || this.output.fluidContents[0].isFluidEqual(output) && this.output.fluidContents[0].amount + output.amount <= this.output.fluidCapacity[0]);
        }
        return false;
    }

    public void setCurrentRecipe() {
        if (this.input != null && this.multiblock.isValid()) {
            ArrayList<ItemStack> inputContents = this.getInputContents();
            this.currentRecipe = this.recipeGroup.findRecipe(RecipeExtendedSymbol.arrayOf((Object[])new Object[]{inputContents}), this.tier);
        }
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.extractor";
    }
}

