/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.tiles.machines.multiblocks;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.TickTimer;
import sunsetsatellite.catalyst.core.util.mixin.interfaces.ITileEntityInit;
import sunsetsatellite.catalyst.core.util.vector.Vec3f;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.multiblocks.IMultiblock;
import sunsetsatellite.catalyst.multiblocks.Multiblock;
import sunsetsatellite.catalyst.multiblocks.MultiblockInstance;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SIDimensions;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.interfaces.IMultiblockPart;
import sunsetsatellite.signalindustries.interfaces.IStabilizable;
import sunsetsatellite.signalindustries.interfaces.mixins.IWarpPlayer;
import sunsetsatellite.signalindustries.items.ItemWarpOrb;
import sunsetsatellite.signalindustries.tiles.TileEntityEnergyConnector;
import sunsetsatellite.signalindustries.tiles.TileEntityFluidHatch;
import sunsetsatellite.signalindustries.tiles.TileEntityItemBus;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineBase;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityStabilizer;

public class TileEntityWarpGate
extends TileEntityTieredMachineBase
implements IMultiblock,
IStabilizable,
ITileEntityInit {
    public MultiblockInstance multiblock;
    public TileEntityItemBus itemInput;
    public TileEntityItemBus itemOutput;
    public TileEntityFluidHatch fluidInput;
    public TileEntityFluidHatch fluidOutput;
    public TileEntityEnergyConnector energy;
    public List<TileEntityStabilizer> stabilizers = new ArrayList<TileEntityStabilizer>();
    private final TickTimer chargeTimer = new TickTimer((Object)this, this::charge, 10, true);
    private final TickTimer stabilityVerifyTimer = new TickTimer((Object)this, this::verifyStability, 20, true);
    public State state = State.IDLE;
    public static int chargeCost = 10;
    public static int runCost = 1;

    public TileEntityWarpGate() {
        this.itemContents = new ItemStack[1];
        this.fluidContents = new FluidStack[0];
        this.fluidCapacity = new int[0];
        this.multiblock = new MultiblockInstance((TileEntity)this, (Multiblock)Multiblock.multiblocks.get("warpGate"));
    }

    @Override
    public void init(Block<?> block) {
        super.init(block);
        this.multiblock = new MultiblockInstance((TileEntity)this, (Multiblock)Multiblock.multiblocks.get("warpGate"));
    }

    public String getNameTranslationKey() {
        return "container.signalindustries.warpGate";
    }

    @Override
    public void tick() {
        if (this.multiblock == null || this.worldObj == null) {
            return;
        }
        super.tick();
        this.itemInput = null;
        this.itemOutput = null;
        this.energy = null;
        this.chargeTimer.tick();
        this.stabilizers.clear();
        if (this.multiblock.isValid()) {
            Direction dir = Direction.getDirectionFromSide((int)this.getBlockMeta());
            ArrayList tileEntities = this.multiblock.data.getTileEntities(this.worldObj, new Vec3i(this.x, this.y, this.z), dir);
            for (BlockInstance tileEntity : tileEntities) {
                if (!(tileEntity.tile instanceof IMultiblockPart)) continue;
                if (tileEntity.tile instanceof TileEntityItemBus && tileEntity.block == SIBlocks.reinforcedItemInputBus) {
                    this.itemInput = (TileEntityItemBus)tileEntity.tile;
                } else if (tileEntity.tile instanceof TileEntityItemBus && tileEntity.block == SIBlocks.reinforcedItemOutputBus) {
                    this.itemOutput = (TileEntityItemBus)tileEntity.tile;
                } else if (tileEntity.tile instanceof TileEntityFluidHatch && tileEntity.block == SIBlocks.reinforcedFluidInputHatch) {
                    this.fluidInput = (TileEntityFluidHatch)tileEntity.tile;
                } else if (tileEntity.tile instanceof TileEntityFluidHatch && tileEntity.block == SIBlocks.reinforcedFluidOutputHatch) {
                    this.fluidOutput = (TileEntityFluidHatch)tileEntity.tile;
                } else if (tileEntity.tile instanceof TileEntityEnergyConnector && tileEntity.block == SIBlocks.awakenedEnergyConnector) {
                    this.energy = (TileEntityEnergyConnector)tileEntity.tile;
                }
                if (tileEntity.tile instanceof TileEntityStabilizer) {
                    this.stabilizers.add((TileEntityStabilizer)tileEntity.tile);
                }
                ((IMultiblockPart)tileEntity.tile).connect((TileEntity)this);
            }
            this.stabilityVerifyTimer.tick();
            if (this.getBlock() != null && this.itemInput != null && this.itemOutput != null && this.fluidInput != null && this.fluidOutput != null && this.energy != null) {
                if (this.state == State.IDLE && (this.worldObj.hasNeighborSignal(this.x, this.y, this.z) || this.worldObj.hasDirectSignal(this.x, this.y, this.z)) && this.warpOrbInserted()) {
                    this.state = State.CHARGING;
                } else if (this.state != State.IDLE && !this.worldObj.hasNeighborSignal(this.x, this.y, this.z) && !this.worldObj.hasDirectSignal(this.x, this.y, this.z)) {
                    this.state = State.IDLE;
                }
            }
            if (this.state == State.CHARGING && this.energy != null) {
                if (this.getEnergyAmount() >= chargeCost) {
                    this.energy.fluidContents[0].amount -= chargeCost;
                } else {
                    this.state = State.IDLE;
                }
            }
            if (this.state == State.CONNECTED_ONE_WAY || this.state == State.CONNECTED_TWO_WAY) {
                if (this.getEnergyAmount() >= runCost) {
                    this.energy.fluidContents[0].amount -= runCost;
                } else {
                    this.state = State.POWER_FAILURE;
                }
                Axis axis = dir.shiftAxis().getAxis();
                Vec3f offset = dir.getVecF().multiply(4.0);
                Vec3f min = new Vec3f((double)this.x, (double)this.y, (double)this.z).subtract(offset);
                Vec3f max = new Vec3f((double)this.x, (double)this.y, (double)this.z).subtract(offset);
                min.y -= 3.0;
                max.y += 3.0;
                min.set(axis, min.get(axis) - 3.0);
                max.set(axis, max.get(axis) + 3.0);
                Player closestPlayer = this.worldObj.getClosestPlayer((double)this.x, (double)this.y, (double)this.z, 8.0);
                if (closestPlayer != null && this.warpOrbInserted() && closestPlayer.x >= min.x && closestPlayer.y >= min.y && closestPlayer.z >= min.z && closestPlayer.x <= max.x + 1.0 && closestPlayer.y <= max.y && closestPlayer.z <= max.z + 1.0) {
                    CompoundTag data = this.itemContents[0].getData();
                    CompoundTag warpPosition = data.getCompound("position");
                    if (warpPosition.containsKey("x") && warpPosition.containsKey("y") && warpPosition.containsKey("z")) {
                        if (closestPlayer.dimension == SIDimensions.ETERNITY.id) {
                            // empty if block
                        }
                        if (data.getInteger("dim") != closestPlayer.dimension) {
                            ((IWarpPlayer)closestPlayer).warp(data.getInteger("dim"));
                        }
                        closestPlayer.setPos((double)warpPosition.getInteger("x"), (double)warpPosition.getInteger("y"), (double)warpPosition.getInteger("z"));
                    } else {
                        ((IWarpPlayer)closestPlayer).warp(SIDimensions.ETERNITY.id);
                    }
                }
            }
        } else {
            this.state = State.IDLE;
        }
    }

    public void verifyStability() {
        if (this.state == State.CHARGING && this.checkIfStabilizersReady() && this.warpOrbInserted() && this.getEnergyAmount() >= runCost && this.areCasingsCharged()) {
            this.state = State.CONNECTED_ONE_WAY;
        }
        if (this.state == State.CONNECTED_ONE_WAY || this.state == State.CONNECTED_TWO_WAY) {
            if (!this.warpOrbInserted()) {
                this.state = State.IDLE;
            }
            if (!this.checkIfStabilizersReady()) {
                this.state = State.STABILIZATION_FAILURE;
            } else if (this.getEnergyAmount() < runCost) {
                this.state = State.POWER_FAILURE;
            }
        }
    }

    public void charge() {
        block3: {
            block4: {
                if (this.worldObj == null) {
                    return;
                }
                if (this.state != State.CHARGING) break block4;
                Direction dir = Direction.getDirectionFromSide((int)this.getBlockMeta());
                ArrayList blocks = this.multiblock.data.getBlocks(new Vec3i(this.x, this.y, this.z), dir);
                for (BlockInstance block : blocks) {
                    if (block.block != SIBlocks.reinforcedCasing2 && block.block != SIBlocks.awakenedSocketCasing && block.block != SIBlocks.awakenedCasing2 || block.pos.getBlockMetadata((WorldSource)this.worldObj) == 1) continue;
                    this.worldObj.setBlockMetadata(block.pos.x, block.pos.y, block.pos.z, 1);
                    break block3;
                }
                break block3;
            }
            if (this.state != State.IDLE && this.state != State.POWER_FAILURE && this.state != State.STABILIZATION_FAILURE) break block3;
            Direction dir = Direction.getDirectionFromSide((int)this.getBlockMeta());
            ArrayList blocks = this.multiblock.data.getBlocks(new Vec3i(this.x, this.y, this.z), dir);
            for (BlockInstance block : blocks) {
                if (block.block != SIBlocks.reinforcedCasing2 && block.block != SIBlocks.awakenedSocketCasing && block.block != SIBlocks.awakenedCasing2 || block.pos.getBlockMetadata((WorldSource)this.worldObj) == 0) continue;
                this.worldObj.setBlockMetadata(block.pos.x, block.pos.y, block.pos.z, 0);
                break;
            }
        }
    }

    public boolean warpOrbInserted() {
        return this.itemContents[0] != null && this.itemContents[0].getItem() instanceof ItemWarpOrb;
    }

    public boolean checkIfStabilizersReady() {
        boolean ready = true;
        for (TileEntityStabilizer stabilizer : this.stabilizers) {
            if (stabilizer.canProcess()) continue;
            ready = false;
        }
        return ready;
    }

    public boolean areCasingsCharged() {
        if (this.worldObj == null) {
            return false;
        }
        Direction dir = Direction.getDirectionFromSide((int)this.getBlockMeta());
        ArrayList blocks = this.multiblock.data.getBlocks(new Vec3i(this.x, this.y, this.z), dir);
        for (BlockInstance block : blocks) {
            if (block.block != SIBlocks.reinforcedCasing2 && block.block != SIBlocks.awakenedSocketCasing && block.block != SIBlocks.awakenedCasing2 || block.pos.getBlockMetadata((WorldSource)this.worldObj) != 0) continue;
            return false;
        }
        return true;
    }

    public int getEnergyAmount() {
        if (this.energy == null) {
            return 0;
        }
        if (this.energy.fluidContents[0] != null && this.energy.fluidContents[0].fluid == SIFluids.ENERGY) {
            return this.energy.fluidContents[0].amount;
        }
        return 0;
    }

    public MultiblockInstance getMultiblock() {
        return this.multiblock;
    }

    @Override
    public boolean isBurning() {
        return this.isActive();
    }

    @Override
    public boolean isActive() {
        return this.state == State.CONNECTED_ONE_WAY || this.state == State.CONNECTED_TWO_WAY;
    }

    @Override
    public boolean isReady() {
        return this.state == State.CHARGING;
    }

    public static enum State {
        IDLE,
        CHARGING,
        CONNECTED_ONE_WAY,
        CONNECTED_TWO_WAY,
        STABILIZATION_FAILURE,
        POWER_FAILURE;

    }
}

