/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.util;

import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.core.util.helper.Side;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.signalindustries.util.Tier;

public class MachineTextures {
    public HashMap<Side, String> defaultTextures = (HashMap)Catalyst.mapOf((Object[])((Side[])Arrays.stream(Side.values()).filter(s -> s != Side.NONE).toArray(Side[]::new)), (Object[])((String[])Catalyst.arrayFill((Object[])new String[Side.values().length - 1], (Object)"minecraft:block/texture_unassigned")));
    public HashMap<Side, String> activeTextures = (HashMap)Catalyst.mapOf((Object[])((Side[])Arrays.stream(Side.values()).filter(s -> s != Side.NONE).toArray(Side[]::new)), (Object[])((String[])Catalyst.arrayFill((Object[])new String[Side.values().length - 1], (Object)"minecraft:block/texture_unassigned")));
    public HashMap<Side, String> overbrightTextures = (HashMap)Catalyst.mapOf((Object[])((Side[])Arrays.stream(Side.values()).filter(s -> s != Side.NONE).toArray(Side[]::new)), (Object[])((String[])Catalyst.arrayFill((Object[])new String[Side.values().length - 1], null)));

    public MachineTextures() {
    }

    public MachineTextures(Tier tier) {
        switch (tier) {
            case PROTOTYPE: {
                this.withDefaultTexture("prototype_blank");
                this.withActiveTexture("prototype_blank");
                break;
            }
            case BASIC: {
                this.withDefaultTexture("basic_blank");
                this.withActiveTexture("basic_blank");
                break;
            }
            case REINFORCED: {
                this.withDefaultTexture("reinforced_blank");
                this.withActiveTexture("reinforced_blank");
                break;
            }
            case AWAKENED: {
                this.withDefaultTexture("awakened_blank");
                this.withActiveTexture("awakened_blank");
            }
        }
    }

    public MachineTextures withDefaultTexture(String texture) {
        this.defaultTextures.replaceAll((S, I) -> "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withActiveTexture(String texture) {
        this.activeTextures.replaceAll((S, I) -> "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withOverbrightTextures(String texture) {
        this.overbrightTextures.replaceAll((S, I) -> "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withDefaultSideTextures(String texture) {
        this.defaultTextures.replaceAll((S, I) -> {
            if (S.isHorizontal()) {
                return "signalindustries:block/" + texture;
            }
            return I;
        });
        return this;
    }

    public MachineTextures withActiveSideTextures(String texture) {
        this.activeTextures.replaceAll((S, I) -> {
            if (S.isHorizontal()) {
                return "signalindustries:block/" + texture;
            }
            return I;
        });
        return this;
    }

    public MachineTextures withOverbrightSideTextures(String texture) {
        this.overbrightTextures.replaceAll((S, I) -> {
            if (S.isHorizontal()) {
                return "signalindustries:block/" + texture;
            }
            return I;
        });
        return this;
    }

    public MachineTextures withDefaultTopBottomTextures(String texture) {
        this.defaultTextures.replaceAll((S, I) -> {
            if (S.isVertical()) {
                return "signalindustries:block/" + texture;
            }
            return I;
        });
        return this;
    }

    public MachineTextures withActiveTopBottomTextures(String texture) {
        this.activeTextures.replaceAll((S, I) -> {
            if (S.isVertical()) {
                return "signalindustries:block/" + texture;
            }
            return I;
        });
        return this;
    }

    public MachineTextures withOverbrightTopBottomTextures(String texture) {
        this.overbrightTextures.replaceAll((S, I) -> {
            if (S.isVertical()) {
                return "signalindustries:block/" + texture;
            }
            return I;
        });
        return this;
    }

    public MachineTextures withDefaultTopTexture(String texture) {
        this.defaultTextures.replace(Side.TOP, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withActiveTopTexture(String texture) {
        this.activeTextures.replace(Side.TOP, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withOverbrightTopTexture(String texture) {
        this.overbrightTextures.replace(Side.TOP, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withDefaultBottomTexture(String texture) {
        this.defaultTextures.replace(Side.BOTTOM, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withActiveBottomTexture(String texture) {
        this.activeTextures.replace(Side.BOTTOM, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withOverbrightBottomTexture(String texture) {
        this.overbrightTextures.replace(Side.BOTTOM, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withDefaultNorthTexture(String texture) {
        this.defaultTextures.replace(Side.NORTH, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withActiveNorthTexture(String texture) {
        this.activeTextures.replace(Side.NORTH, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withOverbrightNorthTexture(String texture) {
        this.overbrightTextures.replace(Side.NORTH, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withDefaultSouthTexture(String texture) {
        this.defaultTextures.replace(Side.SOUTH, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withActiveSouthTexture(String texture) {
        this.activeTextures.replace(Side.SOUTH, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withOverbrightSouthTexture(String texture) {
        this.overbrightTextures.replace(Side.SOUTH, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withDefaultWestTexture(String texture) {
        this.defaultTextures.replace(Side.WEST, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withActiveWestTexture(String texture) {
        this.activeTextures.replace(Side.WEST, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withOverbrightWestTexture(String texture) {
        this.overbrightTextures.replace(Side.WEST, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withDefaultEastTexture(String texture) {
        this.defaultTextures.replace(Side.EAST, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withActiveEastTexture(String texture) {
        this.activeTextures.replace(Side.EAST, "signalindustries:block/" + texture);
        return this;
    }

    public MachineTextures withOverbrightEastTexture(String texture) {
        this.overbrightTextures.replace(Side.EAST, "signalindustries:block/" + texture);
        return this;
    }
}

