/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.util;

import java.util.HashMap;
import net.minecraft.core.util.helper.Side;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.signalindustries.util.Tier;

public class VerticalMachineTextures {
    public HashMap<Side, String> defaultVerticalTextures = (HashMap)Catalyst.mapOf((Object[])Side.values(), (Object[])((String[])Catalyst.arrayFill((Object[])new String[Side.values().length], (Object)"minecraft:block/texture_unassigned")));
    public HashMap<Side, String> activeVerticalTextures = (HashMap)Catalyst.mapOf((Object[])Side.values(), (Object[])((String[])Catalyst.arrayFill((Object[])new String[Side.values().length], (Object)"minecraft:block/texture_unassigned")));
    public HashMap<Side, String> overbrightVerticalTextures = (HashMap)Catalyst.mapOf((Object[])Side.values(), (Object[])((String[])Catalyst.arrayFill((Object[])new String[Side.values().length], null)));
    public static int[] orientationLookUpVertical = new int[]{1, 0, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5};

    public VerticalMachineTextures() {
    }

    public VerticalMachineTextures(Tier tier) {
        switch (tier) {
            case PROTOTYPE: {
                this.withVerticalDefaultTexture("prototype_blank");
                this.withVerticalActiveTexture("prototype_blank");
                break;
            }
            case BASIC: {
                this.withVerticalDefaultTexture("basic_blank");
                this.withVerticalActiveTexture("basic_blank");
                break;
            }
            case REINFORCED: {
                this.withVerticalDefaultTexture("reinforced_blank");
                this.withVerticalActiveTexture("reinforced_blank");
                break;
            }
            case AWAKENED: {
                this.withVerticalDefaultTexture("awakened_blank");
                this.withVerticalActiveTexture("awakened_blank");
            }
        }
    }

    public VerticalMachineTextures withVerticalDefaultTexture(String texture) {
        this.defaultVerticalTextures.replaceAll((S, I) -> "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalActiveTexture(String texture) {
        this.activeVerticalTextures.replaceAll((S, I) -> "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalOverbrightTexture(String texture) {
        this.overbrightVerticalTextures.replaceAll((S, I) -> "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalDefaultSideTextures(String texture) {
        this.defaultVerticalTextures.replaceAll((S, I) -> {
            if (S.isHorizontal()) {
                return "signalindustries:block/" + texture;
            }
            return I;
        });
        return this;
    }

    public VerticalMachineTextures withVerticalActiveSideTextures(String texture) {
        this.activeVerticalTextures.replaceAll((S, I) -> {
            if (S.isHorizontal()) {
                return "signalindustries:block/" + texture;
            }
            return I;
        });
        return this;
    }

    public VerticalMachineTextures withVerticalOverbrightSideTextures(String texture) {
        this.overbrightVerticalTextures.replaceAll((S, I) -> {
            if (S.isHorizontal()) {
                return "signalindustries:block/" + texture;
            }
            return I;
        });
        return this;
    }

    public VerticalMachineTextures withVerticalDefaultTopBottomTextures(String texture) {
        this.defaultVerticalTextures.replaceAll((S, I) -> {
            if (S.isVertical()) {
                return "signalindustries:block/" + texture;
            }
            return I;
        });
        return this;
    }

    public VerticalMachineTextures withVerticalActiveTopBottomTextures(String texture) {
        this.activeVerticalTextures.replaceAll((S, I) -> {
            if (S.isVertical()) {
                return "signalindustries:block/" + texture;
            }
            return I;
        });
        return this;
    }

    public VerticalMachineTextures withVerticalOverbrightTopBottomTextures(String texture) {
        this.overbrightVerticalTextures.replaceAll((S, I) -> {
            if (S.isVertical()) {
                return "signalindustries:block/" + texture;
            }
            return I;
        });
        return this;
    }

    public VerticalMachineTextures withVerticalDefaultTopTexture(String texture) {
        this.defaultVerticalTextures.replace(Side.TOP, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalActiveTopTexture(String texture) {
        this.activeVerticalTextures.replace(Side.TOP, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalOverbrightTopTexture(String texture) {
        this.overbrightVerticalTextures.replace(Side.TOP, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalDefaultBottomTexture(String texture) {
        this.defaultVerticalTextures.replace(Side.BOTTOM, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalActiveBottomTexture(String texture) {
        this.activeVerticalTextures.replace(Side.BOTTOM, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalOverbrightBottomTexture(String texture) {
        this.overbrightVerticalTextures.replace(Side.BOTTOM, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalDefaultNorthTexture(String texture) {
        this.defaultVerticalTextures.replace(Side.NORTH, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalActiveNorthTexture(String texture) {
        this.activeVerticalTextures.replace(Side.NORTH, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalOverbrightNorthTexture(String texture) {
        this.overbrightVerticalTextures.replace(Side.NORTH, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalDefaultSouthTexture(String texture) {
        this.defaultVerticalTextures.replace(Side.SOUTH, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalActiveSouthTexture(String texture) {
        this.activeVerticalTextures.replace(Side.SOUTH, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalOverbrightSouthTexture(String texture) {
        this.overbrightVerticalTextures.replace(Side.SOUTH, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalDefaultWestTexture(String texture) {
        this.defaultVerticalTextures.replace(Side.WEST, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalActiveWestTexture(String texture) {
        this.activeVerticalTextures.replace(Side.WEST, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalOverbrightWestTexture(String texture) {
        this.overbrightVerticalTextures.replace(Side.WEST, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalDefaultEastTexture(String texture) {
        this.defaultVerticalTextures.replace(Side.EAST, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalActiveEastTexture(String texture) {
        this.activeVerticalTextures.replace(Side.EAST, "signalindustries:block/" + texture);
        return this;
    }

    public VerticalMachineTextures withVerticalOverbrightEastTexture(String texture) {
        this.overbrightVerticalTextures.replace(Side.EAST, "signalindustries:block/" + texture);
        return this;
    }
}

