/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.worldgen;

import java.util.Random;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import sunsetsatellite.signalindustries.SIBlocks;

public class WorldFeatureDilithiumCrystal
extends WorldFeature {
    public boolean place(World world, Random random, int i, int j, int k) {
        int maxRadius = 2;
        int maxRadiusRepeat = 4 + random.nextInt(4);
        int radius = 0;
        int worldHeight = world.getHeightBlocks();
        int height = (worldHeight + j) / 4 - (random.nextInt(16) - 8);
        this.generateCircle(world, random, i, height + (maxRadius + maxRadiusRepeat) / 2 + 1, k);
        boolean flip = false;
        int id = SIBlocks.dilithiumCrystalBlock.id();
        int y = 0;
        for (int l = 0; l <= maxRadius * 2; ++l) {
            int x = 0;
            boolean first = true;
            for (int lineRadius = radius; lineRadius >= 0; --lineRadius) {
                int z;
                if (!first) {
                    for (z = -lineRadius; z <= lineRadius; ++z) {
                        world.setBlockWithNotify(i + x, height + y, k + z, id);
                        world.setBlockWithNotify(i + x * -1, height + y, k + z, id);
                    }
                    ++x;
                    continue;
                }
                for (z = -radius; z <= radius; ++z) {
                    world.setBlockWithNotify(i + x, height + y, k + z, id);
                }
                ++x;
                first = false;
            }
            radius = !flip ? ++radius : --radius;
            if (radius >= maxRadius) {
                ++y;
                for (int m = 0; m < maxRadiusRepeat; ++m) {
                    x = 0;
                    for (int lineRadius = maxRadius; lineRadius >= 0; --lineRadius) {
                        if (first) continue;
                        for (int z = -lineRadius; z <= lineRadius; ++z) {
                            world.setBlockWithNotify(i + x, height + y, k + z, id);
                            world.setBlockWithNotify(i + x * -1, height + y, k + z, id);
                        }
                        ++x;
                    }
                    ++y;
                }
                flip = true;
                --radius;
                --y;
            }
            ++y;
        }
        return true;
    }

    private void generateCircle(World world, Random random, int i, int j, int k) {
        int z;
        int x;
        int blockRadius = 5;
        for (x = -blockRadius; x <= blockRadius; ++x) {
            for (z = -blockRadius; z <= blockRadius; ++z) {
                if (!this.isPointInsideCircle(x, z, blockRadius)) continue;
                if (random.nextFloat() < 0.33f) {
                    world.setBlockAndMetadataWithNotify(x + i, j, z + k, SIBlocks.rootedFabric.id(), 0);
                    continue;
                }
                world.setBlockAndMetadataWithNotify(x + i, j, z + k, SIBlocks.realityFabric.id(), 0);
            }
        }
        for (x = -(--blockRadius); x <= blockRadius; ++x) {
            for (z = -blockRadius; z <= blockRadius; ++z) {
                if (!this.isPointInsideCircle(x, z, blockRadius)) continue;
                world.setBlockAndMetadataWithNotify(x + i, j, z + k, 0, 0);
            }
        }
    }

    public boolean isPointInsideSphere(int x, int y, int z, double radius) {
        return (double)(x * x + y * y + z * z) < radius * radius;
    }

    public boolean isPointInsideCircle(int x, int z, double radius) {
        return (double)(x * x + z * z) <= radius * radius;
    }

    public boolean unused(int x, int y, int z, double radius) {
        return (double)(x * x + y * y + z * z + 1) == radius * radius || (double)(x * x + y * y + z * z - 1) == radius * radius;
    }
}

