/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.Item;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SignalIndustries;
import turniplabs.halplibe.util.TomlConfigHandler;
import turniplabs.halplibe.util.toml.Toml;

public class SIConfig {
    private static final int blockIdStart = 1200;
    private static final int itemIdStart = 17100;
    public static final TomlConfigHandler config;

    public static int item(String cfgId) {
        return config.getInt("ItemIDs." + cfgId);
    }

    public static int block(String cfgId) {
        return config.getInt("BlockIDs." + cfgId);
    }

    static {
        List blockFields = Arrays.stream(SIBlocks.class.getDeclaredFields()).filter(F -> Block.class.isAssignableFrom(F.getType())).collect(Collectors.toList());
        List itemFields = Arrays.stream(SIItems.class.getDeclaredFields()).filter(F -> Item.class.isAssignableFrom(F.getType())).collect(Collectors.toList());
        Toml defaultConfig = new Toml("Signal Industries configuration file.");
        defaultConfig.addCategory("BlockIDs");
        defaultConfig.addCategory("ItemIDs");
        defaultConfig.addCategory("EntityIDs");
        defaultConfig.addCategory("Other");
        defaultConfig.addCategory("Experimental");
        defaultConfig.addCategory("These options modify the world generation, the values for chances here are interpreted by the game as 1 in x. A config having the value of 10 would mean 1 in 10.", "WorldGen");
        defaultConfig.addEntry("Experimental.enableDynamicChunkProvider", "Switches the vanilla BTA static provider with a new dynamic one, required for chunkloading to work.", (Object)false);
        defaultConfig.addEntry("Other.enableQuests", (Object)true);
        defaultConfig.addEntry("Other.totemsRequireOP", (Object)false);
        defaultConfig.addEntry("Other.eternityDimId", (Object)3);
        defaultConfig.addEntry("Other.GuiId", (Object)10);
        defaultConfig.addEntry("Other.machinePacketId", (Object)113);
        defaultConfig.addEntry("Other.dilithiumMiningLevel", (Object)4);
        defaultConfig.addEntry("Other.awakenedMiningLevel", (Object)5);
        defaultConfig.addEntry("EntityIDs.infernalId", (Object)100);
        defaultConfig.addEntry("EntityIDs.volatileCrystalId", (Object)50);
        defaultConfig.addEntry("EntityIDs.energyOrbId", (Object)51);
        defaultConfig.addEntry("EntityIDs.fallingMeteorId", (Object)52);
        defaultConfig.addEntry("EntityIDs.sunbeamId", (Object)53);
        defaultConfig.addEntry("WorldGen.signaliteGeodeChance", "Default is 10", (Object)10);
        defaultConfig.addEntry("WorldGen.ironMeteorChance", "Default is 256", (Object)256);
        defaultConfig.addEntry("WorldGen.signaliteMeteorChance", "Default is 512", (Object)512);
        defaultConfig.addEntry("WorldGen.dilithiumMeteorChance", "Default is 1024", (Object)1024);
        defaultConfig.addEntry("WorldGen.obeliskChance", "Default is 2048", (Object)2048);
        int blockId = 1200;
        int itemId = 17100;
        for (Field blockField : blockFields) {
            defaultConfig.addEntry("BlockIDs." + blockField.getName(), (Object)blockId++);
        }
        for (Field itemField : itemFields) {
            defaultConfig.addEntry("ItemIDs." + itemField.getName(), (Object)itemId++);
        }
        config = new TomlConfigHandler("signalindustries", new Toml("Signal Industries configuration file."), false);
        File configFile = config.getConfigFile();
        if (config.getConfigFile().exists()) {
            config.loadConfig();
            config.setDefaults(config.getRawParsed());
            Toml rawConfig = config.getRawParsed();
            Toml blockToml = (Toml)rawConfig.get(".BlockIDs");
            Toml itemToml = (Toml)rawConfig.get(".ItemIDs");
            int maxBlocks = 0;
            int maxItems = 0;
            if (blockToml != null) {
                maxBlocks = blockToml.getOrderedKeys().size();
            }
            if (itemToml != null) {
                maxItems = itemToml.getOrderedKeys().size();
            }
            int newNextBlockId = 1200 + maxBlocks;
            int newNextItemId = 17100 + maxItems;
            SignalIndustries.LOGGER.info("Using {} block IDs and {} item IDs.", (Object)maxBlocks, (Object)maxItems);
            SignalIndustries.LOGGER.info("Next block ID will be {}, next item ID will be {}.", (Object)newNextBlockId, (Object)newNextItemId);
            boolean changed = false;
            for (Field F2 : blockFields) {
                if (rawConfig.contains("BlockIDs." + F2.getName())) continue;
                rawConfig.addEntry("BlockIDs." + F2.getName(), (Object)newNextBlockId++);
                changed = true;
            }
            for (Field F2 : itemFields) {
                if (rawConfig.contains("ItemIDs." + F2.getName())) continue;
                rawConfig.addEntry("ItemIDs." + F2.getName(), (Object)newNextItemId++);
                changed = true;
            }
            if (!rawConfig.contains("WorldGen")) {
                rawConfig.addCategory("These options modify the world generation, the values for chances here are interpreted by the game as 1 in x. A config having the value of 10 would mean 1 in 10.", "WorldGen");
                changed = true;
            }
            if (!rawConfig.contains("WorldGen.signaliteGeodeChance")) {
                rawConfig.addEntry("WorldGen.signaliteGeodeChance", "Default is 10", (Object)10);
                changed = true;
            }
            if (!rawConfig.contains("WorldGen.ironMeteorChance")) {
                rawConfig.addEntry("WorldGen.ironMeteorChance", "Default is 256", (Object)256);
                changed = true;
            }
            if (!rawConfig.contains("WorldGen.signaliteMeteorChance")) {
                rawConfig.addEntry("WorldGen.signaliteMeteorChance", "Default is 512", (Object)512);
                changed = true;
            }
            if (!rawConfig.contains("WorldGen.dilithiumMeteorChance")) {
                rawConfig.addEntry("WorldGen.dilithiumMeteorChance", "Default is 1024", (Object)1024);
                changed = true;
            }
            if (!rawConfig.contains("WorldGen.obeliskChance")) {
                rawConfig.addEntry("WorldGen.obeliskChance", "Default is 2048", (Object)2048);
                changed = true;
            }
            if (!rawConfig.contains("EntityIDs.infernalId")) {
                rawConfig.addEntry("EntityIDs.infernalId", (Object)100);
                changed = true;
            }
            if (!rawConfig.contains("EntityIDs.volatileCrystalId")) {
                rawConfig.addEntry("EntityIDs.volatileCrystalId", (Object)50);
                changed = true;
            }
            if (!rawConfig.contains("EntityIDs.energyOrbId")) {
                rawConfig.addEntry("EntityIDs.energyOrbId", (Object)51);
                changed = true;
            }
            if (!rawConfig.contains("EntityIDs.fallingMeteorId")) {
                rawConfig.addEntry("EntityIDs.fallingMeteorId", (Object)52);
                changed = true;
            }
            if (!rawConfig.contains("EntityIDs.sunbeamId")) {
                rawConfig.addEntry("EntityIDs.sunbeamId", (Object)53);
                changed = true;
            }
            try {
                if (!rawConfig.contains("Experimental.enableDynamicChunkProvider")) {
                    rawConfig.addEntry("Experimental.enableDynamicChunkProvider", (Object)false);
                    changed = true;
                }
            }
            catch (NullPointerException e) {
                rawConfig.addEntry("Experimental.enableDynamicChunkProvider", (Object)false);
                changed = true;
            }
            try {
                if (!rawConfig.contains("Other.enableQuests")) {
                    rawConfig.addEntry("Other.enableQuests", (Object)true);
                    changed = true;
                }
            }
            catch (NullPointerException e) {
                rawConfig.addEntry("Other.enableQuests", (Object)true);
                changed = true;
            }
            try {
                if (!rawConfig.contains("Other.totemsRequireOP")) {
                    rawConfig.addEntry("Other.totemsRequireOP", (Object)false);
                    changed = true;
                }
            }
            catch (NullPointerException e) {
                rawConfig.addEntry("Other.totemsRequireOP", (Object)false);
                changed = true;
            }
            if (!rawConfig.contains("Other.eternityDimId")) {
                rawConfig.addEntry("Other.eternityDimId", (Object)3);
                changed = true;
            }
            if (!rawConfig.contains("Other.GuiId")) {
                rawConfig.addEntry("Other.GuiId", (Object)10);
                changed = true;
            }
            if (!rawConfig.contains("Other.machinePacketId")) {
                rawConfig.addEntry("Other.machinePacketId", (Object)113);
                changed = true;
            }
            if (!rawConfig.contains("Other.dilithiumMiningLevel")) {
                rawConfig.addEntry("Other.dilithiumMiningLevel", (Object)4);
                changed = true;
            }
            if (!rawConfig.contains("Other.awakenedMiningLevel")) {
                rawConfig.addEntry("Other.awakenedMiningLevel", (Object)5);
                changed = true;
            }
            if (changed) {
                config.setDefaults(rawConfig);
                config.writeConfig();
                config.loadConfig();
            }
        } else {
            config.setDefaults(defaultConfig);
            try {
                configFile.getParentFile().mkdirs();
                configFile.createNewFile();
                config.writeConfig();
                config.loadConfig();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to generate config!", e);
            }
        }
    }
}

