/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.DataLoader;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeGroup;
import net.minecraft.core.data.registry.recipe.RecipeNamespace;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCrafting;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryFurnace;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.recipes.RecipeGroupSI;
import sunsetsatellite.signalindustries.recipes.RecipeNamespaceSI;
import sunsetsatellite.signalindustries.recipes.container.AlloySmelterRecipes;
import sunsetsatellite.signalindustries.recipes.container.CentrifugeRecipes;
import sunsetsatellite.signalindustries.recipes.container.CollectorRecipes;
import sunsetsatellite.signalindustries.recipes.container.CrusherRecipes;
import sunsetsatellite.signalindustries.recipes.container.CrystalChamberRecipes;
import sunsetsatellite.signalindustries.recipes.container.CrystalCutterRecipes;
import sunsetsatellite.signalindustries.recipes.container.ExtractorRecipes;
import sunsetsatellite.signalindustries.recipes.container.GreenhouseRecipes;
import sunsetsatellite.signalindustries.recipes.container.InductionSmelterRecipes;
import sunsetsatellite.signalindustries.recipes.container.InfuserRecipes;
import sunsetsatellite.signalindustries.recipes.container.LaserDrillRecipes;
import sunsetsatellite.signalindustries.recipes.container.PlateFormerRecipes;
import sunsetsatellite.signalindustries.recipes.container.PumpRecipes;
import sunsetsatellite.signalindustries.recipes.container.StoneworksRecipes;
import sunsetsatellite.signalindustries.recipes.container.waking.WakingAlloySmelterRecipes;
import sunsetsatellite.signalindustries.recipes.container.waking.WakingCrusherRecipes;
import sunsetsatellite.signalindustries.recipes.container.waking.WakingInfuserRecipes;
import sunsetsatellite.signalindustries.recipes.container.waking.WakingPlateFormerRecipes;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachine;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachineFluid;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachineMultiOutput;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntryMachineRandomOutput;
import turniplabs.halplibe.helper.RecipeBuilder;
import turniplabs.halplibe.util.RecipeEntrypoint;

public class SIRecipes
implements RecipeEntrypoint {
    public static RecipeNamespaceSI SIGNAL_INDUSTRIES = new RecipeNamespaceSI();
    public static RecipeGroup<RecipeEntryCrafting<?, ?>> WORKBENCH;
    public static RecipeGroup<RecipeEntryFurnace> FURNACE;
    public static RecipeGroupSI<RecipeEntryMachineFluid> EXTRACTOR;
    public static RecipeGroupSI<RecipeEntryMachine> CRUSHER;
    public static RecipeGroupSI<RecipeEntryMachine> WAKING_CRUSHER;
    public static RecipeGroupSI<RecipeEntryMachine> ALLOY_SMELTER;
    public static RecipeGroupSI<RecipeEntryMachine> WAKING_ALLOY_SMELTER;
    public static RecipeGroupSI<RecipeEntryMachine> PLATE_FORMER;
    public static RecipeGroupSI<RecipeEntryMachine> WAKING_PLATE_FORMER;
    public static RecipeGroupSI<RecipeEntryMachineFluid> PUMP;
    public static RecipeGroupSI<RecipeEntryMachine> STONEWORKS;
    public static RecipeGroupSI<RecipeEntryMachine> CRYSTAL_CUTTER;
    public static RecipeGroupSI<RecipeEntryMachine> CRYSTAL_CHAMBER;
    public static RecipeGroupSI<RecipeEntryMachine> INFUSER;
    public static RecipeGroupSI<RecipeEntryMachine> WAKING_INFUSER;
    public static RecipeGroupSI<RecipeEntryMachine> CENTRIFUGE;
    public static RecipeGroupSI<RecipeEntryMachineFluid> COLLECTOR;
    public static RecipeGroupSI<RecipeEntryMachine> INDUCTION_SMELTER;
    public static RecipeGroupSI<RecipeEntryMachineRandomOutput> LASER_DRILL;
    public static RecipeGroupSI<RecipeEntryMachineMultiOutput> GREENHOUSE;

    public void onRecipesReady() {
        SignalIndustries.LOGGER.info("Loading SI recipes...");
        this.load();
    }

    public void initNamespaces() {
        SignalIndustries.LOGGER.info("Loading SI recipe namespaces...");
        this.resetGroups();
        this.registerNamespaces();
    }

    public void registerNamespaces() {
        SIGNAL_INDUSTRIES.register("workbench", WORKBENCH);
        SIGNAL_INDUSTRIES.register("furnace", FURNACE);
        SIGNAL_INDUSTRIES.register("extractor", EXTRACTOR);
        SIGNAL_INDUSTRIES.register("crusher", CRUSHER);
        SIGNAL_INDUSTRIES.register("alloy_smelter", ALLOY_SMELTER);
        SIGNAL_INDUSTRIES.register("plate_former", PLATE_FORMER);
        SIGNAL_INDUSTRIES.register("pump", PUMP);
        SIGNAL_INDUSTRIES.register("stoneworks", STONEWORKS);
        SIGNAL_INDUSTRIES.register("crystal_cutter", CRYSTAL_CUTTER);
        SIGNAL_INDUSTRIES.register("crystal_chamber", CRYSTAL_CHAMBER);
        SIGNAL_INDUSTRIES.register("infuser", INFUSER);
        SIGNAL_INDUSTRIES.register("centrifuge", CENTRIFUGE);
        SIGNAL_INDUSTRIES.register("collector", COLLECTOR);
        SIGNAL_INDUSTRIES.register("waking_crusher", WAKING_CRUSHER);
        SIGNAL_INDUSTRIES.register("waking_plate_former", WAKING_PLATE_FORMER);
        SIGNAL_INDUSTRIES.register("waking_alloy_smelter", WAKING_ALLOY_SMELTER);
        SIGNAL_INDUSTRIES.register("waking_infuser", WAKING_INFUSER);
        SIGNAL_INDUSTRIES.register("induction_smelter", INDUCTION_SMELTER);
        SIGNAL_INDUSTRIES.register("laser_drill", LASER_DRILL);
        SIGNAL_INDUSTRIES.register("greenhouse", GREENHOUSE);
        Registries.RECIPES.register("signalindustries", (RecipeNamespace)SIGNAL_INDUSTRIES);
    }

    public void resetGroups() {
        Registries.RECIPES.unregister("signalindustries");
        SIGNAL_INDUSTRIES = new RecipeNamespaceSI();
        WORKBENCH = new RecipeGroup(new RecipeSymbol(new ItemStack(Blocks.WORKBENCH)));
        FURNACE = new RecipeGroup(new RecipeSymbol(new ItemStack(Blocks.FURNACE_STONE_IDLE)));
        EXTRACTOR = new RecipeGroupSI(new RecipeSymbol(Arrays.asList(new ItemStack(SIBlocks.prototypeExtractor), new ItemStack(SIBlocks.basicExtractor), new ItemStack(SIBlocks.reinforcedExtractor))));
        CRUSHER = new RecipeGroupSI(new RecipeSymbol(Arrays.asList(new ItemStack(SIBlocks.prototypeCrusher), new ItemStack(SIBlocks.basicCrusher), new ItemStack(SIBlocks.reinforcedCrusher))));
        ALLOY_SMELTER = new RecipeGroupSI(new RecipeSymbol(Arrays.asList(new ItemStack(SIBlocks.prototypeAlloySmelter), new ItemStack(SIBlocks.basicAlloySmelter), new ItemStack(SIBlocks.reinforcedAlloySmelter))));
        PLATE_FORMER = new RecipeGroupSI(new RecipeSymbol(Arrays.asList(new ItemStack(SIBlocks.prototypePlateFormer), new ItemStack(SIBlocks.basicPlateFormer), new ItemStack(SIBlocks.reinforcedPlateFormer))));
        PUMP = new RecipeGroupSI(new RecipeSymbol(Arrays.asList(new ItemStack(SIBlocks.prototypePump), new ItemStack(SIBlocks.basicPump), new ItemStack(SIBlocks.reinforcedPump))));
        STONEWORKS = new RecipeGroupSI(new RecipeSymbol(Collections.singletonList(new ItemStack(SIBlocks.basicStoneworks))));
        CRYSTAL_CUTTER = new RecipeGroupSI(new RecipeSymbol(Arrays.asList(new ItemStack(SIBlocks.prototypeCrystalCutter), new ItemStack(SIBlocks.basicCrystalCutter), new ItemStack(SIBlocks.reinforcedCrystalCutter))));
        CRYSTAL_CHAMBER = new RecipeGroupSI(new RecipeSymbol(Arrays.asList(new ItemStack(SIBlocks.basicCrystalChamber), new ItemStack(SIBlocks.reinforcedCrystalChamber))));
        INFUSER = new RecipeGroupSI(new RecipeSymbol(Arrays.asList(new ItemStack(SIBlocks.basicInfuser), new ItemStack(SIBlocks.reinforcedInfuser))));
        CENTRIFUGE = new RecipeGroupSI(new RecipeSymbol(Collections.singletonList(new ItemStack(SIBlocks.reinforcedCentrifuge))));
        COLLECTOR = new RecipeGroupSI(new RecipeSymbol(Arrays.asList(new ItemStack(SIBlocks.basicCollector), new ItemStack(SIBlocks.reinforcedCollector))));
        WAKING_CRUSHER = new RecipeGroupSI(new RecipeSymbol(Collections.singletonList(new ItemStack(SIBlocks.wakingCrusher))));
        WAKING_PLATE_FORMER = new RecipeGroupSI(new RecipeSymbol(Collections.singletonList(new ItemStack(SIBlocks.wakingPlateFormer))));
        WAKING_ALLOY_SMELTER = new RecipeGroupSI(new RecipeSymbol(Collections.singletonList(new ItemStack(SIBlocks.wakingAlloySmelter))));
        WAKING_INFUSER = new RecipeGroupSI(new RecipeSymbol(Collections.singletonList(new ItemStack(SIBlocks.wakingInfuser))));
        INDUCTION_SMELTER = new RecipeGroupSI(new RecipeSymbol(Collections.singletonList(new ItemStack(SIBlocks.basicInductionSmelter))));
        LASER_DRILL = new RecipeGroupSI(new RecipeSymbol(Collections.singletonList(new ItemStack(SIBlocks.reinforcedLaserDrill))));
        GREENHOUSE = new RecipeGroupSI(new RecipeSymbol(Collections.singletonList(new ItemStack(SIBlocks.basicGreenhouse))));
    }

    public static void loadSpecial() {
        new InductionSmelterRecipes().addRecipes(INDUCTION_SMELTER);
    }

    public void load() {
        Registries.RECIPE_TYPES.register("signalindustries:machine", RecipeEntryMachine.class);
        Registries.RECIPE_TYPES.register("signalindustries:machine/fluid", RecipeEntryMachineFluid.class);
        Registries.RECIPE_TYPES.register("signalindustries:machine/random", RecipeEntryMachineRandomOutput.class);
        Registries.RECIPE_TYPES.register("signalindustries:machine/multi", RecipeEntryMachineMultiOutput.class);
        ArrayList<ItemStack> romChipGroup = new ArrayList<ItemStack>();
        romChipGroup.add(SIItems.romChipBoost.getDefaultStack());
        romChipGroup.add(SIItems.romChipProjectile.getDefaultStack());
        romChipGroup.add(SIItems.romChipShield.getDefaultStack());
        romChipGroup.add(SIItems.romChipScan.getDefaultStack());
        RecipeBuilder.addItemsToGroup((String)"signalindustries", (String)"rom_chips", (Object[])romChipGroup.toArray());
        RecipeBuilder.addItemsToGroup((String)"common_plates", (String)"cobblestone", (Object[])new Object[]{SIItems.cobblestonePlate});
        RecipeBuilder.addItemsToGroup((String)"common_plates", (String)"stone", (Object[])new Object[]{SIItems.stonePlate});
        RecipeBuilder.addItemsToGroup((String)"common_plates", (String)"steel", (Object[])new Object[]{SIItems.steelPlate});
        RecipeBuilder.addItemsToGroup((String)"common_dusts", (String)"coal", (Object[])new Object[]{SIItems.coalDust});
        RecipeBuilder.addItemsToGroup((String)"common_dusts", (String)"iron", (Object[])new Object[]{SIItems.ironDust});
        RecipeBuilder.addItemsToGroup((String)"common_dusts", (String)"gold", (Object[])new Object[]{SIItems.goldDust});
        RecipeBuilder.addItemsToGroup((String)"common_dusts", (String)"nether_coal", (Object[])new Object[]{SIItems.netherCoalDust});
        RecipeBuilder.addItemsToGroup((String)"common_tiny_dusts", (String)"nether_coal", (Object[])new Object[]{SIItems.tinyNetherCoalDust});
        Registries.ITEM_GROUPS.register("minecraft:water", (Object)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(Blocks.FLUID_WATER_FLOWING), new ItemStack(Blocks.FLUID_WATER_FLOWING)}));
        Registries.ITEM_GROUPS.register("minecraft:lava", (Object)Catalyst.listOf((Object[])new ItemStack[]{new ItemStack(Blocks.FLUID_LAVA_STILL), new ItemStack(Blocks.FLUID_LAVA_FLOWING)}));
        new ExtractorRecipes().addRecipes(EXTRACTOR);
        new CrusherRecipes().addRecipes(CRUSHER);
        new AlloySmelterRecipes().addRecipes(ALLOY_SMELTER);
        new PlateFormerRecipes().addRecipes(PLATE_FORMER);
        new PumpRecipes().addRecipes(PUMP);
        new StoneworksRecipes().addRecipes(STONEWORKS);
        new CrystalCutterRecipes().addRecipes(CRYSTAL_CUTTER);
        new CrystalChamberRecipes().addRecipes(CRYSTAL_CHAMBER);
        new InfuserRecipes().addRecipes(INFUSER);
        new CentrifugeRecipes().addRecipes(CENTRIFUGE);
        new CollectorRecipes().addRecipes(COLLECTOR);
        new WakingCrusherRecipes().addRecipes(WAKING_CRUSHER);
        new WakingPlateFormerRecipes().addRecipes(WAKING_PLATE_FORMER);
        new WakingAlloySmelterRecipes().addRecipes(WAKING_ALLOY_SMELTER);
        new WakingInfuserRecipes().addRecipes(WAKING_INFUSER);
        new LaserDrillRecipes().addRecipes(LASER_DRILL);
        new GreenhouseRecipes().addRecipes(GREENHOUSE);
        DataLoader.loadRecipesFromFile((String)"/assets/signalindustries/recipes/workbench.json");
        DataLoader.loadRecipesFromFile((String)"/assets/signalindustries/recipes/workbench_prototype.json");
        DataLoader.loadRecipesFromFile((String)"/assets/signalindustries/recipes/workbench_basic.json");
        DataLoader.loadRecipesFromFile((String)"/assets/signalindustries/recipes/workbench_reinforced.json");
        DataLoader.loadRecipesFromFile((String)"/assets/signalindustries/recipes/workbench_awakened.json");
        DataLoader.loadRecipesFromFile((String)"/assets/signalindustries/recipes/furnace.json");
        SignalIndustries.LOGGER.info("{} recipes in {} groups.", (Object)SIGNAL_INDUSTRIES.getAllRecipes().size(), (Object)SIGNAL_INDUSTRIES.size());
    }

    public static <T extends RecipeEntryBase<?, ?, ?>> List<T> getAllRecipesOfType(Class<T> clazz) {
        ArrayList<RecipeEntryBase> recipes = new ArrayList<RecipeEntryBase>();
        for (RecipeEntryBase recipe : Registries.RECIPES.getAllRecipes()) {
            if (!clazz.isAssignableFrom(recipe.getClass())) continue;
            recipes.add((RecipeEntryBase)clazz.cast(recipe));
        }
        return Collections.unmodifiableList(recipes);
    }
}

