/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.net.entity.IVehicleEntry;
import net.minecraft.core.net.entity.NetEntityHandler;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.SIArt;
import sunsetsatellite.signalindustries.SIConfig;
import sunsetsatellite.signalindustries.SIFluids;
import sunsetsatellite.signalindustries.SIRecipes;
import sunsetsatellite.signalindustries.entities.EntityRealityTear;
import sunsetsatellite.signalindustries.entities.EntityShockwave;
import sunsetsatellite.signalindustries.entities.MobInfernal;
import sunsetsatellite.signalindustries.entities.ProjectileCrystal;
import sunsetsatellite.signalindustries.entities.ProjectileEnergyOrb;
import sunsetsatellite.signalindustries.entities.ProjectileFallingMeteor;
import sunsetsatellite.signalindustries.entities.ProjectileSunbeam;
import sunsetsatellite.signalindustries.mp.entity.entry.NetEntryEnergyOrb;
import sunsetsatellite.signalindustries.mp.entity.entry.NetEntryFallingMeteor;
import sunsetsatellite.signalindustries.mp.entity.entry.NetEntrySunbeam;
import sunsetsatellite.signalindustries.mp.entity.entry.NetEntryVolatileCrystal;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageAutoMinerStart;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageBuilderConfig;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageDrillModeChange;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageExternalIOLinkBreak;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageFilterConfig;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageIOChange;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageMeteorLocationSync;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageOpenSuit;
import sunsetsatellite.signalindustries.mp.message.NetworkMessagePowerSuitAction;
import sunsetsatellite.signalindustries.mp.message.NetworkMessagePowerSuitRemoteSync;
import sunsetsatellite.signalindustries.mp.message.NetworkMessagePowerSuitSync;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageReactorStart;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageRecipeIdChange;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageRedstoneCoverSetFilter;
import sunsetsatellite.signalindustries.mp.message.NetworkMessageSensorPipeSetFilter;
import sunsetsatellite.signalindustries.tiles.TileEntityCatalystConduit;
import sunsetsatellite.signalindustries.tiles.TileEntityChunkloader;
import sunsetsatellite.signalindustries.tiles.TileEntityConduit;
import sunsetsatellite.signalindustries.tiles.TileEntityEnergyConnector;
import sunsetsatellite.signalindustries.tiles.TileEntityExternalIO;
import sunsetsatellite.signalindustries.tiles.TileEntityFilter;
import sunsetsatellite.signalindustries.tiles.TileEntityFluidConduit;
import sunsetsatellite.signalindustries.tiles.TileEntityFluidHatch;
import sunsetsatellite.signalindustries.tiles.TileEntityIgnitor;
import sunsetsatellite.signalindustries.tiles.TileEntityInserter;
import sunsetsatellite.signalindustries.tiles.TileEntityItemBus;
import sunsetsatellite.signalindustries.tiles.TileEntityItemConduit;
import sunsetsatellite.signalindustries.tiles.TileEntityMultiConduit;
import sunsetsatellite.signalindustries.tiles.TileEntitySignalumDynamo;
import sunsetsatellite.signalindustries.tiles.TileEntityStorageContainer;
import sunsetsatellite.signalindustries.tiles.TileEntityUVLamp;
import sunsetsatellite.signalindustries.tiles.TileEntityVoidContainer;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityAlloySmelter;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityAssembler;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityAutoMiner;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityBonsaiPot;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityBooster;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityBuilder;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityCentrifuge;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityCollector;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityCrusher;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityCrystalChamber;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityCrystalCutter;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityEnergyCell;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityEnergyInjector;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityExtractor;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityInfuser;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityPlateFormer;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityProgrammer;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityPulsar;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityPump;
import sunsetsatellite.signalindustries.tiles.machines.TileEntitySIFluidTank;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityStabilizer;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityStoneworks;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityWrathBeacon;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.TileEntityDimensionalAnchor;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.TileEntityGreenhouse;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.TileEntityInductionSmelter;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.TileEntityLaserDrill;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.TileEntityReinforcedExtractor;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.TileEntitySignalumReactor;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.TileEntityWarpGate;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.waking.TileEntityWakingAlloySmelter;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.waking.TileEntityWakingCrusher;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.waking.TileEntityWakingInfuser;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.waking.TileEntityWakingPlateFormer;
import sunsetsatellite.signalindustries.util.MeteorLocation;
import turniplabs.halplibe.helper.ArmorHelper;
import turniplabs.halplibe.helper.EntityHelper;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.util.GameStartEntrypoint;

public class SignalIndustries
implements ModInitializer,
GameStartEntrypoint {
    public static final String MOD_ID = "signalindustries";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"signalindustries");
    public static List<MeteorLocation> meteorLocations = new ArrayList<MeteorLocation>();
    public static List<ChunkCoordinates> chunkLoaders = new ArrayList<ChunkCoordinates>();
    public static Set<BlockInstance> uvLamps = new HashSet<BlockInstance>();
    public static boolean bloodMoonsDisabled = false;
    public static final ArmorMaterial armorPrototypeHarness = ArmorHelper.createArmorMaterial((String)"signalindustries", (String)"harness", (int)1200, (float)10.0f, (float)10.0f, (float)10.0f, (float)10.0f);
    public static final ArmorMaterial armorSignalumPowerSuit = ArmorHelper.createArmorMaterial((String)"signalindustries", (String)"power_suit", (int)9999, (float)50.0f, (float)50.0f, (float)50.0f, (float)50.0f);
    public static final ToolMaterial toolMaterialBasic = new ToolMaterial().setDurability(9999).setMiningLevel(3).setEfficiency(25.0f, 50.0f);
    public static final ToolMaterial toolMaterialReinforced = new ToolMaterial().setDurability(9999).setMiningLevel(SIConfig.config.getInt("Other.dilithiumMiningLevel")).setEfficiency(45.0f, 80.0f);
    public static final ToolMaterial toolMaterialAwakened = new ToolMaterial().setDurability(9999).setMiningLevel(SIConfig.config.getInt("Other.awakenedMiningLevel")).setEfficiency(60.0f, 100.0f);
    public static final Tag<Block<?>> SIGNALUM_CONDUITS_CONNECT = Tag.of((String)"signalum_conduits_connect");
    public static final Tag<Block<?>> FLUID_CONDUITS_CONNECT = Tag.of((String)"fluid_conduits_connect");
    public static final Tag<Block<?>> ITEM_CONDUITS_CONNECT = Tag.of((String)"item_conduits_connect");
    public static final Tag<Block<?>> CASING = Tag.of((String)"casing");
    public static final Tag<Block<?>> REPLACEABLE_CASING = Tag.of((String)"replaceable_casing");
    public static final Tag<Block<?>> PROTOTYPE_CASING = Tag.of((String)"prototype_casing");
    public static final Tag<Block<?>> BASIC_CASING = Tag.of((String)"basic_casing");
    public static final Tag<Block<?>> REINFORCED_CASING = Tag.of((String)"reinforced_casing");
    public static final Tag<Block<?>> AWAKENED_CASING = Tag.of((String)"awakened_casing");
    public static final Tag<Block<?>> ORE_BLOCK = Tag.of((String)"ore_block");
    public static final Map<Block<?>, Integer> ORE_BLOCK_COUNT = new HashMap();

    public void onInitialize() {
        LOGGER.info("Loading SI config...");
        new SIConfig();
        new SIArt().init();
        EntityHelper.createTileEntity(TileEntityExtractor.class, (NamespaceID)SignalIndustries.id("extractor"));
        EntityHelper.createTileEntity(TileEntityCollector.class, (NamespaceID)SignalIndustries.id("collector"));
        EntityHelper.createTileEntity(TileEntitySIFluidTank.class, (NamespaceID)SignalIndustries.id("fluid_tank"));
        EntityHelper.createTileEntity(TileEntityEnergyCell.class, (NamespaceID)SignalIndustries.id("energy_cell"));
        EntityHelper.createTileEntity(TileEntityCrusher.class, (NamespaceID)SignalIndustries.id("crusher"));
        EntityHelper.createTileEntity(TileEntityAlloySmelter.class, (NamespaceID)SignalIndustries.id("alloy_smelter"));
        EntityHelper.createTileEntity(TileEntityPlateFormer.class, (NamespaceID)SignalIndustries.id("plate_former"));
        EntityHelper.createTileEntity(TileEntityCrystalChamber.class, (NamespaceID)SignalIndustries.id("crystal_chamber"));
        EntityHelper.createTileEntity(TileEntityCrystalCutter.class, (NamespaceID)SignalIndustries.id("crystal_cutter"));
        EntityHelper.createTileEntity(TileEntityInfuser.class, (NamespaceID)SignalIndustries.id("infuser"));
        EntityHelper.createTileEntity(TileEntityStoneworks.class, (NamespaceID)SignalIndustries.id("stoneworks"));
        EntityHelper.createTileEntity(TileEntityPump.class, (NamespaceID)SignalIndustries.id("pump"));
        EntityHelper.createTileEntity(TileEntityAssembler.class, (NamespaceID)SignalIndustries.id("assembler"));
        EntityHelper.createTileEntity(TileEntityAutoMiner.class, (NamespaceID)SignalIndustries.id("auto_miner"));
        EntityHelper.createTileEntity(TileEntitySignalumDynamo.class, (NamespaceID)SignalIndustries.id("dynamo"));
        EntityHelper.createTileEntity(TileEntityEnergyInjector.class, (NamespaceID)SignalIndustries.id("injector"));
        EntityHelper.createTileEntity(TileEntityBooster.class, (NamespaceID)SignalIndustries.id("booster"));
        EntityHelper.createTileEntity(TileEntityStabilizer.class, (NamespaceID)SignalIndustries.id("stabilizer"));
        EntityHelper.createTileEntity(TileEntityExternalIO.class, (NamespaceID)SignalIndustries.id("external_io"));
        EntityHelper.createTileEntity(TileEntityEnergyConnector.class, (NamespaceID)SignalIndustries.id("energy_connector"));
        EntityHelper.createTileEntity(TileEntityItemBus.class, (NamespaceID)SignalIndustries.id("item_bus"));
        EntityHelper.createTileEntity(TileEntityFluidHatch.class, (NamespaceID)SignalIndustries.id("fluid_hatch"));
        EntityHelper.createTileEntity(TileEntityInductionSmelter.class, (NamespaceID)SignalIndustries.id("induction_smelter"));
        EntityHelper.createTileEntity(TileEntityWakingAlloySmelter.class, (NamespaceID)SignalIndustries.id("waking_alloy_smelter"));
        EntityHelper.createTileEntity(TileEntityWakingCrusher.class, (NamespaceID)SignalIndustries.id("waking_crusher"));
        EntityHelper.createTileEntity(TileEntityWakingPlateFormer.class, (NamespaceID)SignalIndustries.id("waking_plate_former"));
        EntityHelper.createTileEntity(TileEntityWakingInfuser.class, (NamespaceID)SignalIndustries.id("waking_infuser"));
        EntityHelper.createTileEntity(TileEntityCentrifuge.class, (NamespaceID)SignalIndustries.id("centrifuge"));
        EntityHelper.createTileEntity(TileEntityDimensionalAnchor.class, (NamespaceID)SignalIndustries.id("dimensional_anchor"));
        EntityHelper.createTileEntity(TileEntityReinforcedExtractor.class, (NamespaceID)SignalIndustries.id("reinforced_extractor"));
        EntityHelper.createTileEntity(TileEntitySignalumReactor.class, (NamespaceID)SignalIndustries.id("reactor"));
        EntityHelper.createTileEntity(TileEntityIgnitor.class, (NamespaceID)SignalIndustries.id("ignitor"));
        EntityHelper.createTileEntity(TileEntityFluidConduit.class, (NamespaceID)SignalIndustries.id("fluid_conduit"));
        EntityHelper.createTileEntity(TileEntityConduit.class, (NamespaceID)SignalIndustries.id("conduit"));
        EntityHelper.createTileEntity(TileEntityCatalystConduit.class, (NamespaceID)SignalIndustries.id("catalyst_conduit"));
        EntityHelper.createTileEntity(TileEntityItemConduit.class, (NamespaceID)SignalIndustries.id("item_conduit"));
        EntityHelper.createTileEntity(TileEntityFilter.class, (NamespaceID)SignalIndustries.id("filter"));
        EntityHelper.createTileEntity(TileEntityInserter.class, (NamespaceID)SignalIndustries.id("inserter"));
        EntityHelper.createTileEntity(TileEntityStorageContainer.class, (NamespaceID)SignalIndustries.id("storage_container"));
        EntityHelper.createTileEntity(TileEntityVoidContainer.class, (NamespaceID)SignalIndustries.id("void_container"));
        EntityHelper.createTileEntity(TileEntityBuilder.class, (NamespaceID)SignalIndustries.id("builder"));
        EntityHelper.createTileEntity(TileEntityChunkloader.class, (NamespaceID)SignalIndustries.id("chunkloader"));
        EntityHelper.createTileEntity(TileEntityWarpGate.class, (NamespaceID)SignalIndustries.id("warp_gate"));
        EntityHelper.createTileEntity(TileEntityMultiConduit.class, (NamespaceID)SignalIndustries.id("multi_conduit"));
        EntityHelper.createTileEntity(TileEntityProgrammer.class, (NamespaceID)SignalIndustries.id("programmer"));
        EntityHelper.createTileEntity(TileEntityWrathBeacon.class, (NamespaceID)SignalIndustries.id("wrath_beacon"));
        EntityHelper.createTileEntity(TileEntityUVLamp.class, (NamespaceID)SignalIndustries.id("uv_lamp"));
        EntityHelper.createTileEntity(TileEntityPulsar.class, (NamespaceID)SignalIndustries.id("pulsar"));
        EntityHelper.createTileEntity(TileEntityBonsaiPot.class, (NamespaceID)SignalIndustries.id("bonsai"));
        EntityHelper.createTileEntity(TileEntityLaserDrill.class, (NamespaceID)SignalIndustries.id("laser_drill"));
        EntityHelper.createTileEntity(TileEntityGreenhouse.class, (NamespaceID)SignalIndustries.id("greenhouse"));
        EntityHelper.createEntity(ProjectileCrystal.class, (NamespaceID)SignalIndustries.id("volatile_crystal"), (String)"entity.signalindustries.volatileCrystal");
        EntityHelper.createEntity(ProjectileFallingMeteor.class, (NamespaceID)SignalIndustries.id("falling_meteor"), (String)"entity.signalindustries.fallingMeteor");
        EntityHelper.createEntity(ProjectileEnergyOrb.class, (NamespaceID)SignalIndustries.id("energy_orb"), (String)"entity.signalindustries.energyOrb");
        EntityHelper.createEntity(ProjectileSunbeam.class, (NamespaceID)SignalIndustries.id("sunbeam"), (String)"entity.signalindustries.sunbeam");
        EntityHelper.createEntity(MobInfernal.class, (NamespaceID)SignalIndustries.id("infernal"), (String)"entity.signalindustries.infernal");
        EntityHelper.createEntity(EntityRealityTear.class, (NamespaceID)SignalIndustries.id("reality_tear"), (String)"entity.signalindustries.realityTear");
        EntityHelper.createEntity(EntityShockwave.class, (NamespaceID)SignalIndustries.id("shockwave"), (String)"entity.signalindustries.shockwave");
        NetEntityHandler.registerNetworkEntry((IVehicleEntry)new NetEntryVolatileCrystal(), (int)SIConfig.config.getInt("EntityIDs.volatileCrystalId"));
        NetEntityHandler.registerNetworkEntry((IVehicleEntry)new NetEntryFallingMeteor(), (int)SIConfig.config.getInt("EntityIDs.fallingMeteorId"));
        NetEntityHandler.registerNetworkEntry((IVehicleEntry)new NetEntryEnergyOrb(), (int)SIConfig.config.getInt("EntityIDs.energyOrbId"));
        NetEntityHandler.registerNetworkEntry((IVehicleEntry)new NetEntrySunbeam(), (int)SIConfig.config.getInt("EntityIDs.sunbeamId"));
        NetworkHandler.registerNetworkMessage(NetworkMessageRecipeIdChange::new);
        NetworkHandler.registerNetworkMessage(NetworkMessageIOChange::new);
        NetworkHandler.registerNetworkMessage(NetworkMessageBuilderConfig::new);
        NetworkHandler.registerNetworkMessage(NetworkMessageReactorStart::new);
        NetworkHandler.registerNetworkMessage(NetworkMessageDrillModeChange::new);
        NetworkHandler.registerNetworkMessage(NetworkMessageOpenSuit::new);
        NetworkHandler.registerNetworkMessage(NetworkMessagePowerSuitAction::new);
        NetworkHandler.registerNetworkMessage(NetworkMessagePowerSuitSync::new);
        NetworkHandler.registerNetworkMessage(NetworkMessageExternalIOLinkBreak::new);
        NetworkHandler.registerNetworkMessage(NetworkMessageFilterConfig::new);
        NetworkHandler.registerNetworkMessage(NetworkMessageAutoMinerStart::new);
        NetworkHandler.registerNetworkMessage(NetworkMessageMeteorLocationSync::new);
        NetworkHandler.registerNetworkMessage(NetworkMessageSensorPipeSetFilter::new);
        NetworkHandler.registerNetworkMessage(NetworkMessagePowerSuitRemoteSync::new);
        NetworkHandler.registerNetworkMessage(NetworkMessageRedstoneCoverSetFilter::new);
        BlockTags.TAG_LIST.add(SIGNALUM_CONDUITS_CONNECT);
        BlockTags.TAG_LIST.add(FLUID_CONDUITS_CONNECT);
        BlockTags.TAG_LIST.add(ITEM_CONDUITS_CONNECT);
        BlockTags.TAG_LIST.add(CASING);
        BlockTags.TAG_LIST.add(REPLACEABLE_CASING);
        BlockTags.TAG_LIST.add(PROTOTYPE_CASING);
        BlockTags.TAG_LIST.add(BASIC_CASING);
        BlockTags.TAG_LIST.add(REINFORCED_CASING);
        BlockTags.TAG_LIST.add(AWAKENED_CASING);
        BlockTags.TAG_LIST.add(ORE_BLOCK);
        LOGGER.info("Signal Industries is loading... Shine!");
    }

    public void beforeGameStart() {
        LOGGER.info("Beginning core pre-init.");
    }

    public void afterGameStart() {
        LOGGER.info("Beginning core post-init.");
        SIRecipes.loadSpecial();
    }

    public static void addMeteorLocation(MeteorLocation location) {
        meteorLocations.add(location);
        if (EnvironmentHelper.isServerEnvironment()) {
            NetworkHandler.sendToAllPlayers((NetworkMessage)new NetworkMessageMeteorLocationSync(location));
        }
    }

    public static int getEnergyBurnTime(FluidStack stack) {
        if (stack == null) {
            return 0;
        }
        return stack.isFluidEqual(new FluidStack(SIFluids.ENERGY)) ? 200 : 0;
    }

    public static NamespaceID id(String id) {
        return NamespaceID.getPermanent((String)MOD_ID, (String)id);
    }

    public static String key(String key) {
        return "signalindustries:" + key;
    }

    public static String langKey(String key) {
        return "signalindustries." + key;
    }

    public static boolean hasItems(List<RecipeSymbol> symbols, List<ItemStack> available) {
        symbols.removeIf(Objects::isNull);
        List copy = available.stream().map(ItemStack::copy).collect(Collectors.toList());
        int s = 0;
        int sReq = (int)symbols.stream().filter(Objects::nonNull).count();
        block0: for (RecipeSymbol symbol : symbols) {
            for (ItemStack stack : copy) {
                if (!symbol.matches(stack) || stack == null || stack.stackSize <= 0) continue;
                --stack.stackSize;
                ++s;
                continue block0;
            }
        }
        return s == sReq;
    }
}

