/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.api.impl.btwaila.tooltip;

import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import sunsetsatellite.signalindustries.api.impl.btwaila.tooltip.SIBaseTooltip;
import sunsetsatellite.signalindustries.tiles.TileEntityStorageContainer;
import toufoumaster.btwaila.gui.components.AdvancedInfoComponent;
import toufoumaster.btwaila.util.ProgressBarOptions;
import toufoumaster.btwaila.util.TextureOptions;

public class StorageContainerTooltip
extends SIBaseTooltip<TileEntityStorageContainer> {
    public void initTooltip() {
        this.addClass(TileEntityStorageContainer.class);
    }

    public void drawAdvancedTooltip(TileEntityStorageContainer tile, AdvancedInfoComponent c) {
        if (tile.contents != null) {
            int color = 65280;
            float ratio = (float)tile.contents.stackSize / (float)tile.capacity;
            if (ratio >= 0.5f && ratio < 0.8f) {
                color = 0xFFFF00;
            } else if (ratio >= 0.8f) {
                color = 0xFF0000;
            }
            if (tile.locked) {
                c.drawStringWithShadow("Locked", 0, 0xFFFF00);
            }
            c.drawStringWithShadow("Holding: " + tile.contents.stackSize + "x " + tile.contents.getDisplayName(), 0);
            ProgressBarOptions options = new ProgressBarOptions().setForegroundOptions(new TextureOptions(color, TextureRegistry.getTexture((String)"minecraft:block/sand"))).setBackgroundOptions(new TextureOptions(0, TextureRegistry.getTexture((String)"signalindustries:block/reality_fabric"))).setText("Capacity: ");
            c.drawProgressBarTextureWithText(tile.contents.stackSize, tile.capacity, options, 0);
        } else {
            if (tile.locked) {
                c.drawStringWithShadow("Locked", 0, 0xFFFF00);
            }
            c.drawStringWithShadow("Empty", 0);
            ProgressBarOptions options = new ProgressBarOptions().setForegroundOptions(new TextureOptions(65280, TextureRegistry.getTexture((String)"minecraft:block/sand"))).setBackgroundOptions(new TextureOptions(0, TextureRegistry.getTexture((String)"signalindustries:block/reality_fabric"))).setText("Capacity: ");
            c.drawProgressBarTextureWithText(0, tile.capacity, options, 0);
        }
    }
}

