/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.blocks.logic;

import java.util.function.Supplier;
import net.minecraft.client.world.chunk.provider.ChunkProviderDynamic;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.blocks.logic.base.BlockLogicMachine;
import sunsetsatellite.signalindustries.util.Tier;

public class BlockLogicChunkloader
extends BlockLogicMachine {
    public BlockLogicChunkloader(Block<?> block, Material material, Tier tier, Supplier<TileEntity> tileEntitySupplier, String guiId) {
        super(block, material, tier, tileEntitySupplier, guiId);
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (world.getChunkProvider() instanceof ChunkProviderDynamic) {
            Chunk chunk = world.getChunkFromBlockCoords(x, z);
            ((ChunkProviderDynamic)world.getChunkProvider()).removeFromForceLoaded(chunk.xPosition, chunk.zPosition);
            SignalIndustries.chunkLoaders.remove(new ChunkCoordinates(x, y, z));
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        if (world.isClientSide) {
            return true;
        }
        player.sendMessage("The functionality of this block has been temporarily disabled.");
        player.sendMessage("In the meantime, please check out TinyChunkloader by gungun974 instead!");
        player.sendMessage("https://github.com/gungun974/BTA-Tiny-ChunkLoader");
        return true;
    }
}

