/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.blocks.logic;

import com.mojang.nbt.tags.CompoundTag;
import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.World;
import sunsetsatellite.catalyst.fluids.util.Fluid;
import sunsetsatellite.signalindustries.blocks.logic.base.BlockLogicMachine;
import sunsetsatellite.signalindustries.tiles.machines.TileEntitySIFluidTank;
import sunsetsatellite.signalindustries.util.Tier;

public class BlockLogicSIFluidTank
extends BlockLogicMachine {
    public BlockLogicSIFluidTank(Block<?> block, Material material, Tier tier, Supplier<TileEntity> tileEntitySupplier, String guiId) {
        super(block, material, tier, tileEntitySupplier, guiId);
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        TileEntitySIFluidTank tile = (TileEntitySIFluidTank)tileEntity;
        CompoundTag fluidContents = new CompoundTag();
        ItemStack stack = new ItemStack((IItemConvertible)this);
        if (tile != null && tile.getFluidInSlot(0) != null) {
            tile.getFluidInSlot(0).writeToNBT(fluidContents);
            stack.getData().putCompound("Fluid", fluidContents);
        }
        if (dropCause != EnumDropCause.IMPROPER_TOOL) {
            ItemStack[] itemStackArray2 = new ItemStack[1];
            itemStackArray = itemStackArray2;
            itemStackArray2[0] = stack;
        } else {
            itemStackArray = null;
        }
        return itemStackArray;
    }

    @Override
    public String getDescription(ItemStack stack) {
        if (stack.getData().containsKey("Fluid")) {
            NamespaceID fluidId;
            try {
                fluidId = NamespaceID.getTemp((String)stack.getData().getCompound("Fluid").getString("fluid"));
            }
            catch (HardIllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            Fluid fluid = (Fluid)Fluid.fluidMap.get(fluidId);
            int amount = stack.getData().getCompound("Fluid").getInteger("amount");
            int maxAmount = (int)Math.pow(2.0, this.tier.ordinal()) * 16000;
            return super.getDescription(stack) + "\n" + String.format("Contains: %d/%d mB %s", amount, maxAmount, fluid.getName());
        }
        return super.getDescription(stack);
    }
}

