/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.blocks.logic;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tool.ItemTool;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.vector.Vec3f;
import sunsetsatellite.signalindustries.blocks.logic.base.BlockLogicTiered;
import sunsetsatellite.signalindustries.tiles.TileEntityStorageContainer;
import sunsetsatellite.signalindustries.util.Tier;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class BlockLogicStorageContainer
extends BlockLogicTiered {
    public BlockLogicStorageContainer(Block<?> block, Material material, Tier tier) {
        super(block, material, tier);
        block.withEntity(TileEntityStorageContainer::new);
    }

    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        ItemStack stack;
        TileEntityStorageContainer tile;
        super.onBlockLeftClicked(world, x, y, z, player, side, xHit, yHit);
        if (!(EnvironmentHelper.isClientWorld() || (tile = (TileEntityStorageContainer)world.getTileEntity(x, y, z)) == null || player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof ItemTool || (stack = !player.isSneaking() ? tile.extractStack(1) : tile.extractStack()) == null)) {
            Vec3f vec = new Vec3f((double)x, (double)y, (double)z).add(Direction.getDirectionFromSide((int)world.getBlockMetadata(x, y, z)).getVecF()).add(0.5);
            EntityItem entityitem = new EntityItem(world, vec.x, vec.y, vec.z, stack);
            world.entityJoinedWorld((Entity)entityitem);
        }
    }

    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        TileEntityStorageContainer tile;
        super.onBlockRightClicked(world, x, y, z, player, side, xHit, yHit);
        if (!EnvironmentHelper.isClientWorld() && (tile = (TileEntityStorageContainer)world.getTileEntity(x, y, z)) != null) {
            if (player.getCurrentEquippedItem() != null) {
                if (player.isSwinging) {
                    ItemStack stack = player.getCurrentEquippedItem().copy();
                    stack.stackSize = 1;
                    if (tile.insertStack(stack)) {
                        --player.getCurrentEquippedItem().stackSize;
                        if (player.getCurrentEquippedItem().stackSize <= 0) {
                            player.destroyCurrentEquippedItem();
                        } else {
                            player.getCurrentEquippedItem().animationsToGo = 5;
                        }
                    }
                } else {
                    tile.insertStack(player.getCurrentEquippedItem());
                    if (player.getCurrentEquippedItem().stackSize <= 0) {
                        player.destroyCurrentEquippedItem();
                    } else {
                        player.getCurrentEquippedItem().animationsToGo = 5;
                    }
                }
                return true;
            }
            if (tile.infinite && player.gamemode == Gamemode.creative) {
                tile.contents = null;
            } else {
                boolean bl = tile.locked = !tile.locked;
                if (tile.locked) {
                    player.sendTranslatedChatMessage("event.signalindustries.containerLocked");
                } else {
                    player.sendTranslatedChatMessage("event.signalindustries.containerUnlocked");
                }
            }
        }
        return true;
    }
}

