/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.blocks.logic;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.blocks.logic.base.BlockLogicTiered;
import sunsetsatellite.signalindustries.tiles.base.TileEntityWrathBeaconBase;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityWrathBeacon;
import sunsetsatellite.signalindustries.tiles.machines.multiblocks.TileEntityReinforcedWrathBeacon;
import sunsetsatellite.signalindustries.util.Tier;

public class BlockLogicWrathBeacon
extends BlockLogicTiered {
    public static final int MASK_DIRECTION = 7;

    public BlockLogicWrathBeacon(Block<?> block, Material material, Tier tier) {
        super(block, material, tier);
        block.withEntity(tier == Tier.REINFORCED ? TileEntityReinforcedWrathBeacon::new : TileEntityWrathBeacon::new);
    }

    public boolean onBlockRightClicked(World world, int i, int j, int k, Player entityplayer, Side side, double xHit, double yHit) {
        if (world.isClientSide) {
            return true;
        }
        if (this.tier == Tier.BASIC) {
            TileEntityWrathBeaconBase tile = (TileEntityWrathBeaconBase)world.getTileEntity(i, j, k);
            if (tile != null) {
                tile.activate(entityplayer);
            }
        } else {
            TileEntityReinforcedWrathBeacon tile = (TileEntityReinforcedWrathBeacon)world.getTileEntity(i, j, k);
            if (tile != null && tile.multiblock != null && tile.multiblock.isValid()) {
                tile.activate(entityplayer);
            } else {
                entityplayer.sendTranslatedChatMessage("event.signalindustries.invalidMultiblock");
            }
        }
        return true;
    }

    public void onBlockRemoved(World world, int i, int j, int k, int data) {
        TileEntityWrathBeaconBase tile = (TileEntityWrathBeaconBase)world.getTileEntity(i, j, k);
        if (tile != null && tile.active) {
            for (Player player : world.players) {
                if (player.distanceToSqr((double)i, (double)j, (double)k) > 64.0) continue;
                player.sendMessage("Challenge failed!");
            }
            if (this.tier == Tier.REINFORCED) {
                TileEntityReinforcedWrathBeacon w = (TileEntityReinforcedWrathBeacon)tile;
                for (BlockInstance bi : w.multiblock.data.getBlocks(new Vec3i(i, j, k), sunsetsatellite.catalyst.core.util.Direction.Z_POS)) {
                    if (world.getBlockId(bi.pos.x, bi.pos.y, bi.pos.z) != SIBlocks.fueledEternalTreeLog.id()) continue;
                    world.setBlockWithNotify(bi.pos.x, bi.pos.y, bi.pos.z, bi.block.id());
                }
            }
        }
        super.onBlockRemoved(world, i, j, k, data);
    }

    @Override
    public String getDescription(ItemStack stack) {
        if (this.tier == Tier.REINFORCED) {
            String s = super.getDescription(stack);
            return s + "\n" + TextFormatting.YELLOW + "Multiblock" + TextFormatting.WHITE;
        }
        return super.getDescription(stack);
    }

    public static Direction getDirectionFromMeta(int meta) {
        return Direction.getDirectionById((int)(meta & 7));
    }

    public static int setDirection(int meta, Direction direction) {
        return meta & 0xFFFFFFF8 | direction.getId();
    }

    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side side, Mob mob, double xPlaced, double yPlaced) {
        world.setBlockMetadataWithNotify(x, y, z, mob.getHorizontalPlacementDirection(side).getOpposite().getId());
    }

    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        if (!side.isHorizontal()) {
            side = Side.SOUTH;
        }
        world.setBlockMetadataWithNotify(x, y, z, BlockLogicRotatable.setDirection((int)0, (Direction)side.getDirection()));
    }

    public static void setDefaultDirection(World world, int x, int y, int z) {
        if (world.isClientSide) {
            return;
        }
        int bN = world.getBlockId(x, y, z - 1);
        int bS = world.getBlockId(x, y, z + 1);
        int bW = world.getBlockId(x - 1, y, z);
        int bE = world.getBlockId(x + 1, y, z);
        Direction direction = Direction.NORTH;
        if (Blocks.solid[bN] && !Blocks.solid[bS]) {
            direction = Direction.SOUTH;
        }
        if (Blocks.solid[bS] && !Blocks.solid[bN]) {
            direction = Direction.NORTH;
        }
        if (Blocks.solid[bW] && !Blocks.solid[bE]) {
            direction = Direction.EAST;
        }
        if (Blocks.solid[bE] && !Blocks.solid[bW]) {
            direction = Direction.WEST;
        }
        world.setBlockMetadataWithNotify(x, y, z, BlockLogicWrathBeacon.setDirection(world.getBlockMetadata(x, y, z), direction));
    }
}

