/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.blocks.logic.base;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.Pair;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.CatalystMultipart;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.IWrench;
import sunsetsatellite.catalyst.core.util.conduit.ConduitCapability;
import sunsetsatellite.catalyst.core.util.conduit.IConduitBlock;
import sunsetsatellite.catalyst.core.util.section.BlockSection;
import sunsetsatellite.catalyst.core.util.vector.Vec2f;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidPipe;
import sunsetsatellite.catalyst.multipart.api.ISupportsMultiparts;
import sunsetsatellite.catalyst.multipart.api.Multipart;
import sunsetsatellite.signalindustries.blocks.logic.base.BlockLogicNonSolid;
import sunsetsatellite.signalindustries.interfaces.ITiered;
import sunsetsatellite.signalindustries.items.ItemConfigurationTablet;
import sunsetsatellite.signalindustries.tiles.TileEntityItemConduit;
import sunsetsatellite.signalindustries.util.ConfigurationTabletMode;
import sunsetsatellite.signalindustries.util.Tier;

public class BlockLogicConduitBase
extends BlockLogicNonSolid
implements ITiered,
IConduitBlock {
    public Tier tier;
    public final ConduitCapability conduitCapability;

    public BlockLogicConduitBase(Block<?> block, Material material, Tier tier, Supplier<TileEntity> tileEntitySupplier, ConduitCapability conduitCapability) {
        super(block, material);
        this.tier = tier;
        this.conduitCapability = conduitCapability;
        block.withEntity(tileEntitySupplier);
    }

    public String getDescription(ItemStack stack) {
        return "Tier: " + this.tier.getTextColor() + this.tier.getRank();
    }

    @Override
    public Tier getTier() {
        return this.tier;
    }

    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        this.setBlockBoundsFromState(world, x, y, z);
        return super.getBlockBoundsFromState(world, x, y, z);
    }

    public void setBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof ISupportsMultiparts && ((ISupportsMultiparts)tile).getParts().values().stream().anyMatch(Objects::nonNull)) {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            return;
        }
        float bx = 0.3f;
        float by = 0.3f;
        float bz = 0.3f;
        float tx = 0.7f;
        float ty = 0.7f;
        float tz = 0.7f;
        for (Direction dir : Direction.values()) {
            Vec3i v = dir.getVec();
            TileEntity te = world.getTileEntity(x + v.x, y + v.y, z + v.z);
            Block b = world.getBlock(x + v.x, y + v.y, z + v.z);
            if (!(te instanceof TileEntityFluidPipe) && (b == null || !(b.getLogic() instanceof IConduitBlock) || this.getConduitCapability() != ((IConduitBlock)b.getLogic()).getConduitCapability())) continue;
            if (v.x > 0) {
                tx = 1.0f;
            } else if (v.x < 0) {
                bx = 0.0f;
            }
            if (v.z > 0) {
                tz = 1.0f;
            } else if (v.z < 0) {
                bz = 0.0f;
            }
            if (v.y > 0) {
                ty = 1.0f;
                continue;
            }
            if (v.y >= 0) continue;
            by = 0.0f;
        }
        this.setBlockBounds(bx, by, bz, tx, ty, tz);
    }

    public ConduitCapability getConduitCapability() {
        return this.conduitCapability;
    }

    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        if (!this.isPlayerHoldingWrench(player)) {
            return false;
        }
        Pair pair = Catalyst.getBlockSurfaceClickPosition((World)world, (Player)player, (Side)side, (Vec2f)new Vec2f(xHit, yHit));
        Side playerFacing = Catalyst.calculatePlayerFacing((float)player.yRot);
        if (this.pairIsInvalid((Pair<Direction, BlockSection>)pair)) {
            return false;
        }
        if (this.isPlayerHoldingConfigTablet(player)) {
            this.handleConfigTabletAction(player, (Pair<Direction, BlockSection>)pair, world, x, y, z, playerFacing);
        }
        return true;
    }

    private boolean isPlayerHoldingWrench(Player player) {
        return player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof IWrench;
    }

    private boolean pairIsInvalid(Pair<Direction, BlockSection> pair) {
        return pair == null || pair.getLeft() == null || pair.getRight() == null;
    }

    private boolean isPlayerHoldingConfigTablet(Player player) {
        return player.getCurrentEquippedItem().getItem() instanceof ItemConfigurationTablet;
    }

    private void handleConfigTabletAction(Player player, Pair<Direction, BlockSection> pair, World world, int x, int y, int z, Side playerFacing) {
        ConfigurationTabletMode mode = ConfigurationTabletMode.values()[player.getCurrentEquippedItem().getData().getInteger("mode")];
        if (Objects.requireNonNull(mode) == ConfigurationTabletMode.DISCONNECTOR) {
            this.handlePipeDisconnect(pair, world, x, y, z, playerFacing, player);
        }
    }

    private void handlePipeDisconnect(Pair<Direction, BlockSection> pair, World world, int x, int y, int z, Side playerFacing, Player player) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileEntityItemConduit) {
            Direction dir = ((BlockSection)pair.getRight()).toDirection((Direction)pair.getLeft(), playerFacing);
            ((TileEntityItemConduit)tile).noConnectDirections.put(dir, ((TileEntityItemConduit)tile).noConnectDirections.get(dir) == false);
        }
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        ItemStack[] breakResult = super.getBreakResult(world, dropCause, x, y, z, meta, tileEntity);
        if (tileEntity instanceof ISupportsMultiparts) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (Multipart multipart : ((ISupportsMultiparts)tileEntity).getParts().values()) {
                if (multipart == null) continue;
                ItemStack stack = new ItemStack((Item)CatalystMultipart.multipartItem, 1, 0);
                CompoundTag tag = new CompoundTag();
                CompoundTag multipartTag = new CompoundTag();
                multipartTag.putString("Type", multipart.type.name);
                multipartTag.putInt("Block", multipart.block.id());
                multipartTag.putInt("Meta", multipart.meta);
                if (multipart.side != null) {
                    multipartTag.putInt("Side", multipart.side.getId());
                }
                tag.putCompound("Multipart", multipartTag);
                stack.setData(tag);
                list.add(stack);
            }
            if (breakResult != null) {
                list.add(breakResult[0]);
            }
            return list.toArray(new ItemStack[0]);
        }
        return breakResult;
    }
}

