/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.blocks.logic.base;

import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.multiblocks.IMultiblock;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.blocks.logic.base.BlockLogicMachineBase;
import sunsetsatellite.signalindustries.util.Tier;

public class BlockLogicMachine
extends BlockLogicMachineBase {
    public final String guiId;

    public BlockLogicMachine(Block<?> block, Material material, Tier tier, Supplier<TileEntity> tileEntitySupplier, String guiId) {
        super(block, material, tier, tileEntitySupplier);
        this.guiId = guiId;
    }

    @Override
    public boolean onBlockRightClicked(World world, int i, int j, int k, Player entityplayer, Side side, double xHit, double yHit) {
        if (world.isClientSide) {
            return true;
        }
        if (super.onBlockRightClicked(world, i, j, k, entityplayer, side, xHit, yHit)) {
            return true;
        }
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile != null && this.guiId != null) {
            if (tile instanceof IMultiblock) {
                if (((IMultiblock)tile).getMultiblock() != null && ((IMultiblock)tile).getMultiblock().isValid()) {
                    Catalyst.displayGui((Player)entityplayer, (TileEntity)tile, (String)SignalIndustries.key("gui/" + this.guiId));
                    return true;
                }
                entityplayer.sendTranslatedChatMessage("event.signalindustries.invalidMultiblock");
                return true;
            }
        } else {
            return false;
        }
        Catalyst.displayGui((Player)entityplayer, (TileEntity)tile, (String)SignalIndustries.key("gui/" + this.guiId));
        return true;
    }
}

