/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.blocks.models;

import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.vector.Vec3f;
import sunsetsatellite.signalindustries.blocks.models.BlockModelIOPreview;
import sunsetsatellite.signalindustries.covers.CoverBase;
import sunsetsatellite.signalindustries.tiles.base.TileEntityCoverable;

public class BlockModelCoverable
extends BlockModelIOPreview {
    public BlockModelCoverable(Block<? extends BlockLogic> block) {
        super(block);
    }

    public boolean render(Tessellator tessellator, int x, int y, int z) {
        TileEntity tile = BlockModelCoverable.renderBlocks.blockAccess.getTileEntity(x, y, z);
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileEntityCoverable) {
            TileEntityCoverable machine = (TileEntityCoverable)tile;
            for (Direction dir : machine.getCovers().keySet()) {
                CoverBase cover = machine.getCovers().get(dir);
                Vec3f vec = dir.getVecF().divide(100.0);
                if (cover == null) continue;
                IconCoordinate tex = TextureRegistry.getTexture((String)cover.getTexture());
                BlockModelCoverable.renderBlocks.overrideBlockTexture = TextureRegistry.getTexture((String)cover.getTexture());
                BlockModelCoverable.renderBlocks.useInventoryTint = false;
                BlockModelCoverable.renderBlocks.enableAO = true;
                int side = dir.getSideNumber();
                if (side == 0) {
                    this.renderBottomFace(tessellator, this.block.getBounds(), (double)x + vec.x, (double)y + vec.y, (double)z + vec.z, tex);
                } else if (side == 1) {
                    this.renderTopFace(tessellator, this.block.getBounds(), (double)x + vec.x, (double)y + vec.y, (double)z + vec.z, tex);
                } else if (side == 2) {
                    this.renderNorthFace(tessellator, this.block.getBounds(), (double)x + vec.x, (double)y + vec.y, (double)z + vec.z, tex);
                } else if (side == 3) {
                    this.renderSouthFace(tessellator, this.block.getBounds(), (double)x + vec.x, (double)y + vec.y, (double)z + vec.z, tex);
                } else if (side == 4) {
                    this.renderWestFace(tessellator, this.block.getBounds(), (double)x + vec.x, (double)y + vec.y, (double)z + vec.z, tex);
                } else if (side == 5) {
                    this.renderEastFace(tessellator, this.block.getBounds(), (double)x + vec.x, (double)y + vec.y, (double)z + vec.z, tex);
                }
                BlockModelCoverable.renderBlocks.useInventoryTint = true;
                BlockModelCoverable.renderBlocks.overrideBlockTexture = null;
            }
        }
        return super.render(tessellator, x, y, z);
    }
}

