/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.covers;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.Container;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.fluids.api.IFluidInventory;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidItemContainer;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.covers.CoverBase;
import sunsetsatellite.signalindustries.interfaces.IAcceptsCovers;
import sunsetsatellite.signalindustries.items.covers.ItemCover;
import sunsetsatellite.signalindustries.tiles.base.TileEntityWithName;

public class VoidCover
extends CoverBase {
    protected final String texture = "signalindustries:block/void_cover";
    public int voidingItemSlot = -1;
    public int voidingFluidSlot = -1;
    public boolean active = false;

    @Override
    public void openConfiguration(Player player, Direction dir) {
        if (this.machine instanceof Container && this.machine instanceof TileEntity) {
            TileEntity tile = (TileEntity)this.machine;
            Container inv = (Container)this.machine;
            Catalyst.displayGui((Player)player, (TileEntity)tile, (String)SignalIndustries.key("gui/void_cover"), (CompoundTag)Catalyst.compoundOf((String[])new String[]{"side"}, (Object[])new Object[]{dir.ordinal()}));
        } else if (this.machine instanceof TileEntityWithName) {
            TileEntityWithName tile = (TileEntityWithName)((Object)this.machine);
            Catalyst.displayGui((Player)player, (TileEntity)tile, (String)SignalIndustries.key("gui/void_cover"), (CompoundTag)Catalyst.compoundOf((String[])new String[]{"side"}, (Object[])new Object[]{dir.ordinal()}));
        }
    }

    @Override
    public void writeToNbt(CompoundTag tag) {
        super.writeToNbt(tag);
        tag.putInt("VoidingItemSlot", this.voidingItemSlot);
        tag.putInt("VoidingFluidSlot", this.voidingFluidSlot);
        tag.putBoolean("Active", this.active);
    }

    @Override
    public void readFromNbt(CompoundTag tag) {
        super.readFromNbt(tag);
        this.voidingFluidSlot = tag.getIntegerOrDefault("VoidingItemSlot", -1);
        this.voidingFluidSlot = tag.getIntegerOrDefault("VoidingFluidSlot", -1);
        this.active = tag.getBooleanOrDefault("Active", false);
    }

    @Override
    public void tick() {
        if (this.active) {
            int i;
            Container inv;
            if (this.voidingItemSlot != -1) {
                if (this.voidingItemSlot == -2) {
                    inv = (Container)this.machine;
                    for (i = 0; i < inv.getContainerSize(); ++i) {
                        inv.setItem(i, null);
                    }
                } else {
                    inv = (Container)this.machine;
                    inv.setItem(this.voidingItemSlot, null);
                }
            }
            if (this.voidingFluidSlot != -1) {
                if (this.voidingFluidSlot == -2) {
                    inv = (IFluidInventory)this.machine;
                    for (i = 0; i < inv.getFluidInventorySize(); ++i) {
                        inv.setFluidInSlot(i, null);
                    }
                } else {
                    inv = (IFluidInventory)this.machine;
                    inv.setFluidInSlot(this.voidingItemSlot, null);
                }
            }
        }
    }

    @Override
    public String getTexture() {
        return "signalindustries:block/void_cover";
    }

    @Override
    public ItemCover getItem() {
        return SIItems.voidCover;
    }

    @Override
    public void onInstalled(Direction dir, IAcceptsCovers machine, Player player) {
        player.sendMessage("Cover installed!");
        super.onInstalled(dir, machine, player);
    }

    @Override
    public void onRemoved(Player player) {
        player.sendMessage("Cover removed!");
        super.onRemoved(player);
    }

    public void buttonClicked(int id, int button, int channel) {
        if (this.machine instanceof TileEntityFluidItemContainer) {
            TileEntityFluidItemContainer tile = (TileEntityFluidItemContainer)this.machine;
            if (button == 0) {
                switch (id) {
                    case 0: {
                        this.active = !this.active;
                        break;
                    }
                    case 1: {
                        int max = tile.getContainerSize() - 1;
                        if (this.voidingItemSlot >= max) break;
                        ++this.voidingItemSlot;
                        break;
                    }
                    case 2: {
                        int max = tile.getFluidInventorySize() - 1;
                        if (this.voidingFluidSlot >= max) break;
                        ++this.voidingFluidSlot;
                        break;
                    }
                }
            } else if (button == 1) {
                switch (id) {
                    case 1: {
                        if (this.voidingItemSlot <= -2) break;
                        --this.voidingItemSlot;
                        if (this.voidingItemSlot != -2) break;
                        this.active = false;
                        break;
                    }
                    case 2: {
                        if (this.voidingFluidSlot <= -2) break;
                        --this.voidingFluidSlot;
                        if (this.voidingFluidSlot != -2) break;
                        this.active = false;
                    }
                }
            }
        }
    }
}

