/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.items;

import java.util.Objects;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import sunsetsatellite.catalyst.core.util.ICustomDescription;
import sunsetsatellite.catalyst.multiblocks.IMultiblock;
import sunsetsatellite.catalyst.multiblocks.Multiblock;
import sunsetsatellite.signalindustries.util.SIMultiblock;

public class ItemBlueprint
extends Item
implements ICustomDescription {
    public ItemBlueprint(String translationKey, String namespaceId, int id) {
        super(translationKey, namespaceId, id);
    }

    public boolean onUseItemOnBlock(ItemStack stack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        TileEntity tile = world.getTileEntity(blockX, blockY, blockZ);
        if (tile instanceof IMultiblock) {
            IMultiblock multiblock = (IMultiblock)tile;
            stack.getData().putString("multiblock", multiblock.getMultiblock().data.translateKey);
            entityplayer.sendMessage("Blueprint written down!");
        }
        return super.onUseItemOnBlock(stack, entityplayer, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
    }

    public String getDescription(ItemStack stack) {
        String key = stack.getData().getStringOrDefault("multiblock", "");
        if (!Objects.equals(key, "")) {
            SIMultiblock multiblock = (SIMultiblock)((Object)Multiblock.multiblocks.get(key.replace("multiblock.signalindustries.", "")));
            return "Tier: " + multiblock.tier.getTextColor() + multiblock.tier.getRank() + "\n" + TextFormatting.LIGHT_BLUE + multiblock.getTranslatedName() + TextFormatting.RESET;
        }
        return TextFormatting.GRAY + "Blank" + TextFormatting.RESET;
    }
}

