/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.items.tools;

import com.mojang.nbt.tags.CompoundTag;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.entity.EntityRendererItem;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidContainer;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.SIDimensions;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.interfaces.IHasOverlay;
import sunsetsatellite.signalindustries.interfaces.IInjectable;
import sunsetsatellite.signalindustries.interfaces.IPowerSuit;
import sunsetsatellite.signalindustries.interfaces.mixins.IWarpPlayer;
import sunsetsatellite.signalindustries.invs.InventoryPulsar;
import sunsetsatellite.signalindustries.items.ItemSignalumPowerHarness;
import sunsetsatellite.signalindustries.items.ItemTiered;
import sunsetsatellite.signalindustries.util.InventorySerializer;
import sunsetsatellite.signalindustries.util.Tier;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class ItemPulsar
extends ItemTiered
implements IHasOverlay,
IInjectable {
    public ItemPulsar(String translationKey, String namespaceId, int id, Tier tier) {
        super(translationKey, namespaceId, id, tier);
    }

    public boolean onUseItemOnBlock(ItemStack itemstack, Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (world.isClientSide) {
            return true;
        }
        if (player.isSneaking() && !itemstack.getData().getBoolean("charging")) {
            Catalyst.displayGui((Player)player, (Container)new InventoryPulsar(itemstack), (int)player.inventory.getCurrentItemIndex(), (boolean)false, (String)SignalIndustries.key("gui/pulsar"));
            return true;
        }
        return false;
    }

    public ItemStack onUseItem(ItemStack itemstack, World world, Player player) {
        if (!itemstack.getData().getBoolean("charging") && itemstack.getData().getByte("charge") < 100 && !player.isSneaking() && this.getFluidStack(0, itemstack).getInteger("amount") > 0) {
            itemstack.getData().putBoolean("charging", true);
            return itemstack;
        }
        if (itemstack.getData().getByte("charge") >= 100) {
            itemstack.getData().putByte("charge", (byte)0);
            if (this.getAbility(itemstack).contains("Warp")) {
                CompoundTag data = this.getItemFromSlot(0, itemstack).getCompound("Data");
                CompoundTag warpPosition = data.getCompound("position");
                if (warpPosition.containsKey("x") && warpPosition.containsKey("y") && warpPosition.containsKey("z")) {
                    if (data.getInteger("dim") != player.dimension) {
                        ((IWarpPlayer)player).warp(data.getInteger("dim"));
                    }
                    player.setPos((double)warpPosition.getInteger("x"), (double)warpPosition.getInteger("y"), (double)warpPosition.getInteger("z"));
                } else {
                    ((IWarpPlayer)player).warp(SIDimensions.ETERNITY.id);
                }
                ((Map)itemstack.getData().getCompound("inventory").getValue()).remove(String.valueOf(0));
            } else {
                world.spawnParticle("signalindustries.shockwave", player.x, player.y - 1.0, player.z, 0.0, 0.0, 0.0, 0);
                if (EnvironmentHelper.isServerEnvironment() || EnvironmentHelper.isSinglePlayer()) {
                    AABB bb = AABB.getTemporaryBB((double)(player.x - 5.0), (double)(player.y - 1.0), (double)(player.z - 5.0), (double)(player.x + 5.0), (double)(player.y + 1.0), (double)(player.z + 5.0));
                    List list = world.getEntitiesWithinAABBExcludingEntity((Entity)player, bb);
                    for (Entity entity : list) {
                        if (!(entity instanceof Mob)) continue;
                        entity.hurt((Entity)player, 15, DamageType.BLAST);
                        double d = player.x - entity.x;
                        double d1 = player.z - entity.z;
                        while (d * d + d1 * d1 < 1.0E-4) {
                            d = (Math.random() - Math.random()) * 0.01;
                            d1 = (Math.random() - Math.random()) * 0.01;
                        }
                        ((Mob)entity).attackedAtYaw = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - entity.yRot;
                        ((Mob)entity).knockBack(entity, 15, d, d1);
                    }
                }
            }
        }
        return itemstack;
    }

    public void inventoryTick(ItemStack itemstack, World world, Entity entity, int slotId, boolean flag) {
        boolean charging = itemstack.getData().getBoolean("charging");
        byte charge = itemstack.getData().getByte("charge");
        int energy = this.getFluidStack(0, itemstack).getInteger("amount");
        if (itemstack.getData().getBoolean("charging")) {
            if (charge < 100) {
                if (energy <= 0) {
                    this.getFluidStack(0, itemstack).putInt("amount", 0);
                    itemstack.getData().putBoolean("charging", false);
                    ((Player)entity).sendMessage(TextFormatting.RED + "[Pulsar] Ran out of energy while charging!");
                    return;
                }
                if (this.getItemIdFromSlot(0, itemstack) == SIItems.warpOrb.id) {
                    this.getFluidStack(0, itemstack).putInt("amount", energy - 80);
                } else {
                    this.getFluidStack(0, itemstack).putInt("amount", energy - 40);
                }
                itemstack.getData().putByte("charge", (byte)(charge + 1));
            } else {
                itemstack.getData().putBoolean("charging", false);
            }
        }
        super.inventoryTick(itemstack, world, entity, slotId, flag);
    }

    @Override
    public void renderOverlay(HudIngame guiIngame, Player player, int height, int width, int mouseX, int mouseY, Font fontRenderer, EntityRendererItem itemRenderer) {
        ContainerInventory inv = player.inventory;
        ItemStack pulsar = inv.getCurrentItem();
        int i = inv.armorItemInSlot(2) != null && inv.armorItemInSlot(2).getItem() instanceof ItemSignalumPowerHarness ? height - 128 : height - 64;
        fontRenderer.drawStringWithShadow("The Pulsar", 4, i += 16, -65536);
        fontRenderer.drawStringWithShadow("Ability: ", 4, i += 16, -1);
        fontRenderer.drawStringWithShadow(((ItemPulsar)pulsar.getItem()).getAbility(pulsar), 4 + fontRenderer.getStringWidth("Ability: "), i, -65536);
        fontRenderer.drawStringWithShadow("Charge: ", 4, i += 10, -1);
        fontRenderer.drawStringWithShadow(String.valueOf(pulsar.getData().getByte("charge")) + "%", 4 + fontRenderer.getStringWidth("Charge: "), i, pulsar.getData().getByte("charge") >= 100 ? -65536 : -1);
        fontRenderer.drawStringWithShadow("Energy: ", 4, i += 10, -1);
        fontRenderer.drawStringWithShadow(String.valueOf(((ItemPulsar)pulsar.getItem()).getFluidStack(0, pulsar).getInteger("amount")), 4 + fontRenderer.getStringWidth("Energy: "), i, -32640);
    }

    @Override
    public void renderOverlay(ItemStack stack, IPowerSuit signalumPowerSuit, HudIngame guiIngame, Player player, int height, int width, int mouseX, int mouseY, Font fontRenderer, EntityRendererItem itemRenderer) {
    }

    @Override
    public void fill(FluidStack fluidStack, ItemStack stack, TileEntityFluidContainer tile, int maxAmount) {
        InventoryPulsar inv = new InventoryPulsar(stack);
        InventorySerializer.loadInvFromNBT(stack, inv, 1, 1);
        inv.insertFluid(0, fluidStack.splitStack(Math.min(maxAmount, fluidStack.amount)));
        InventorySerializer.saveInvToNBT(stack, inv);
    }

    @Override
    public String getDescription(ItemStack stack) {
        String text = super.getDescription(stack);
        String ability = this.getAbility(stack);
        text = text + "\nCharge: " + (stack.getData().getByte("charge") >= 100 ? TextFormatting.RED : TextFormatting.LIGHT_GRAY) + stack.getData().getByte("charge") + "%" + TextFormatting.WHITE + " | Ability: " + ability;
        return text;
    }

    @Override
    public boolean canFill(ItemStack stack) {
        InventoryPulsar inv = new InventoryPulsar(stack);
        InventorySerializer.loadInvFromNBT(stack, inv, 1, 1);
        return inv.fluidContents[0] == null || inv.fluidContents[0].amount < inv.getFluidCapacityForSlot(0);
    }

    public int getItemIdFromSlot(int id, ItemStack stack) {
        return stack.getData().getCompound("inventory").getCompound(String.valueOf(id)).getShort("id");
    }

    public CompoundTag getItemFromSlot(int id, ItemStack stack) {
        return stack.getData().getCompound("inventory").getCompound(String.valueOf(id));
    }

    public CompoundTag getFluidStack(int id, ItemStack stack) {
        return stack.getData().getCompound("fluidInventory").getCompound(String.valueOf(id));
    }

    public String getAbility(ItemStack stack) {
        return this.getItemIdFromSlot(0, stack) == SIItems.warpOrb.id ? TextFormatting.PURPLE + "Warp" : TextFormatting.RED + "Pulse";
    }
}

