/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.render.terrain.TerrainRenderer;
import net.minecraft.client.world.chunk.provider.ChunkProviderDynamic;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import org.lwjgl.input.Keyboard;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sunsetsatellite.signalindustries.SIConfig;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.interfaces.IPlayerPowerSuit;
import sunsetsatellite.signalindustries.powersuit.SignalumPowerSuit;
import sunsetsatellite.signalindustries.util.KeyboardHandler;

@Mixin(value={Minecraft.class}, remap=false)
public abstract class MinecraftMixin {
    @Shadow
    public PlayerLocal thePlayer;
    @Shadow
    public HitResult objectMouseOver;
    @Shadow
    public TerrainRenderer terrainRenderer;

    @Shadow
    protected abstract void clickMouse(int var1, boolean var2, boolean var3);

    @Shadow
    public abstract void resize();

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lorg/lwjgl/input/Keyboard;next()Z", shift=At.Shift.AFTER)})
    public void handleKeyboard(CallbackInfo ci) {
        KeyboardHandler.handleKeyboard((Minecraft)this, ci);
    }

    @ModifyArg(method={"runTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/util/helper/MathHelper;clamp(FFF)F"), index=2)
    public float modifyMaxFlySpeed(float original) {
        return 5.0f;
    }

    @ModifyExpressionValue(method={"runTick"}, at={@At(value="FIELD", opcode=180, target="Lnet/minecraft/client/entity/player/PlayerLocal;noPhysics:Z")})
    public boolean modifyWingsFlightSpeed(boolean original) {
        SignalumPowerSuit ps = (SignalumPowerSuit)((IPlayerPowerSuit)this.thePlayer).getPowerSuit();
        if (ps != null && ps.active && ps.hasAttachment(SIItems.crystalWings)) {
            return original || ps.getAttachment(SIItems.crystalWings).getData().getBoolean("active");
        }
        return original;
    }

    @ModifyExpressionValue(method={"runTick"}, at={@At(value="FIELD", opcode=180, target="Lnet/minecraft/client/Minecraft;toggleFlyPressed:Z")})
    public boolean modifyWingsFlightSpeed2(boolean original) {
        boolean control = Keyboard.isKeyDown((int)Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown((int)Keyboard.KEY_RCONTROL);
        SignalumPowerSuit ps = (SignalumPowerSuit)((IPlayerPowerSuit)this.thePlayer).getPowerSuit();
        if (ps != null && ps.active && ps.hasAttachment(SIItems.crystalWings)) {
            return original || ps.getAttachment(SIItems.crystalWings).getData().getBoolean("active") && control;
        }
        return original;
    }

    @Inject(method={"createChunkProvider"}, at={@At(value="HEAD")}, cancellable=true)
    public void switchProvider(World world, IChunkLoader chunkLoader, CallbackInfoReturnable<IChunkProvider> cir) {
        if (SIConfig.config.getBoolean("Experimental.enableDynamicChunkProvider")) {
            cir.setReturnValue((Object)new ChunkProviderDynamic(world, chunkLoader, world.getWorldType().createChunkGenerator(world)));
        }
    }
}

