/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.util.List;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SIDimensions;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.SIWeather;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.interfaces.IPlayerPowerSuit;
import sunsetsatellite.signalindustries.powersuit.SignalumPowerSuit;

@Mixin(value={Mob.class}, remap=false)
public abstract class MobMixin
extends Entity {
    @Unique
    private final Mob thisAs = (Mob)this;

    @Shadow
    protected abstract List<WeightedRandomLootObject> getMobDrops();

    private MobMixin(@Nullable World world) {
        super(world);
    }

    @Inject(method={"getMaxSpawnedInChunk"}, at={@At(value="HEAD")}, cancellable=true)
    public void bloodMoonSpawning(CallbackInfoReturnable<Integer> cir) {
        if (this.world != null) {
            cir.setReturnValue((Object)(this.world.getCurrentWeather() == SIWeather.weatherBloodMoon ? 16 : 4));
        }
    }

    @Inject(method={"canSpawnHere"}, at={@At(value="HEAD")}, cancellable=true)
    public void canSpawnHere(CallbackInfoReturnable<Boolean> cir) {
        if (this.world != null && this.world.dimension == SIDimensions.ETERNITY) {
            cir.setReturnValue((Object)false);
        }
        SignalIndustries.uvLamps.removeIf(B -> this.world.getBlock(B.pos.x, B.pos.y, B.pos.z) != SIBlocks.uvLamp);
        for (BlockInstance lamp : SignalIndustries.uvLamps) {
            if (this.world.getBlockMetadata(lamp.pos.x, lamp.pos.y, lamp.pos.z) != 1 || !(this.distanceTo(lamp.pos.x, lamp.pos.y, lamp.pos.z) < 20.0)) continue;
            cir.setReturnValue((Object)false);
            break;
        }
    }

    @Inject(method={"dropDeathItems"}, at={@At(value="HEAD")})
    protected void dropDeathItems(CallbackInfo ci) {
        List<WeightedRandomLootObject> drops;
        if (this.world != null && this.world.getCurrentWeather() == SIWeather.weatherBloodMoon && (drops = this.getMobDrops()) != null) {
            for (WeightedRandomLootObject lootObject : drops) {
                ItemStack stack = lootObject.getItemStack();
                if (stack == null) continue;
                for (int i = 0; i < stack.stackSize; ++i) {
                    this.dropItem(new ItemStack(stack.itemID, 1, stack.getMetadata(), stack.getData()), 0.0f);
                }
            }
        }
    }

    @ModifyExpressionValue(method={"moveEntityWithHeading"}, at={@At(value="FIELD", target="Lnet/minecraft/core/entity/Mob;noPhysics:Z", opcode=180)})
    private boolean flyWithWings(boolean original) {
        if (this.thisAs instanceof Player) {
            Player player = (Player)this.thisAs;
            SignalumPowerSuit ps = (SignalumPowerSuit)((IPlayerPowerSuit)player).getPowerSuit();
            if (ps != null && ps.active && ps.hasAttachment(SIItems.crystalWings)) {
                return original || ps.getAttachment(SIItems.crystalWings).getData().getBoolean("active");
            }
            return original;
        }
        return original;
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    protected void causeFallDamage(float f, CallbackInfo ci) {
        Player player;
        SignalumPowerSuit ps;
        if (this.thisAs instanceof Player && (ps = (SignalumPowerSuit)((IPlayerPowerSuit)(player = (Player)this.thisAs)).getPowerSuit()) != null && ps.active && ps.hasAttachment(SIItems.crystalWings) && ps.getAttachment(SIItems.crystalWings).getData().getBoolean("active")) {
            ci.cancel();
        }
    }
}

