/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.entity.MobRendererPlayer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sunsetsatellite.signalindustries.SIItems;
import sunsetsatellite.signalindustries.interfaces.IPlayerPowerSuit;
import sunsetsatellite.signalindustries.interfaces.IPowerSuit;
import sunsetsatellite.signalindustries.items.ItemArmorTiered;
import sunsetsatellite.signalindustries.items.ItemSignalumPowerHarness;
import sunsetsatellite.signalindustries.items.ItemSignalumPowerSuit;
import sunsetsatellite.signalindustries.items.attachments.ItemAttachment;
import sunsetsatellite.signalindustries.items.attachments.ItemSuitColorizer;

@Mixin(value={MobRendererPlayer.class}, remap=false)
public abstract class MobRendererPlayerMixin
extends MobRenderer<Player> {
    @Shadow
    private ModelBiped modelBipedMain;
    @Shadow
    @Final
    private ModelBiped modelArmor;

    private MobRendererPlayerMixin(ModelBase model, float shadowSize) {
        super(model, shadowSize);
    }

    @Inject(method={"prepareArmor(Lnet/minecraft/core/entity/player/Player;IF)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/MobRendererPlayer;bindTexture(Ljava/lang/String;)V", ordinal=3, shift=At.Shift.AFTER)})
    protected void prepareArmor(Player entity, int layer, float partialTick, CallbackInfoReturnable<Boolean> cir, @Local(name={"item"}) Item item) {
        if (item instanceof ItemArmorTiered) {
            Object powerSuit;
            if (item instanceof ItemSignalumPowerHarness) {
                if ((layer == 0 || layer == 1) && entity.inventory.armorItemInSlot(2) != null && entity.inventory.armorItemInSlot(2).getData().getBoolean("active_shield")) {
                    if (entity.inventory.armorItemInSlot(3) != null && entity.inventory.armorItemInSlot(3).getItem() instanceof ItemSignalumPowerHarness) {
                        this.bindTexture("/assets/signalindustries/textures/armor/harness_shield_1.png");
                    } else {
                        this.bindTexture("/assets/signalindustries/textures/armor/harness_shield_no_goggles_1.png");
                    }
                }
            } else if (item instanceof ItemSignalumPowerSuit && (powerSuit = ((IPlayerPowerSuit)entity).getPowerSuit()) != null) {
                ItemStack stack;
                if (powerSuit.hasAttachment(SIItems.awakenedAbilityModule) && (stack = powerSuit.getAttachment(SIItems.awakenedAbilityModule)) != null) {
                    this.bindTexture("/assets/signalindustries/textures/armor/power_suit_awakened_" + (layer != 2 ? 1 : 2) + ".png");
                }
                if (powerSuit.hasAttachmentClass(ItemSuitColorizer.class) && (stack = powerSuit.getAttachmentClass(ItemSuitColorizer.class)) != null) {
                    ItemSuitColorizer suitColorizer = (ItemSuitColorizer)stack.getItem();
                    this.bindTexture(suitColorizer.path + "_" + (layer != 2 ? 1 : 2) + ".png");
                }
            }
        }
    }

    @Inject(method={"renderAdditional(Lnet/minecraft/core/entity/player/Player;F)V"}, at={@At(value="HEAD")})
    protected void renderAdditional(Player player, float partialTick, CallbackInfo ci) {
        Object powerSuit = ((IPlayerPowerSuit)player).getPowerSuit();
        if (powerSuit != null) {
            for (ItemStack content : powerSuit.getArmorPiece((int)3).contents) {
                if (content == null) continue;
                GL11.glPushMatrix();
                ((ItemAttachment)content.getItem()).renderWhenAttached(player, (IPowerSuit)powerSuit, this.modelBipedMain, content);
                GL11.glPopMatrix();
            }
            for (ItemStack content : powerSuit.getArmorPiece((int)2).contents) {
                if (content == null) continue;
                GL11.glPushMatrix();
                ((ItemAttachment)content.getItem()).renderWhenAttached(player, (IPowerSuit)powerSuit, this.modelBipedMain, content);
                GL11.glPopMatrix();
            }
            for (ItemStack content : powerSuit.getArmorPiece((int)1).contents) {
                if (content == null) continue;
                GL11.glPushMatrix();
                ((ItemAttachment)content.getItem()).renderWhenAttached(player, (IPowerSuit)powerSuit, this.modelBipedMain, content);
                GL11.glPopMatrix();
            }
            for (ItemStack content : powerSuit.getArmorPiece((int)0).contents) {
                if (content == null) continue;
                GL11.glPushMatrix();
                ((ItemAttachment)content.getItem()).renderWhenAttached(player, (IPowerSuit)powerSuit, this.modelBipedMain, content);
                GL11.glPopMatrix();
            }
        }
    }
}

