/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.RenderGlobal;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.HologramWorld;
import sunsetsatellite.catalyst.core.util.model.IFullbright;
import sunsetsatellite.signalindustries.SIDimensions;
import sunsetsatellite.signalindustries.SIWeather;
import sunsetsatellite.signalindustries.abilities.powersuit.ScanSuitAbility;
import sunsetsatellite.signalindustries.abilities.trigger.ScanAbility;

@Mixin(value={RenderGlobal.class}, remap=false)
public class RenderGlobalMixin {
    @Shadow
    @Final
    private Minecraft mc;
    @Shadow
    private WorldClient worldObj;
    @Shadow
    @Final
    private TextureManager textureManager;
    @Shadow
    @Final
    private int starGLCallList;
    @Unique
    private RenderBlocks blockRenderer;

    @Inject(method={"drawSky"}, at={@At(value="HEAD")})
    public void eternitySky(float partialTick, CallbackInfo ci) {
        if (this.mc.currentWorld.dimension == SIDimensions.ETERNITY) {
            this.textureManager.loadTexture("/assets/signalindustries/textures/colormap/stars/default.png").bind();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glCallList((int)this.starGLCallList);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)2912);
            GL11.glPopMatrix();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            GL11.glDepthMask((boolean)true);
        }
    }

    @Inject(method={"drawSky"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glColor4f(FFFF)V", ordinal=1, shift=At.Shift.AFTER)})
    public void renderBloodMoon(float partialTicks, CallbackInfo ci) {
        if (this.worldObj.getCurrentWeather() == SIWeather.weatherBloodMoon) {
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    @Inject(method={"drawSky"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glColor4f(FFFF)V", ordinal=1, shift=At.Shift.AFTER)})
    public void renderMeteorShower(float partialTicks, CallbackInfo ci, @Local(name={"sunAlpha"}) LocalFloatRef f6) {
        if (this.worldObj.getCurrentWeather() == SIWeather.weatherMeteorShower) {
            f6.set(1.5f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Inject(method={"drawSky"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/tessellator/Tessellator;draw()V", ordinal=1, shift=At.Shift.AFTER)})
    public void renderSolar(float partialTick, CallbackInfo ci, @Local Tessellator t) {
        if (this.worldObj.getCurrentWeather() == SIWeather.weatherEclipse) {
            float size = 30.0f;
            this.textureManager.loadTexture("/assets/signalindustries/misc/solar_eclipse.png").bind();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            t.startDrawingQuads();
            t.addVertexWithUV((double)(-size), 100.0, (double)(-size), 0.0, 0.0);
            t.addVertexWithUV((double)size, 100.0, (double)(-size), 1.0, 0.0);
            t.addVertexWithUV((double)size, 100.0, (double)size, 1.0, 1.0);
            t.addVertexWithUV((double)(-size), 100.0, (double)size, 0.0, 1.0);
            t.draw();
        }
    }

    @Inject(method={"renderEntities"}, at={@At(value="TAIL")})
    public void renderWorld(ICamera camera, float partialTick, CallbackInfo ci) {
        double x = camera.getX(partialTick);
        double y = camera.getY(partialTick);
        double z = camera.getZ(partialTick);
        HashMap<Object, Object> oreMap = new HashMap();
        if (!ScanAbility.oreMap.isEmpty()) {
            oreMap = ScanAbility.oreMap;
        }
        if (!ScanSuitAbility.oreMap.isEmpty()) {
            oreMap = ScanSuitAbility.oreMap;
        }
        if (!oreMap.isEmpty()) {
            ArrayList list = new ArrayList();
            oreMap.forEach((block, oreInfo) -> oreInfo.positions.forEach(position -> list.add(new BlockInstance(block, position, null))));
            this.blockRenderer = new RenderBlocks((WorldSource)new HologramWorld(list));
            oreMap.forEach((block, oreInfo) -> oreInfo.positions.forEach(position -> {
                GL11.glPushMatrix();
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(block);
                GL11.glTranslated((double)((double)position.x - x + 0.5), (double)((double)position.y - y + 0.5), (double)((double)position.z - z + 0.5));
                ((IFullbright)model).enableFullbright();
                this.drawBlock(Tessellator.instance, model);
                ((IFullbright)model).disableFullbright();
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                GL11.glPopMatrix();
            }));
        }
    }

    @Unique
    private void drawBlock(Tessellator tessellator, BlockModel<?> model) {
        TextureRegistry.blockAtlas.bind();
        GL11.glPushMatrix();
        RenderBlocks renderBlocks = BlockModel.renderBlocks;
        BlockModel.setRenderBlocks((RenderBlocks)this.blockRenderer);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        model.renderBlockOnInventory(tessellator, 0, 1.0f, null);
        BlockModel.setRenderBlocks((RenderBlocks)renderBlocks);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glEnable((int)2884);
    }
}

