/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mixin;

import java.util.List;
import java.util.Random;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.Difficulty;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.SeasonManager;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.WeatherManager;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sunsetsatellite.signalindustries.SIWeather;
import sunsetsatellite.signalindustries.SignalIndustries;

@Mixin(value={World.class}, remap=false)
public abstract class WorldMixin {
    @Shadow
    public WorldType worldType;
    @Shadow
    public Random rand;
    @Shadow
    public List<Player> players;
    @Shadow
    public WeatherManager weatherManager;
    @Shadow
    public SeasonManager seasonManager;
    @Shadow
    public Dimension dimension;
    @Unique
    private final World thisAs = (World)this;

    @Shadow
    public abstract SeasonManager getSeasonManager();

    @Shadow
    public abstract long getWorldTime();

    @Shadow
    @Nullable
    public abstract Weather getCurrentWeather();

    @Shadow
    public abstract Difficulty getDifficulty();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void doBloodMoon(CallbackInfo ci) {
        int cycleTicks = this.worldType.getDayNightCycleTicks();
        int dayTicks = this.getDayLengthTicks();
        int nightTicks = cycleTicks - dayTicks;
        long worldTime = this.getWorldTime();
        int dayLength = 24000;
        int dayTime = (int)(worldTime % (long)dayLength);
        int triggerTime = this.worldType.getSunriseTick(this.thisAs) + dayTicks;
        if (!(SignalIndustries.bloodMoonsDisabled || dayTime != triggerTime || this.dimension == Dimension.NETHER || this.getCurrentWeather() == SIWeather.weatherBloodMoon && this.getCurrentWeather() == SIWeather.weatherEclipse || this.rand.nextInt(16) != 15 || this.getDifficulty() == Difficulty.PEACEFUL || this.getCurrentWeather() == SIWeather.weatherBloodMoon)) {
            for (Player player : this.players) {
                player.sendMessage(TextFormatting.RED + "A Blood Moon is rising!");
            }
            this.weatherManager.overrideWeather(SIWeather.weatherBloodMoon, 13000L, 1.0f);
        }
        if (dayTime > this.worldType.getSunriseTick(this.thisAs) && dayTime < triggerTime && this.getCurrentWeather() == SIWeather.weatherBloodMoon) {
            this.weatherManager.overrideWeather(Weathers.OVERWORLD_CLEAR);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void doSolarEclipse(CallbackInfo ci) {
        int dayLength;
        long worldTime = this.getWorldTime();
        int dayTime = (int)(worldTime % (long)(dayLength = 24000));
        if (dayTime > 6680 && dayTime < 6700 && this.dimension != Dimension.NETHER && this.seasonManager.getDayInSeason() == 6 && this.seasonManager.getCurrentSeason() == Seasons.OVERWORLD_SUMMER && this.getCurrentWeather() != SIWeather.weatherEclipse) {
            for (Player player : this.players) {
                player.sendMessage(TextFormatting.ORANGE + "A Solar Eclipse is happening!");
            }
            this.weatherManager.overrideWeather(SIWeather.weatherEclipse, 24000L, 1.0f);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void doMeteorShower(CallbackInfo ci) {
        int triggerTime;
        int dayLength;
        int cycleTicks = this.worldType.getDayNightCycleTicks();
        int dayTicks = this.getDayLengthTicks();
        int nightTicks = cycleTicks - dayTicks;
        long worldTime = this.getWorldTime();
        int dayTime = (int)(worldTime % (long)(dayLength = 24000));
        if (dayTime == (triggerTime = this.worldType.getSunriseTick(this.thisAs) + dayTicks + nightTicks / 4) && this.dimension != Dimension.NETHER && (this.getCurrentWeather() != SIWeather.weatherBloodMoon || this.getCurrentWeather() != SIWeather.weatherEclipse) && this.rand.nextInt(16) == 0 && this.getCurrentWeather() != SIWeather.weatherMeteorShower) {
            for (Player player : this.players) {
                player.sendMessage(TextFormatting.LIGHT_BLUE + "A Meteor Shower is happening!");
            }
            this.weatherManager.overrideWeather(SIWeather.weatherMeteorShower, 1200L, 1.0f);
        }
        if (dayTime == 0 && this.getCurrentWeather() == SIWeather.weatherMeteorShower) {
            this.weatherManager.overrideWeather(Weathers.OVERWORLD_CLEAR);
        }
    }

    @Unique
    private int getDayLengthTicks() {
        float dayLength;
        float seasonProgress = this.getSeasonManager().getSeasonProgress();
        if (seasonProgress < 0.5f) {
            float lastSeasonDayLength = this.getSeasonManager().getPreviousSeason().dayLength;
            float thisSeasonDayLength = this.getSeasonManager().getCurrentSeason().dayLength;
            float seasonModifier = this.getSeasonManager().getSeasonModifier() * 0.5f + 0.5f;
            dayLength = lastSeasonDayLength * (1.0f - seasonModifier) + thisSeasonDayLength * seasonModifier;
        } else {
            float thisSeasonDayLength = this.getSeasonManager().getCurrentSeason().dayLength;
            float nextSeasonDayLength = this.getSeasonManager().getNextSeason().dayLength;
            float seasonModifier = this.getSeasonManager().getSeasonModifier() * 0.5f + 0.5f;
            dayLength = thisSeasonDayLength * seasonModifier + nextSeasonDayLength * (1.0f - seasonModifier);
        }
        int cycleTicks = this.worldType.getDayNightCycleTicks();
        return (int)(dayLength * (float)cycleTicks);
    }

    @Inject(method={"getCelestialAngle"}, at={@At(value="HEAD")}, cancellable=true)
    public void solarEclipseCelestialAngle(float f, CallbackInfoReturnable<Float> cir) {
        if (this.getCurrentWeather() == SIWeather.weatherEclipse) {
            cir.setReturnValue((Object)Float.valueOf(1.0f));
        }
    }

    @Inject(method={"wakeUpAllPlayers"}, at={@At(value="HEAD")})
    protected void wakeUpAllPlayers(CallbackInfo ci) {
        if (this.getCurrentWeather() != null && (this.getCurrentWeather() == SIWeather.weatherEclipse || this.getCurrentWeather() == SIWeather.weatherBloodMoon)) {
            this.weatherManager.overrideWeather(Weathers.OVERWORLD_CLEAR);
        }
    }
}

