/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mp.message;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.tiles.machines.TileEntityAutoMiner;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class NetworkMessageAutoMinerStart
implements NetworkMessage {
    public Vec3i pos;
    public Class<? extends TileEntity> tileClass;

    public NetworkMessageAutoMinerStart(Vec3i pos, Class<? extends TileEntity> tileClass) {
        this.pos = pos;
        this.tileClass = tileClass;
    }

    public NetworkMessageAutoMinerStart() {
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        CompoundTag nbt = new CompoundTag();
        this.pos.writeToNBT(nbt);
        packet.writeCompoundTag(nbt);
        packet.writeString(TileEntityDispatcher.getIDFromClass(this.tileClass).toString());
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        this.pos = new Vec3i(packet.readCompoundTag());
        this.tileClass = TileEntityDispatcher.getClassFromID((String)packet.readString());
    }

    public void handle(NetworkMessage.NetworkContext context) {
        TileEntity tileEntity;
        if (EnvironmentHelper.isServerEnvironment() && context.player.world != null && (tileEntity = context.player.world.getTileEntity(this.pos.x, this.pos.y, this.pos.z)) instanceof TileEntityAutoMiner && tileEntity.worldObj != null) {
            if (((TileEntityAutoMiner)tileEntity).workTimer.isPaused()) {
                ((TileEntityAutoMiner)tileEntity).workTimer.unpause();
            } else {
                ((TileEntityAutoMiner)tileEntity).workTimer.pause();
            }
        }
    }
}

