/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mp.message;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.core.util.Connection;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.io.IFluidIO;
import sunsetsatellite.catalyst.core.util.io.IItemIO;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.util.IOPreview;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class NetworkMessageIOChange
implements NetworkMessage {
    public Vec3i pos;
    public Connection connection;
    public Direction dir;
    public IOPreview io;
    public int slot;
    public Class<? extends TileEntity> tileClass;

    public NetworkMessageIOChange(Vec3i pos, Connection connection, Direction dir, IOPreview io, int slot, Class<? extends TileEntity> tileClass) {
        this.pos = pos;
        this.connection = connection;
        this.dir = dir;
        this.io = io;
        this.slot = slot;
        this.tileClass = tileClass;
    }

    public NetworkMessageIOChange() {
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        packet.writeInt(this.connection.ordinal());
        packet.writeInt(this.dir.ordinal());
        packet.writeInt(this.io.ordinal());
        packet.writeInt(this.slot);
        CompoundTag nbt = new CompoundTag();
        this.pos.writeToNBT(nbt);
        packet.writeCompoundTag(nbt);
        packet.writeString(TileEntityDispatcher.getIDFromClass(this.tileClass).toString());
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        this.connection = Connection.values()[packet.readInt()];
        this.dir = Direction.values()[packet.readInt()];
        this.io = IOPreview.values()[packet.readInt()];
        this.slot = packet.readInt();
        this.pos = new Vec3i(packet.readCompoundTag());
        this.tileClass = TileEntityDispatcher.getClassFromID((String)packet.readString());
    }

    public void handle(NetworkMessage.NetworkContext context) {
        if (EnvironmentHelper.isServerEnvironment() && context.player.world != null) {
            TileEntity tileEntity = context.player.world.getTileEntity(this.pos.x, this.pos.y, this.pos.z);
            switch (this.io) {
                case NONE: {
                    return;
                }
                case ITEM: {
                    if (this.tileClass != tileEntity.getClass() || !(tileEntity instanceof IItemIO)) break;
                    ((IItemIO)tileEntity).setItemIOForSide(this.dir, this.connection);
                    ((IItemIO)tileEntity).setActiveItemSlotForSide(this.dir, this.slot);
                    break;
                }
                case FLUID: {
                    if (this.tileClass != tileEntity.getClass() || !(tileEntity instanceof IFluidIO)) break;
                    ((IFluidIO)tileEntity).setFluidIOForSide(this.dir, this.connection);
                    ((IFluidIO)tileEntity).setActiveFluidSlotForSide(this.dir, this.slot);
                }
            }
        }
    }
}

