/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mp.message;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.entity.Entity;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.interfaces.IPlayerPowerSuit;
import sunsetsatellite.signalindustries.powersuit.SignalumPowerSuit;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class NetworkMessagePowerSuitAction
implements NetworkMessage {
    public static final int ACTIVATE = 100;
    public static final int ACTIVATE_APP = 101;
    public static final int ACTIVATE_ATTACHMENT = 102;
    public int action = -1;
    public Vec3i pos = null;
    public Class<? extends Entity> entityClass = null;
    public String attachmentKeybind = "null";
    public boolean shift = false;
    public boolean alt = false;
    public boolean ctrl = false;

    public NetworkMessagePowerSuitAction(int action) {
        this.action = action;
    }

    public NetworkMessagePowerSuitAction setPos(Vec3i pos) {
        this.pos = pos;
        return this;
    }

    public NetworkMessagePowerSuitAction setEntityClass(Class<? extends Entity> entity) {
        this.entityClass = entity;
        return this;
    }

    public NetworkMessagePowerSuitAction setKeybind(String attachmentKeybind) {
        this.attachmentKeybind = attachmentKeybind == null ? "null" : attachmentKeybind;
        return this;
    }

    public NetworkMessagePowerSuitAction setShift(boolean shift) {
        this.shift = shift;
        return this;
    }

    public NetworkMessagePowerSuitAction setAlt(boolean alt) {
        this.alt = alt;
        return this;
    }

    public NetworkMessagePowerSuitAction setCtrl(boolean ctrl) {
        this.ctrl = ctrl;
        return this;
    }

    public NetworkMessagePowerSuitAction() {
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        packet.writeBoolean(this.shift);
        packet.writeBoolean(this.alt);
        packet.writeBoolean(this.ctrl);
        packet.writeInt(this.action);
        packet.writeBoolean(this.pos != null);
        if (this.pos != null) {
            CompoundTag nbt = new CompoundTag();
            this.pos.writeToNBT(nbt);
            packet.writeCompoundTag(nbt);
        }
        packet.writeString(this.entityClass == null ? "null" : this.entityClass.getName());
        packet.writeString(this.attachmentKeybind == null ? "null" : this.attachmentKeybind);
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        String entityClass;
        this.shift = packet.readBoolean();
        this.alt = packet.readBoolean();
        this.ctrl = packet.readBoolean();
        this.action = packet.readInt();
        boolean posExists = packet.readBoolean();
        if (posExists) {
            this.pos = new Vec3i(packet.readCompoundTag());
        }
        if (!"null".equals(entityClass = packet.readString())) {
            try {
                this.entityClass = Class.forName(entityClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        this.attachmentKeybind = packet.readString();
    }

    public void handle(NetworkMessage.NetworkContext context) {
        SignalumPowerSuit suit = (SignalumPowerSuit)((IPlayerPowerSuit)context.player).getPowerSuit();
        if (suit != null && context.player.world != null) {
            if (this.action >= 0 && this.action < 10) {
                suit.selectedApplicationSlot = this.action;
                return;
            }
            switch (this.action) {
                case 100: {
                    suit.active = !suit.active;
                    break;
                }
                case 101: {
                    if (this.pos != null && this.entityClass == null) {
                        suit.activateApplication(this.pos.x, this.pos.y, this.pos.z);
                        break;
                    }
                    if (this.pos != null) {
                        suit.activateApplication((Entity)context.player.world.getClosestPlayer((double)this.pos.x, (double)this.pos.y, (double)this.pos.z, 1.0));
                        break;
                    }
                    suit.activateApplication();
                    break;
                }
                case 102: {
                    suit.activateAttachment(this.attachmentKeybind, this.shift, this.alt, this.ctrl);
                }
            }
        }
    }
}

