/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.mp.message;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import net.minecraft.core.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.signalindustries.covers.RedstoneCover;
import sunsetsatellite.signalindustries.tiles.base.TileEntityCoverable;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class NetworkMessageRedstoneCoverSetFilter
implements NetworkMessage {
    public Vec3i pos;
    public Class<? extends TileEntity> tileClass;
    public ItemStack stack;
    public Direction dir;

    public NetworkMessageRedstoneCoverSetFilter(Vec3i pos, ItemStack stack, Class<? extends TileEntity> tileClass, Direction dir) {
        this.pos = pos;
        this.stack = stack;
        this.tileClass = tileClass;
        this.dir = dir;
    }

    public NetworkMessageRedstoneCoverSetFilter() {
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        packet.writeInt(this.dir.ordinal());
        CompoundTag nbt = new CompoundTag();
        this.pos.writeToNBT(nbt);
        packet.writeCompoundTag(nbt);
        packet.writeString(TileEntityDispatcher.getIDFromClass(this.tileClass).toString());
        if (this.stack == null) {
            packet.writeInt(-1);
        } else {
            packet.writeInt(1);
            nbt = new CompoundTag();
            this.stack.writeToNBT(nbt);
            packet.writeCompoundTag(nbt);
        }
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        this.dir = Direction.values()[packet.readInt()];
        this.pos = new Vec3i(packet.readCompoundTag());
        this.tileClass = TileEntityDispatcher.getClassFromID((String)packet.readString());
        this.stack = packet.readInt() == -1 ? null : ItemStack.readItemStackFromNbt((CompoundTag)packet.readCompoundTag());
    }

    public void handle(NetworkMessage.NetworkContext context) {
        TileEntity tileEntity;
        if (EnvironmentHelper.isServerEnvironment() && context.player.world != null && (tileEntity = context.player.world.getTileEntity(this.pos.x, this.pos.y, this.pos.z)) instanceof TileEntityCoverable && tileEntity.worldObj != null) {
            TileEntityCoverable machine = (TileEntityCoverable)tileEntity;
            ((RedstoneCover)machine.getCovers().get((Object)this.dir)).sensorStack = this.stack;
        }
    }
}

