/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.recipes.entry;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeGroup;
import net.minecraft.core.data.registry.recipe.RecipeNamespace;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.fluids.util.RecipeExtendedSymbol;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntrySI;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMultiblock;
import sunsetsatellite.signalindustries.util.RecipeProperties;

public class RecipeEntryMachine
extends RecipeEntrySI<RecipeExtendedSymbol[], ItemStack, RecipeProperties> {
    public static final ItemStack AIR = new ItemStack(0, 0, 0, new CompoundTag());

    public RecipeEntryMachine(RecipeExtendedSymbol[] input, ItemStack output, RecipeProperties data) {
        super(input, output, data);
    }

    public RecipeEntryMachine() {
    }

    @Override
    public boolean matches(RecipeExtendedSymbol[] symbols) {
        if (symbols.length == 0) {
            return false;
        }
        HashMap<RecipeExtendedSymbol, RecipeExtendedSymbol> alreadyMatched = new HashMap<RecipeExtendedSymbol, RecipeExtendedSymbol>();
        block0: for (RecipeExtendedSymbol invInputSymbol2 : symbols) {
            for (RecipeExtendedSymbol recipeInputSymbol2 : (RecipeExtendedSymbol[])this.getInput()) {
                if (!recipeInputSymbol2.matches(invInputSymbol2) || alreadyMatched.containsKey(recipeInputSymbol2)) continue;
                alreadyMatched.put(recipeInputSymbol2, invInputSymbol2);
                continue block0;
            }
        }
        if (alreadyMatched.size() != ((RecipeExtendedSymbol[])this.getInput()).length) {
            return false;
        }
        HashMap alreadyMatchedResolved = new HashMap();
        alreadyMatched.forEach((recipeInputSymbol, invInputSymbol) -> alreadyMatchedResolved.put(recipeInputSymbol.asNormalSymbol().resolve(), invInputSymbol.asNormalSymbol().resolve()));
        return alreadyMatchedResolved.entrySet().stream().allMatch(e -> ((List)e.getKey()).stream().anyMatch(s -> ((List)e.getValue()).stream().anyMatch(s2 -> s.stackSize <= s2.stackSize)));
    }

    @Override
    public boolean matchesQuery(SearchQuery query) {
        switch (query.mode) {
            case ALL: {
                if (!this.matchesRecipe(query) && !this.matchesUsage(query) || !this.matchesScope(query)) break;
                return true;
            }
            case RECIPE: {
                if (!this.matchesRecipe(query) || !this.matchesScope(query)) break;
                return true;
            }
            case USAGE: {
                if (!this.matchesUsage(query) || !this.matchesScope(query)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean matchesScope(SearchQuery query) {
        if (query.scope.getLeft() == SearchQuery.SearchScope.NONE) {
            return true;
        }
        if (query.scope.getLeft() == SearchQuery.SearchScope.NAMESPACE) {
            RecipeNamespace namespace = (RecipeNamespace)Registries.RECIPES.getItem((String)query.scope.getRight());
            return namespace == this.parent.getParent();
        }
        if (query.scope.getLeft() == SearchQuery.SearchScope.NAMESPACE_GROUP) {
            RecipeGroup group;
            try {
                group = Registries.RECIPES.getGroupFromKey((String)query.scope.getRight());
            }
            catch (IllegalArgumentException e) {
                group = null;
            }
            return group == this.parent;
        }
        return false;
    }

    @Override
    public boolean matchesRecipe(SearchQuery query) {
        if (query.query.getLeft() == SearchQuery.QueryType.NAME) {
            if (query.strict && ((ItemStack)this.getOutput()).getDisplayName().equalsIgnoreCase((String)query.query.getRight())) {
                return true;
            }
            return !query.strict && ((ItemStack)this.getOutput()).getDisplayName().toLowerCase().contains(((String)query.query.getRight()).toLowerCase());
        }
        if (query.query.getLeft() == SearchQuery.QueryType.GROUP && !Objects.equals(query.query.getRight(), "")) {
            List groupStacks = new RecipeSymbol((String)query.query.getRight()).resolve();
            if (groupStacks == null) {
                return false;
            }
            return groupStacks.contains(this.getOutput());
        }
        return false;
    }

    @Override
    public boolean matchesUsage(SearchQuery query) {
        RecipeExtendedSymbol[] symbols;
        for (RecipeExtendedSymbol symbol : symbols = (RecipeExtendedSymbol[])this.getInput()) {
            if (symbol == null) continue;
            List stacks = symbol.resolve();
            if (query.query.getLeft() == SearchQuery.QueryType.NAME) {
                if (stacks == null) {
                    return false;
                }
                for (ItemStack stack : stacks) {
                    if (query.strict && stack.getDisplayName().equalsIgnoreCase((String)query.query.getRight())) {
                        return true;
                    }
                    if (query.strict || !stack.getDisplayName().toLowerCase().contains(((String)query.query.getRight()).toLowerCase())) continue;
                    return true;
                }
                continue;
            }
            if (query.query.getLeft() != SearchQuery.QueryType.GROUP || Objects.equals(query.query.getRight(), "")) continue;
            List groupStacks = new RecipeExtendedSymbol((String)query.query.getRight()).resolve();
            if (groupStacks == null) {
                return false;
            }
            if (!stacks.stream().anyMatch(groupStacks::contains)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void consumeMultiblockInputs(TileEntityTieredMultiblock multiblock) {
        Optional<ItemStack> remainingRecipeStack;
        Optional<ItemStack> recipeStack;
        if (multiblock.usesItemInput) {
            ArrayList recipeStacks = Catalyst.condenseItemList(Arrays.stream((RecipeExtendedSymbol[])this.getInput()).flatMap(symbol -> symbol.resolve().stream()).filter(Objects::nonNull).map(ItemStack::copy).collect(Collectors.toList()));
            List remainingRecipeStacks = recipeStacks.stream().map(ItemStack::copy).collect(Collectors.toList());
            for (int i = 0; i < multiblock.itemInput.itemContents.length; ++i) {
                ItemStack inputStack = multiblock.itemInput.getItem(i);
                if (inputStack != null && inputStack.getItem().hasContainerItem() && !((RecipeProperties)this.getData()).consumeContainers) {
                    multiblock.itemInput.setItem(i, new ItemStack(inputStack.getItem().getContainerItem()));
                    continue;
                }
                if (inputStack == null) continue;
                recipeStack = recipeStacks.stream().filter(stack -> stack.isItemEqual(inputStack)).findFirst();
                remainingRecipeStack = remainingRecipeStacks.stream().filter(stack -> stack.isItemEqual(inputStack)).findFirst();
                recipeStack.ifPresent(stack -> remainingRecipeStack.ifPresent(remainingStack -> {
                    if (remainingStack.stackSize > 0) {
                        int willTake = Math.min(stack.stackSize * multiblock.parallel, inputStack.stackSize);
                        inputStack.stackSize -= willTake;
                        remainingStack.stackSize -= stack.stackSize;
                    }
                }));
                if (inputStack.stackSize > 0) continue;
                multiblock.itemInput.setItem(i, null);
            }
        }
        if (multiblock.usesFluidInput) {
            for (int i = 0; i < multiblock.fluidInput.fluidContents.length; ++i) {
                FluidStack inputStack = multiblock.fluidInput.getFluidInSlot(i);
                List recipeStacks = Arrays.stream((RecipeExtendedSymbol[])this.getInput()).flatMap(symbol -> symbol.resolveFluids().stream()).filter(Objects::nonNull).map(FluidStack::copy).collect(Collectors.toList());
                List remainingRecipeStacks = recipeStacks.stream().map(FluidStack::copy).collect(Collectors.toList());
                if (inputStack == null) continue;
                recipeStack = recipeStacks.stream().filter(stack -> stack.isFluidEqual(inputStack)).findFirst();
                remainingRecipeStack = remainingRecipeStacks.stream().filter(stack -> stack.isFluidEqual(inputStack)).findFirst();
                recipeStack.ifPresent(stack -> remainingRecipeStack.ifPresent(remainingStack -> {
                    if (remainingStack.amount > 0) {
                        int willTake = Math.min(stack.amount * multiblock.parallel, inputStack.amount);
                        inputStack.amount -= willTake;
                        remainingStack.amount -= stack.amount;
                    }
                }));
                if (inputStack.amount > 0) continue;
                multiblock.fluidInput.setFluidInSlot(i, null);
            }
        }
    }

    @Override
    public boolean canMultiblockProcess(TileEntityTieredMultiblock multiblock) {
        return multiblock.areItemOutputsValid((ItemStack)this.getOutput());
    }

    @Override
    public void processMultiblockRecipe(TileEntityTieredMultiblock multiblock) {
        ItemStack stack;
        ItemStack itemStack = stack = this.getOutput() == null ? null : ((ItemStack)this.getOutput()).copy();
        if (stack != null) {
            multiblock.consumeInputs();
            if (multiblock.random.nextFloat() <= ((RecipeProperties)this.getData()).chance) {
                int multiplier = 1;
                int outputAmountRemaining = stack.stackSize * (multiplier *= multiblock.parallel);
                for (int i = 0; i < multiblock.itemOutput.itemContents.length; ++i) {
                    int willTake;
                    int maxAmountInSlot;
                    ItemStack outputStack = multiblock.itemOutput.itemContents[i];
                    if (outputStack == null) {
                        maxAmountInSlot = stack.getMaxStackSize();
                        if (maxAmountInSlot <= 0 || (willTake = Math.min(outputAmountRemaining, maxAmountInSlot)) <= 0) continue;
                        ItemStack copy = stack.copy();
                        copy.stackSize = willTake;
                        multiblock.itemOutput.setItem(i, copy);
                        if ((outputAmountRemaining -= willTake) > 0) continue;
                        break;
                    }
                    if (!outputStack.isItemEqual(stack) || (maxAmountInSlot = stack.getMaxStackSize() - outputStack.stackSize) <= 0 || (willTake = Math.min(outputAmountRemaining, maxAmountInSlot)) <= 0) continue;
                    outputStack.stackSize += willTake;
                    if ((outputAmountRemaining -= willTake) <= 0) break;
                }
            }
        }
    }
}

