/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.recipes.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeGroup;
import net.minecraft.core.data.registry.recipe.RecipeNamespace;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.item.ItemStack;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.catalyst.fluids.util.RecipeExtendedSymbol;
import sunsetsatellite.signalindustries.recipes.entry.RecipeEntrySI;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMultiblock;
import sunsetsatellite.signalindustries.util.RecipeOutputStack;
import sunsetsatellite.signalindustries.util.RecipeProperties;

public class RecipeEntryMachineMultiOutput
extends RecipeEntrySI<RecipeExtendedSymbol[], RecipeOutputStack[], RecipeProperties> {
    public RecipeEntryMachineMultiOutput(RecipeExtendedSymbol[] input, RecipeOutputStack[] output, RecipeProperties data) {
        super(input, output, data);
    }

    @Override
    public boolean matches(RecipeExtendedSymbol[] symbols) {
        if (symbols.length == 0) {
            return false;
        }
        HashMap<RecipeExtendedSymbol, RecipeExtendedSymbol> alreadyMatched = new HashMap<RecipeExtendedSymbol, RecipeExtendedSymbol>();
        block0: for (RecipeExtendedSymbol invInputSymbol2 : symbols) {
            for (RecipeExtendedSymbol recipeInputSymbol2 : (RecipeExtendedSymbol[])this.getInput()) {
                if (!recipeInputSymbol2.matches(invInputSymbol2) || alreadyMatched.containsKey(recipeInputSymbol2)) continue;
                alreadyMatched.put(recipeInputSymbol2, invInputSymbol2);
                continue block0;
            }
        }
        if (alreadyMatched.size() != ((RecipeExtendedSymbol[])this.getInput()).length) {
            return false;
        }
        HashMap alreadyMatchedResolved = new HashMap();
        alreadyMatched.forEach((recipeInputSymbol, invInputSymbol) -> alreadyMatchedResolved.put(recipeInputSymbol.asNormalSymbol().resolve(), invInputSymbol.asNormalSymbol().resolve()));
        return alreadyMatchedResolved.entrySet().stream().allMatch(e -> ((List)e.getKey()).stream().anyMatch(s -> ((List)e.getValue()).stream().anyMatch(s2 -> s.stackSize <= s2.stackSize)));
    }

    @Override
    public boolean matchesQuery(SearchQuery query) {
        switch (query.mode) {
            case ALL: {
                if (!this.matchesRecipe(query) && !this.matchesUsage(query) || !this.matchesScope(query)) break;
                return true;
            }
            case RECIPE: {
                if (!this.matchesRecipe(query) || !this.matchesScope(query)) break;
                return true;
            }
            case USAGE: {
                if (!this.matchesUsage(query) || !this.matchesScope(query)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean matchesScope(SearchQuery query) {
        if (query.scope.getLeft() == SearchQuery.SearchScope.NONE) {
            return true;
        }
        if (query.scope.getLeft() == SearchQuery.SearchScope.NAMESPACE) {
            RecipeNamespace namespace = (RecipeNamespace)Registries.RECIPES.getItem((String)query.scope.getRight());
            return namespace == this.parent.getParent();
        }
        if (query.scope.getLeft() == SearchQuery.SearchScope.NAMESPACE_GROUP) {
            RecipeGroup group;
            try {
                group = Registries.RECIPES.getGroupFromKey((String)query.scope.getRight());
            }
            catch (IllegalArgumentException e) {
                group = null;
            }
            return group == this.parent;
        }
        return false;
    }

    @Override
    public boolean matchesRecipe(SearchQuery query) {
        if (query.query.getLeft() == SearchQuery.QueryType.NAME) {
            if (!query.strict) {
                return Arrays.stream((RecipeOutputStack[])this.getOutput()).anyMatch(O -> {
                    if (O.isItem()) {
                        return O.stack.getDisplayName().toLowerCase().contains(((String)query.query.getRight()).toLowerCase());
                    }
                    if (O.isFluid()) {
                        return O.fluid.fluid.getName().toLowerCase().contains(((String)query.query.getRight()).toLowerCase());
                    }
                    return false;
                });
            }
            return Arrays.stream((RecipeOutputStack[])this.getOutput()).anyMatch(O -> {
                if (O.isItem()) {
                    return O.stack.getDisplayName().equalsIgnoreCase((String)query.query.getRight());
                }
                if (O.isFluid()) {
                    return O.fluid.fluid.getName().equalsIgnoreCase((String)query.query.getRight());
                }
                return false;
            });
        }
        if (query.query.getLeft() == SearchQuery.QueryType.GROUP && !Objects.equals(query.query.getRight(), "")) {
            List groupStacks = new RecipeSymbol((String)query.query.getRight()).resolve();
            if (groupStacks == null) {
                return false;
            }
            return Arrays.stream((RecipeOutputStack[])this.getOutput()).anyMatch(O -> {
                if (O.isItem()) {
                    return groupStacks.stream().anyMatch(S -> S.isItemEqual(O.stack));
                }
                if (O.isFluid()) {
                    return groupStacks.stream().anyMatch(S -> S.isItemEqual(O.fluid.toItemStack()));
                }
                return false;
            });
        }
        return false;
    }

    @Override
    public boolean matchesUsage(SearchQuery query) {
        RecipeExtendedSymbol[] symbols;
        for (RecipeExtendedSymbol symbol : symbols = (RecipeExtendedSymbol[])this.getInput()) {
            if (symbol == null) continue;
            List stacks = symbol.resolve();
            if (query.query.getLeft() == SearchQuery.QueryType.NAME) {
                if (stacks == null) {
                    return false;
                }
                for (ItemStack stack : stacks) {
                    if (query.strict && stack.getDisplayName().equalsIgnoreCase((String)query.query.getRight())) {
                        return true;
                    }
                    if (query.strict || !stack.getDisplayName().toLowerCase().contains(((String)query.query.getRight()).toLowerCase())) continue;
                    return true;
                }
                continue;
            }
            if (query.query.getLeft() != SearchQuery.QueryType.GROUP || Objects.equals(query.query.getRight(), "")) continue;
            List groupStacks = new RecipeExtendedSymbol((String)query.query.getRight()).resolve();
            if (groupStacks == null) {
                return false;
            }
            if (!stacks.stream().anyMatch(groupStacks::contains)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void consumeMultiblockInputs(TileEntityTieredMultiblock multiblock) {
        Optional<ItemStack> remainingRecipeStack;
        Optional<ItemStack> recipeStack;
        if (multiblock.usesItemInput) {
            ArrayList recipeStacks = Catalyst.condenseItemList(Arrays.stream((RecipeExtendedSymbol[])this.getInput()).flatMap(symbol -> symbol.resolve().stream()).filter(Objects::nonNull).map(ItemStack::copy).collect(Collectors.toList()));
            List remainingRecipeStacks = recipeStacks.stream().map(ItemStack::copy).collect(Collectors.toList());
            for (int i = 0; i < multiblock.itemInput.itemContents.length; ++i) {
                ItemStack inputStack = multiblock.itemInput.getItem(i);
                if (inputStack != null && inputStack.getItem().hasContainerItem() && !((RecipeProperties)this.getData()).consumeContainers) {
                    multiblock.itemInput.setItem(i, new ItemStack(inputStack.getItem().getContainerItem()));
                    continue;
                }
                if (inputStack == null) continue;
                recipeStack = recipeStacks.stream().filter(stack -> stack.isItemEqual(inputStack)).findFirst();
                remainingRecipeStack = remainingRecipeStacks.stream().filter(stack -> stack.isItemEqual(inputStack)).findFirst();
                recipeStack.ifPresent(stack -> remainingRecipeStack.ifPresent(remainingStack -> {
                    if (remainingStack.stackSize > 0) {
                        int willTake = Math.min(stack.stackSize * multiblock.parallel, inputStack.stackSize);
                        inputStack.stackSize -= willTake;
                        remainingStack.stackSize -= stack.stackSize;
                    }
                }));
                if (inputStack.stackSize > 0) continue;
                multiblock.itemInput.setItem(i, null);
            }
        }
        if (multiblock.usesFluidInput) {
            for (int i = 0; i < multiblock.fluidInput.fluidContents.length; ++i) {
                FluidStack inputStack = multiblock.fluidInput.getFluidInSlot(i);
                List recipeStacks = Arrays.stream((RecipeExtendedSymbol[])this.getInput()).flatMap(symbol -> symbol.resolveFluids().stream()).filter(Objects::nonNull).map(FluidStack::copy).collect(Collectors.toList());
                List remainingRecipeStacks = recipeStacks.stream().map(FluidStack::copy).collect(Collectors.toList());
                if (inputStack == null) continue;
                recipeStack = recipeStacks.stream().filter(stack -> stack.isFluidEqual(inputStack)).findFirst();
                remainingRecipeStack = remainingRecipeStacks.stream().filter(stack -> stack.isFluidEqual(inputStack)).findFirst();
                recipeStack.ifPresent(stack -> remainingRecipeStack.ifPresent(remainingStack -> {
                    if (remainingStack.amount > 0) {
                        int willTake = Math.min(stack.amount * multiblock.parallel, inputStack.amount);
                        inputStack.amount -= willTake;
                        remainingStack.amount -= stack.amount;
                    }
                }));
                if (inputStack.amount > 0) continue;
                multiblock.fluidInput.setFluidInSlot(i, null);
            }
        }
    }

    @Override
    public boolean canMultiblockProcess(TileEntityTieredMultiblock multiblock) {
        for (RecipeOutputStack output : (RecipeOutputStack[])this.getOutput()) {
            ItemStack stack;
            if (output.isItem()) {
                stack = output.stack.copy();
                int n = stack.stackSize = output.randomAmount ? output.amountMax : stack.stackSize;
                if (multiblock.areItemOutputsValid(stack)) continue;
                return false;
            }
            if (!output.isFluid()) continue;
            stack = output.fluid.copy();
            int n = stack.amount = output.randomAmount ? output.amountMax : stack.amount;
            if (multiblock.areFluidOutputsValid((FluidStack)stack)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void processMultiblockRecipe(TileEntityTieredMultiblock multiblock) {
        multiblock.consumeInputs();
        if (multiblock.random.nextFloat() <= ((RecipeProperties)this.getData()).chance) {
            block0: for (RecipeOutputStack outputStack : (RecipeOutputStack[])this.getOutput()) {
                FluidStack fluidStack;
                ItemStack copy;
                int willTake;
                int maxAmountInSlot;
                int i;
                int outputAmountRemaining;
                int multiplier;
                if (outputStack.isItem()) {
                    ItemStack stack;
                    ItemStack itemStack = stack = this.getOutput() == null ? null : outputStack.stack.copy();
                    if (stack != null && outputStack.randomAmount) {
                        stack.stackSize = Catalyst.random((Random)multiblock.random, (int)outputStack.amountMin, (int)(outputStack.amountMax + 1));
                    }
                    if (stack == null || !(multiblock.random.nextFloat() <= outputStack.chance)) continue;
                    multiplier = 1;
                    outputAmountRemaining = stack.stackSize * (multiplier *= multiblock.parallel);
                    for (i = 0; i < multiblock.itemOutput.itemContents.length; ++i) {
                        ItemStack busStack = multiblock.itemOutput.itemContents[i];
                        if (busStack == null) {
                            maxAmountInSlot = stack.getMaxStackSize();
                            if (maxAmountInSlot <= 0 || (willTake = Math.min(outputAmountRemaining, maxAmountInSlot)) <= 0) continue;
                            copy = stack.copy();
                            copy.stackSize = willTake;
                            multiblock.itemOutput.setItem(i, copy);
                            if ((outputAmountRemaining -= willTake) > 0) continue;
                            continue block0;
                        }
                        if (!busStack.isItemEqual(stack) || (maxAmountInSlot = stack.getMaxStackSize() - busStack.stackSize) <= 0 || (willTake = Math.min(outputAmountRemaining, maxAmountInSlot)) <= 0) continue;
                        busStack.stackSize += willTake;
                        if ((outputAmountRemaining -= willTake) <= 0) continue block0;
                    }
                    continue;
                }
                if (!outputStack.isFluid()) continue;
                FluidStack fluidStack2 = fluidStack = this.getOutput() == null ? null : outputStack.fluid.copy();
                if (fluidStack != null && outputStack.randomAmount) {
                    fluidStack.amount = Catalyst.random((Random)multiblock.random, (int)outputStack.amountMin, (int)(outputStack.amountMax + 1));
                }
                if (fluidStack == null || !(multiblock.random.nextFloat() <= outputStack.chance)) continue;
                multiplier = 1;
                outputAmountRemaining = fluidStack.amount * (multiplier *= multiblock.parallel);
                for (i = 0; i < multiblock.fluidOutput.itemContents.length; ++i) {
                    FluidStack hatchStack = multiblock.fluidOutput.fluidContents[i];
                    if (hatchStack == null) {
                        maxAmountInSlot = multiblock.fluidOutput.getFluidInSlot((int)i).amount;
                        if (maxAmountInSlot <= 0 || (willTake = Math.min(outputAmountRemaining, maxAmountInSlot)) <= 0) continue;
                        copy = fluidStack.copy();
                        copy.amount = willTake;
                        multiblock.fluidOutput.setFluidInSlot(i, (FluidStack)copy);
                        if ((outputAmountRemaining -= willTake) > 0) continue;
                        continue block0;
                    }
                    if (!hatchStack.isFluidEqual(fluidStack) || (maxAmountInSlot = multiblock.fluidOutput.getFluidCapacityForSlot(i) - hatchStack.amount) <= 0 || (willTake = Math.min(outputAmountRemaining, maxAmountInSlot)) <= 0) continue;
                    hatchStack.amount += willTake;
                    if ((outputAmountRemaining -= willTake) <= 0) continue block0;
                }
            }
        }
    }
}

