/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.render;

import java.util.ArrayList;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.HologramWorld;
import sunsetsatellite.catalyst.core.util.model.IColorOverride;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidContainer;
import sunsetsatellite.signalindustries.render.entity.EntityRendererFakeItem;

public class RenderFluidInBlock
extends TileEntityRenderer<TileEntity> {
    private RenderBlocks blockRenderer;
    private final EntityRendererFakeItem itemRenderer = new EntityRendererFakeItem();

    public void doRender(Tessellator tessellator, TileEntity tileEntity1, double d2, double d4, double d6, float f8) {
        float fluidAmount = 0.0f;
        float fluidMaxAmount = 1.0f;
        int fluidId = -1;
        if (((TileEntityFluidContainer)tileEntity1).fluidContents[0] != null && ((TileEntityFluidContainer)tileEntity1).fluidContents[0].fluid != null) {
            fluidMaxAmount = ((TileEntityFluidContainer)tileEntity1).getFluidCapacityForSlot(0);
            fluidAmount = ((TileEntityFluidContainer)tileEntity1).fluidContents[0].amount;
            fluidId = ((TileEntityFluidContainer)tileEntity1).fluidContents[0].fluid.getFirstId();
        }
        float amount = Math.abs(fluidAmount / fluidMaxAmount - 0.02f);
        amount = MathHelper.clamp((float)amount, (float)0.0f, (float)1.0f);
        if (fluidId != -1) {
            Block block = Blocks.blocksList[fluidId];
            this.blockRenderer = new RenderBlocks((WorldSource)new HologramWorld((ArrayList)Catalyst.listOf((Object[])new BlockInstance[]{new BlockInstance(block, new Vec3i(), 0, null)})));
            BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch((Object)block);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d2), (float)((float)d4), (float)((float)d6));
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)0.98f, (float)amount, (float)0.98f);
            GL11.glTranslatef((float)0.51f, (float)0.505f, (float)0.51f);
            GL11.glDisable((int)2896);
            if (block == Blocks.FLUID_WATER_FLOWING || block == Blocks.FLUID_WATER_STILL) {
                ((IColorOverride)model).enableColorOverride();
                ((IColorOverride)model).overrideColor(0.0f, 0.5f, 1.0f, 0.75f);
            }
            this.drawBlock(tessellator, model, 0);
            GL11.glEnable((int)2896);
            ((IColorOverride)model).overrideColor(1.0f, 1.0f, 1.0f, 1.0f);
            ((IColorOverride)model).disableColorOverride();
            GL11.glPopMatrix();
        }
    }

    public void drawBlock(Tessellator tessellator, BlockModel<?> model, int meta) {
        TextureRegistry.blockAtlas.bind();
        GL11.glPushMatrix();
        RenderBlocks renderBlocks = BlockModel.renderBlocks;
        BlockModel.setRenderBlocks((RenderBlocks)this.blockRenderer);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        model.renderBlockOnInventory(tessellator, meta, 1.0f, 0.75f, null);
        BlockModel.setRenderBlocks((RenderBlocks)renderBlocks);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glEnable((int)2884);
    }
}

