/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.render;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.HologramWorld;
import sunsetsatellite.catalyst.core.util.model.IColorOverride;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.api.IFluidInventory;
import sunsetsatellite.catalyst.fluids.impl.tile.TileEntityFluidContainer;
import sunsetsatellite.signalindustries.SIBlocks;
import sunsetsatellite.signalindustries.SignalIndustries;
import sunsetsatellite.signalindustries.blocks.logic.BlockLogicConduit;
import sunsetsatellite.signalindustries.blocks.logic.BlockLogicFluidConduit;

public class RenderFluidInConduit
extends TileEntityRenderer<TileEntity> {
    private RenderBlocks blockRenderer;

    public void doRender(Tessellator tessellator, TileEntity tileEntity1, double d2, double d4, double d6, float f8) {
        this.blockRenderer = new RenderBlocks((WorldSource)tileEntity1.worldObj);
        int i = tileEntity1.x;
        int j = tileEntity1.y;
        int k = tileEntity1.z;
        World blockAccess = tileEntity1.worldObj;
        Block block = SIBlocks.prototypeConduit;
        if (tileEntity1.getBlock() != null) {
            block = tileEntity1.getBlock();
        }
        float fluidAmount = 0.0f;
        float fluidMaxAmount = 1.0f;
        int fluidId = -1;
        if (((TileEntityFluidContainer)tileEntity1).fluidContents[0] != null && ((TileEntityFluidContainer)tileEntity1).fluidContents[0].fluid != null) {
            fluidMaxAmount = ((TileEntityFluidContainer)tileEntity1).getFluidCapacityForSlot(0);
            fluidAmount = ((TileEntityFluidContainer)tileEntity1).fluidContents[0].amount;
            fluidId = ((TileEntityFluidContainer)tileEntity1).fluidContents[0].fluid.getFirstId();
        }
        BlockModel model = null;
        if (fluidId != -1) {
            Block fluidBlock = Blocks.getBlock((int)fluidId);
            this.blockRenderer = new RenderBlocks((WorldSource)new HologramWorld((ArrayList)Catalyst.listOf((Object[])new BlockInstance[]{new BlockInstance(fluidBlock, new Vec3i(), 0, null)})));
            model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch((Object)fluidBlock);
        }
        if (model == null) {
            return;
        }
        fluidAmount = Math.min(fluidAmount, fluidMaxAmount);
        HashMap<Direction, Boolean> states = new HashMap<Direction, Boolean>();
        for (Direction direction : Direction.values()) {
            boolean show = false;
            Vec3i offset = new Vec3i(i, j, k).add(direction.getVec());
            Block neighbouringBlock = blockAccess.getBlock(offset.x, offset.y, offset.z);
            if (neighbouringBlock != null) {
                if (block.getLogic().getClass().isAssignableFrom(neighbouringBlock.getLogic().getClass())) {
                    show = true;
                } else if (!(neighbouringBlock.getLogic() instanceof BlockLogicConduit) && !(neighbouringBlock.getLogic() instanceof BlockLogicFluidConduit)) {
                    if (neighbouringBlock.isEntityTile) {
                        TileEntity neighbouringTile = blockAccess.getTileEntity(offset.x, offset.y, offset.z);
                        if (neighbouringTile instanceof IFluidInventory) {
                            show = true;
                        }
                    } else if (neighbouringBlock.hasTag(SignalIndustries.SIGNALUM_CONDUITS_CONNECT) || neighbouringBlock.hasTag(SignalIndustries.FLUID_CONDUITS_CONNECT)) {
                        show = true;
                    }
                }
            }
            states.put(direction, show);
        }
        float amount = fluidAmount / fluidMaxAmount;
        float mapped = (float)Catalyst.map((double)amount, (double)0.0, (double)1.0, (double)0.0, (double)0.3);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d2 + 0.15f), (float)((float)d4 + 0.15f), (float)((float)d6 + 0.15f));
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.33f, (float)0.33f, (float)0.33f);
        if (!((Boolean)states.get(Direction.Y_NEG)).booleanValue() || !((Boolean)states.get(Direction.Y_POS)).booleanValue()) {
            GL11.glScalef((float)0.3f, (float)mapped, (float)0.3f);
        } else {
            GL11.glScalef((float)mapped, (float)0.3f, (float)mapped);
        }
        GL11.glDisable((int)2896);
        Block fluidBlock = Blocks.getBlock((int)fluidId);
        if (fluidBlock == Blocks.FLUID_WATER_FLOWING || fluidBlock == Blocks.FLUID_WATER_STILL) {
            ((IColorOverride)model).overrideColor(0.0f, 0.5f, 1.0f, 0.75f);
        }
        this.drawBlock(tessellator, model, 0);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
        if (((Boolean)states.get(Direction.getFromName((String)"EAST"))).booleanValue()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d2 + 0.15f), (float)((float)d4 + 0.15f), (float)((float)d6 + 0.15f));
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.66f, (float)0.33f, (float)0.33f);
            GL11.glScalef((float)0.3f, (float)mapped, (float)0.3f);
            GL11.glDisable((int)2896);
            this.drawBlock(tessellator, model, 0);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
        if (((Boolean)states.get(Direction.getFromName((String)"WEST"))).booleanValue()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d2 + 0.15f), (float)((float)d4 + 0.15f), (float)((float)d6 + 0.15f));
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.33f, (float)0.33f);
            GL11.glScalef((float)0.3f, (float)mapped, (float)0.3f);
            GL11.glDisable((int)2896);
            this.drawBlock(tessellator, model, 0);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
        if (((Boolean)states.get(Direction.getFromName((String)"UP"))).booleanValue()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d2 + 0.15f), (float)((float)d4 + 0.15f), (float)((float)d6 + 0.15f));
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.33f, (float)0.66f, (float)0.33f);
            GL11.glScalef((float)mapped, (float)0.3f, (float)mapped);
            GL11.glDisable((int)2896);
            this.drawBlock(tessellator, model, 0);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
        if (((Boolean)states.get(Direction.getFromName((String)"DOWN"))).booleanValue()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d2 + 0.15f), (float)((float)d4 + 0.15f), (float)((float)d6 + 0.15f));
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.33f, (float)0.0f, (float)0.33f);
            GL11.glScalef((float)mapped, (float)0.3f, (float)mapped);
            GL11.glDisable((int)2896);
            this.drawBlock(tessellator, model, 0);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
        if (((Boolean)states.get(Direction.getFromName((String)"SOUTH"))).booleanValue()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d2 + 0.15f), (float)((float)d4 + 0.15f), (float)((float)d6 + 0.15f));
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.33f, (float)0.33f, (float)0.66f);
            GL11.glScalef((float)0.3f, (float)mapped, (float)0.3f);
            GL11.glDisable((int)2896);
            this.drawBlock(tessellator, model, 0);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
        if (((Boolean)states.get(Direction.getFromName((String)"NORTH"))).booleanValue()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d2 + 0.15f), (float)((float)d4 + 0.15f), (float)((float)d6 + 0.15f));
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.33f, (float)0.33f, (float)0.0f);
            GL11.glScalef((float)0.3f, (float)mapped, (float)0.3f);
            GL11.glDisable((int)2896);
            this.drawBlock(tessellator, model, 0);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
        ((IColorOverride)model).overrideColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawBlock(Tessellator tessellator, BlockModel<?> model, int meta) {
        TextureRegistry.blockAtlas.bind();
        GL11.glPushMatrix();
        RenderBlocks renderBlocks = BlockModel.renderBlocks;
        BlockModel.setRenderBlocks((RenderBlocks)this.blockRenderer);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        model.renderBlockOnInventory(tessellator, meta, 1.0f, 0.75f, null);
        BlockModel.setRenderBlocks((RenderBlocks)renderBlocks);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glEnable((int)2884);
    }
}

