/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.render;

import java.util.ArrayList;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.HologramWorld;
import sunsetsatellite.catalyst.core.util.model.IColorOverride;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import sunsetsatellite.catalyst.fluids.util.FluidStack;
import sunsetsatellite.signalindustries.tiles.base.TileEntityTieredMachineSimple;

public class RenderStoneworks
extends TileEntityRenderer<TileEntity> {
    private RenderBlocks blockRenderer;

    public void doRender(Tessellator tessellator, TileEntity tileEntity1, double d2, double d4, double d6, float f8) {
        TileEntityTieredMachineSimple tile = (TileEntityTieredMachineSimple)tileEntity1;
        FluidStack[] fluidContents = tile.fluidContents;
        float fluidMaxAmount = 0.0f;
        for (int i = 0; i < tile.fluidCapacity.length; ++i) {
            if (i == tile.energySlot) continue;
            fluidMaxAmount += (float)tile.fluidCapacity[i];
        }
        ArrayList<BlockInstance> list = new ArrayList<BlockInstance>();
        for (int i = 0; i < fluidContents.length; ++i) {
            FluidStack fluidStack;
            if (i == tile.energySlot || (fluidStack = fluidContents[i]) == null) continue;
            Block block = Blocks.blocksList[fluidStack.fluid.getFirstId()];
            list.add(new BlockInstance(block, new Vec3i(), 0, null));
        }
        if (fluidMaxAmount <= 0.0f) {
            fluidMaxAmount = 1.0f;
        }
        this.blockRenderer = new RenderBlocks((WorldSource)new HologramWorld(list));
        float i = 0.0f;
        for (int j = 0; j < fluidContents.length; ++j) {
            FluidStack fluidStack = fluidContents[j];
            if (j == tile.energySlot || fluidStack == null) continue;
            float fluidAmount = fluidStack.amount;
            int fluidId = fluidStack.fluid.getFirstId();
            float amount = 0.49f;
            if (fluidId == 0) continue;
            Block block = Blocks.blocksList[fluidStack.fluid.getFirstId()];
            BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch((Object)block);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d2), (float)((float)d4 + i), (float)((float)d6));
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)0.98f, (float)amount, (float)0.98f);
            GL11.glTranslatef((float)0.51f, (float)0.5f, (float)0.51f);
            GL11.glDisable((int)2896);
            i += 1.0f * amount;
            if (block == Blocks.FLUID_WATER_FLOWING || block == Blocks.FLUID_WATER_STILL) {
                ((IColorOverride)model).enableColorOverride();
                ((IColorOverride)model).overrideColor(0.0f, 0.5f, 1.0f, 0.75f);
            }
            this.drawBlock(tessellator, model, 0);
            GL11.glEnable((int)2896);
            ((IColorOverride)model).overrideColor(1.0f, 1.0f, 1.0f, 1.0f);
            ((IColorOverride)model).disableColorOverride();
            GL11.glPopMatrix();
        }
    }

    public void drawBlock(Tessellator tessellator, BlockModel<?> model, int meta) {
        TextureRegistry.blockAtlas.bind();
        GL11.glPushMatrix();
        RenderBlocks renderBlocks = BlockModel.renderBlocks;
        BlockModel.setRenderBlocks((RenderBlocks)this.blockRenderer);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        model.renderBlockOnInventory(tessellator, meta, 1.0f, 0.75f, null);
        BlockModel.setRenderBlocks((RenderBlocks)renderBlocks);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glEnable((int)2884);
    }
}

