/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.render.entity;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class EntityRendererFakeItem
extends EntityRenderer<EntityItem> {
    public final RenderBlocks renderBlocks = new RenderBlocks();
    private final Random random = new Random();
    public boolean useColor = true;

    public EntityRendererFakeItem() {
        this.shadowSize = 0.15f;
        this.shadowOpacity = 0.75f;
    }

    public int getItemColorFromMetadata(Item item, int metadata) {
        if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).getBlock();
            return ((BlockColor)BlockColorDispatcher.getInstance().getDispatch((Object)block)).getFallbackColor(metadata);
        }
        return 0xFFFFFF;
    }

    public void render(Tessellator tessellator, EntityItem entity, double x, double y, double z, float yaw, float partialTick) {
        float brightness = 1.0f;
        if (!LightmapHelper.isLightmapEnabled()) {
            brightness = entity.getBrightness(partialTick);
        }
        this.random.setSeed(187L);
        ItemStack itemstack = entity.item;
        if (itemstack == null) {
            return;
        }
        Item item = itemstack.getItem();
        if (item == null) {
            return;
        }
        GL11.glPushMatrix();
        float f3 = (float)Math.toDegrees(yaw / 20.0f);
        int renderCount = 1;
        if (entity.item.stackSize > 1) {
            renderCount = 2;
        }
        if (entity.item.stackSize > 5) {
            renderCount = 3;
        }
        if (entity.item.stackSize > 20) {
            renderCount = 4;
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        BlockModel.setRenderBlocks((RenderBlocks)this.renderBlocks);
        ((ItemModel)ItemModelDispatcher.getInstance().getDispatch((Object)item)).renderAsItemEntity(Tessellator.instance, (Entity)entity, this.random, itemstack, renderCount, f3, brightness, partialTick);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public void render(Tessellator tessellator, ItemStack stack, double x, double y, double z, float yaw, float partialTick) {
        float brightness = 1.0f;
        this.random.setSeed(187L);
        if (stack == null) {
            return;
        }
        Item item = stack.getItem();
        GL11.glPushMatrix();
        float f3 = (float)Math.toDegrees(yaw / 20.0f);
        int renderCount = 1;
        if (stack.stackSize > 1) {
            renderCount = 2;
        }
        if (stack.stackSize > 5) {
            renderCount = 3;
        }
        if (stack.stackSize > 20) {
            renderCount = 4;
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        BlockModel.setRenderBlocks((RenderBlocks)this.renderBlocks);
        ((ItemModel)ItemModelDispatcher.getInstance().getDispatch((Object)item)).renderAsItemEntity(Tessellator.instance, (Entity)new EntityItem((World)Minecraft.getMinecraft().currentWorld, x, y, z, stack), this.random, stack, renderCount, f3, brightness, partialTick);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }
}

