/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.signalindustries.screens;

import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.fluids.impl.MenuFluid;
import sunsetsatellite.catalyst.fluids.impl.ScreenFluid;
import sunsetsatellite.signalindustries.interfaces.IPlayerPowerSuit;
import sunsetsatellite.signalindustries.items.attachments.ItemBackpackAttachment;
import sunsetsatellite.signalindustries.menus.MenuBackpack;
import sunsetsatellite.signalindustries.util.InventorySerializer;

public class ScreenBackpack
extends ScreenFluid {
    public int backpackSlotIndex;
    public boolean isArmor;
    public ItemStack backpack;
    public Player player;

    public ScreenBackpack(ContainerInventory inventoryPlayer, int backpackSlotIndex, boolean isArmor) {
        super((MenuFluid)new MenuBackpack(inventoryPlayer, backpackSlotIndex, isArmor));
        this.backpackSlotIndex = backpackSlotIndex;
        this.isArmor = isArmor;
        this.player = inventoryPlayer.player;
        this.backpack = isArmor ? ((IPlayerPowerSuit)inventoryPlayer.player).getPowerSuit().getAttachmentClass(ItemBackpackAttachment.class) : inventoryPlayer.getItem(backpackSlotIndex);
        this.ySize = 168;
        this.xSize = 198;
        if (this.backpack != null && this.backpack.getItem() instanceof ItemBackpackAttachment) {
            switch (((ItemBackpackAttachment)this.backpack.getItem()).tier) {
                case REINFORCED: {
                    this.ySize = 223;
                }
            }
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f) {
        super.drawGuiContainerBackgroundLayer(f);
        Texture bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/basic_backpack.png");
        switch (((ItemBackpackAttachment)this.backpack.getItem()).getTier()) {
            case BASIC: {
                bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/basic_backpack.png");
                break;
            }
            case REINFORCED: {
                bg = this.mc.textureManager.loadTexture("/assets/signalindustries/gui/reinforced_backpack.png");
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(bg);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
    }

    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        int color = -1;
        String name = "";
        if (this.backpack.getItem() instanceof ItemBackpackAttachment) {
            name = I18n.getInstance().translateNameKey(this.fluidSlots.itemInventory.getNameTranslationKey());
            switch (((ItemBackpackAttachment)this.backpack.getItem()).tier) {
                case BASIC: {
                    color = -32640;
                    break;
                }
                case REINFORCED: {
                    color = -65536;
                }
            }
            this.font.drawCenteredString(name, 90, 6, color);
        }
    }

    public void removed() {
        super.removed();
        this.backpack = this.isArmor ? ((IPlayerPowerSuit)this.player).getPowerSuit().getAttachmentClass(ItemBackpackAttachment.class) : this.player.inventory.getItem(this.backpackSlotIndex);
        InventorySerializer.saveInvToNBT(this.backpack, this.fluidSlots.itemInventory);
    }
}

